/*
 * Copyright IBM Corporation 1987,1990
 *
 * All Rights Reserved
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted,
 * provided that the above copyright notice appear in all copies and that 
 * both that copyright notice and this permission notice appear in
 * supporting documentation, and that the name of IBM not be
 * used in advertising or publicity pertaining to distribution of the
 * software without specific, written prior permission.
 *
 * IBM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
 * ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL
 * IBM BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
 * ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
 * SOFTWARE.
 *
*/
/*
 * PRPQ 5799-PFF (C) COPYRIGHT IBM CORPORATION 1987,1990
 * LICENSED MATERIALS - PROPERTY OF IBM
 * REFER TO COPYRIGHT INSTRUCTIONS FORM NUMBER G120-2083
 */
/*
 *  Hardware interface routines for IBM 8514/A adapter for
 *  X.11 server(s) on IBM equipment.
 *
 */

/* $Header: /andrew/X11/r3src/r3plus/server/ddx/ibm/ibm8514/RCS/brcFillSp.c,v 6.3 89/05/07 15:18:34 jeff Exp $ */
/* $Source: /andrew/X11/r3src/r3plus/server/ddx/ibm/ibm8514/RCS/brcFillSp.c,v $ */

#ifndef lint
static char *rcsid = "$Header: /andrew/X11/r3src/r3plus/server/ddx/ibm/ibm8514/RCS/brcFillSp.c,v 6.3 89/05/07 15:18:34 jeff Exp $" ;
#endif

#include "X.h"
#include "misc.h"
#include "gcstruct.h"
#include "windowstr.h"
#include "window.h"
#include "pixmapstr.h"
#include "scrnintstr.h"

#include "OScompiler.h"

#include "ppc.h"
#include "ppcSpMcro.h"

#include "x8514.h"
#include "ibmTrace.h"

extern int mergexlate[] ;
extern int ibm8514cursorSemaphore ;
extern int mfbGCPrivateIndex;

void
ibm8514SolidFS( pDrawable, pGC, nInit, pptInit, pwidthInit, fSorted )
    DrawablePtr pDrawable ;
    GCPtr	pGC ;
    int		nInit ;			/* number of spans to fill */
    DDXPointPtr pptInit ;		/* pointer to list of start points */
    int		*pwidthInit ;		/* pointer to list of n widths */
    int 	fSorted ;
{
    register unsigned long int pm ;
    register unsigned long int fg ;
    register int alu ;
				/* next three parameters are post-clip */
    int n ;			/* number of spans to fill */
    register DDXPointPtr ppt ;	/* pointer to list of start points */
    register int *pwidth ;	/* pointer to list of n widths */
    int *pwidthFree ;		/* copies of the pointers to free */
    DDXPointPtr pptFree ;

TRACE(("ibm8514SolidFS((pDrawable = x%x, pGC = x%x, nInit = x%x, pptInit = x%x, pwidthInit = x%x, fSorted = x%x)\n",
	pDrawable, pGC, nInit, pptInit, pwidthInit, fSorted ) ) ;

    if ( pDrawable->depth == 1 )
    {
	ErrorF("ibm8514SolidFS: depth == 1\n") ;
	return ;
    }

    if (pDrawable->type != DRAWABLE_WINDOW)
    {
	ErrorF("ibm8514SolidFS: not a window\n") ;
	return ;
    }

    if ( ( alu = ( (ppcPrivGC *) pGC->devPrivates[mfbGCPrivateIndex].ptr )->colorRrop.alu ) == GXnoop )
	return ;

    pm = ( (ppcPrivGC *) pGC->devPrivates[mfbGCPrivateIndex].ptr )->colorRrop.planemask ;
    fg = ( (ppcPrivGC *) pGC->devPrivates[mfbGCPrivateIndex].ptr )->colorRrop.fgPixel ;

    SETSPANPTRS( nInit, n, pwidthInit, pwidth, pptInit, 
		 ppt, pwidthFree, pptFree, fSorted ) ;

    while ( n--)
	{
	if ( *pwidth )
		ibm8514DrawRectangle( fg, alu, pm,
				      ppt->x, ppt->y, *pwidth, 1 ) ;
	ppt++ ;
	pwidth++ ;
	}
    DEALLOCATE_LOCAL(pptFree) ;
    DEALLOCATE_LOCAL(pwidthFree) ;
    return ;
}

#ifndef OLDFS
void
ibm8514TileFS(pDrawable, pGC, nInit, pptInit, pwidthInit, fSorted)
DrawablePtr pDrawable ;
GC		*pGC ;
int		nInit ;		/* number of spans to fill */
DDXPointPtr pptInit ;		/* pointer to list of start points */
int *pwidthInit ;		/* pointer to list of n widths */
int fSorted ;
{
    register unsigned long int pm ;
    register int alu ;
				/* next three parameters are post-clip */
    int n ;			/* number of spans to fill */
    register DDXPointPtr ppt ;	/* pointer to list of start points */
    register int *pwidth ;	/* pointer to list of n widths */
    int *pwidthFree ;		/* copies of the pointers to free */
    DDXPointPtr pptFree ;
    PixmapPtr pTile ;
    int xSrc, ySrc ;
    int width ;
    int tlx, tly, hoffset, voffset, hremaining ;
    int currx ;

TRACE(("ibm8514TileFS((pDrawable = x%x, pGC = x%x, nInit = %d, pptInit = x%x, pwidthInit = x%x, fSorted = x%x)\n",
	pDrawable, pGC, nInit, pptInit, pwidthInit, fSorted)) ;

    if (pDrawable->type != DRAWABLE_WINDOW)
    {
	ErrorF("ibm8514TileFS: not a window\n") ;
	return ;
    }

    if ( ( alu = ( (ppcPrivGC *) pGC->devPrivates[mfbGCPrivateIndex].ptr )->colorRrop.alu ) == GXnoop )
	return ;

    pm = ( (ppcPrivGC *) pGC->devPrivates[mfbGCPrivateIndex].ptr )->colorRrop.planemask ;

    SETSPANPTRS(nInit, n, pwidthInit, pwidth, pptInit, 
		ppt, pwidthFree, pptFree, fSorted) ;

	switch(alu)
		{
		case GXset:
		case GXclear:
		case GXinvert:
			while ( n--)
				{
				ibm8514DrawRectangle( 0xFF, alu, pm,
					ppt->x, ppt->y, *pwidth, 1) ;
				ppt++ ;
				pwidth++ ;
				}
			return ;
		default:
			break ;
		}


	xSrc = pGC->patOrg.x + pDrawable->x ;
	ySrc = pGC->patOrg.y + pDrawable->y ;

    	pTile= pGC->tile.pixmap ;

	tlx = pTile->drawable.width ;
	tly = pTile->drawable.height ;

	if ( n == 1 ) {
		unsigned char *data ;

		if ((hoffset = ((ppt->x-xSrc)%tlx)) < 0) hoffset += tlx ;
		hremaining = tlx-hoffset ;
		if ((voffset = ((ppt->y-ySrc)%tly)) < 0) voffset += tly ;

		data = pTile->devPrivate.ptr + voffset * pTile->devKind ;
		width = *pwidth ;

		if ( hoffset ) {
			unsigned char *tmp
			   = (unsigned char *) ALLOCATE_LOCAL(pTile->devKind) ;
			MOVE( data + hoffset, tmp, hremaining) ;
			if ( width > hremaining )
				MOVE( data, tmp + hremaining, 
				      MIN( hoffset, width - hremaining ) ) ;
			data = tmp ;
		}

		if ( width <= tlx ) {
			ibm8514DrawColorImage( ppt->x, ppt->y, width, 1, 
					       data, width, alu, pm ) ;
		}
		else {
			switch ( alu ) {
				case GXcopy:
				case GXcopyInverted:
					ibm8514DrawColorImage( ppt->x, ppt->y,
							MIN( width, tlx ), 1, 
							data,
							MIN( width, tlx ),
							alu, pm) ;
					ppcReplicateArea( ppt->x, ppt->y,
							  pm, width, 1,
							  tlx, 1, 
						pTile->drawable.pScreen ) ;
					break ;
				default:
					if ( tlx > MAXTILESIZE ) {
						ibm8514DrawColorImage(
							ppt->x, ppt->y,
							MIN( width, tlx ), 1, 
							data,
							MIN( width, tlx ),
							alu, pm) ;
						for (
						    width -= tlx,
						    currx = ppt->x + tlx ;
						    width > 0 ; 
						    currx += tlx,
						    width -= tlx
						    )
							ibm8514DrawColorImage(
								currx, ppt->y,
								MIN( width, tlx ), 
								1, data, 
								MIN( width, tlx ), 
								alu, pm ) ;
						}
					   else { 
						ibm8514DrawColorImage(
							TILE_X, TILE_Y,
							*pwidth, 1, 
							data, *pwidth,
							alu, pm ) ;
						while ( tlx << 1 <= MAXTILESIZE)
							{
							ibm8514Bitblt(
								GXcopy, 0xFF, 
								0xFF,
								TILE_X, TILE_Y,
								TILE_X + tlx, 
								TILE_Y,
								tlx, 1 ) ;
							tlx <<= 1 ;
						}
						for (
						    currx = ppt->x ;
						    width > 0 ;
						    currx += tlx,
						    width -= tlx )
							ibm8514Bitblt(
								alu, 0xFF, pm,
								TILE_X, TILE_Y,
								currx, ppt->y,
								MIN( width, tlx ),
								1 ) ;
						}
			} /* end switch on rop */
		} /* end else on width > hremaining */
	} /* end N = 1 */
	   else {
		if ( ( tlx <= MAXTILESIZE ) && ( tly <= MAXTILESIZE ) ) {

			ibm8514DrawColorImage(
				TILE_X, TILE_Y,
				tlx, tly,
				pTile->devPrivate.ptr,
				pTile->devKind,
				GXcopy, ibm8514ALLPLANES ) ;
				/*we'll do the alu and planemask in the blits*/

			while ( tlx << 1 <= MAXTILESIZE ) {
				ibm8514Bitblt(
					GXcopy, 0xff, 0xff,
					TILE_X, TILE_Y,
					TILE_X + tlx, TILE_Y,
					tlx, tly ) ;
				tlx <<= 1 ;
			}

	        	while ( n-- ) {
				if ( ( hoffset = ( ( ppt->x - xSrc ) % tlx ) ) < 0 ) 
					hoffset += pTile->drawable.width ;
				if ( ( voffset = ( ( ppt->y - ySrc ) %tly ) ) < 0 ) 
						voffset += tly ;

				width = *pwidth ;
				if ( hoffset ) {
					ibm8514RotateTile( tlx, tly, hoffset, 0 ) ;
					while ( width > 0 ) {
						ibm8514Bitblt( alu, 0xff, pm,
							ROTTILE_X, 
							ROTTILE_Y + voffset,
							ppt->x, ppt->y,
							MIN( width, tlx ), 1 ) ;
						width -= tlx ;
						ppt->x += tlx ;
					}
				}
				else
					while ( width > 0 ) {
						ibm8514Bitblt( alu, 0xff, pm,
							TILE_X, 
							TILE_Y + voffset,
							ppt->x, ppt->y,
							MIN( width, tlx ), 1 ) ;
						width -= tlx ;
						ppt->x += tlx ;
					}
				ppt++ ;
				pwidth++ ;
			}
		}
		else {
			unsigned char *data ;
			unsigned char *tmp
			   = (unsigned char *) ALLOCATE_LOCAL(pTile->devKind) ;

			while ( n-- ) {
				if ( ( hoffset = ( ( ppt->x - xSrc ) % tlx ) ) < 0 ) 
					hoffset += tlx ;
				hremaining = tlx-hoffset ;
				if ( ( voffset = ( ( ppt->y - ySrc ) % tly ) ) < 0 )
					voffset += tly ;

				data = pTile->devPrivate.ptr + 
					voffset * pTile->devKind ;
				
				if ( hoffset ) {
					MOVE( data + hoffset, tmp, hremaining ) ;
					if ( *pwidth > hremaining )
						MOVE( data, tmp + hremaining, 
						      hoffset ) ;
					data = tmp ;
				}

				while ( *pwidth > 0 ) {
					ibm8514DrawColorImage(
						ppt->x, ppt->y,
						MIN( *pwidth, tlx ), 1,
						data,
						MIN( *pwidth, tlx ),
						alu, pm ) ;
					*pwidth -= tlx ;
					ppt->x += tlx ;
				}
				ppt++ ;
				pwidth++ ;
			}
		}
	} /* end N > 1 */

    DEALLOCATE_LOCAL(pptFree) ;
    DEALLOCATE_LOCAL(pwidthFree) ;
    return ;
}
#endif
#ifdef OLDFS
void
ibm8514TileFS(pDrawable, pGC, nInit, pptInit, pwidthInit, fSorted)
DrawablePtr pDrawable ;
GC		*pGC ;
int		nInit ;		/* number of spans to fill */
DDXPointPtr pptInit ;		/* pointer to list of start points */
int *pwidthInit ;		/* pointer to list of n widths */
int fSorted ;
{
    register unsigned long int pm ;
    register int alu ;
				/* next three parameters are post-clip */
    int n ;			/* number of spans to fill */
    register DDXPointPtr ppt ;	/* pointer to list of start points */
    register int *pwidth ;	/* pointer to list of n widths */
    int *pwidthFree ;		/* copies of the pointers to free */
    DDXPointPtr pptFree ;
    PixmapPtr pTile ;
    int xSrc, ySrc ;

TRACE(("ibm8514TileFS((pDrawable = x%x, pGC = x%x, nInit = x%x, pptInit = x%x, pwidthInit = x%x, fSorted = x%x)\n",
	pDrawable, pGC, nInit, pptInit, pwidthInit, fSorted)) ;

    if (pDrawable->depth == 1 )
    {
	ErrorF("ibm8514TileFS: depth == 1\n") ;
	return ;
    }

    if (pDrawable->type != DRAWABLE_WINDOW)
    {
	ErrorF("ibm8514TileFS: not a window\n") ;
	return ;
    }
    if ( ( alu = ( (ppcPrivGC *) pGC->devPrivates[mfbGCPrivateIndex].ptr )->colorRrop.alu ) == GXnoop )
	return ;

    pm = ( (ppcPrivGC *) pGC->devPrivates[mfbGCPrivateIndex].ptr )->colorRrop.planemask ;

    SETSPANPTRS(nInit, n, pwidthInit, pwidth, pptInit, 
		ppt, pwidthFree, pptFree, fSorted) ;

    xSrc = pGC->patOrg.x ;
    ySrc = pGC->patOrg.y ;
    pTile= pGC->tile ;

    while (n--)
    {
	ibm8514TileRect(pTile,alu,pm,ppt->x,ppt->y,*pwidth,1,xSrc,ySrc) ;
	ppt++ ;
	pwidth++ ;
    }
    DEALLOCATE_LOCAL(pptFree) ;
    DEALLOCATE_LOCAL(pwidthFree) ;
    return ;
}
#endif

/* Fill spans with stipples that aren't 32 bits wide */
void
ibm8514StippleFS(pDrawable, pGC, nInit, pptInit, pwidthInit, fSorted)
DrawablePtr pDrawable ;
GC		*pGC ;
int		nInit ;		/* number of spans to fill */
DDXPointPtr pptInit ;		/* pointer to list of start points */
int *pwidthInit ;		/* pointer to list of n widths */
int fSorted ;
{
    unsigned long int pm ;
    unsigned long int fg ;
    int alu ;
				/* next three parameters are post-clip */
    int n ;			/* number of spans to fill */
    register DDXPointPtr ppt ;	/* pointer to list of start points */
    register int *pwidth ;	/* pointer to list of n widths */
    int		iline ;		/* first line of stipple to use */
    PixmapPtr	pStipple ;	/* pointer to stipple we want to fill with */
    int		xSrc, ySrc, stippleWidth, xshift, maxwidth, totlen,
    		saved = FALSE ;

    pointer data ;
    int *pwidthFree ;		/* copies of the pointers to free */
    DDXPointPtr pptFree ;

TRACE(("ibm8514StippleFS((pDrawable = x%x, pGC = x%x, nInit = x%x, pptInit = x%x, pwidthInit = x%x, fSorted = x%x)\n",
	pDrawable, pGC, nInit, pptInit, pwidthInit, fSorted)) ;
    if ( pDrawable->depth != 8 )
    {
	ErrorF("ibm8514StippleFS: depth != 8\n") ;
	return ;
    }

    if (pDrawable->type != DRAWABLE_WINDOW)
    {
        int dummy ;
	dummy = (int) pDrawable->type ;
	ErrorF("ibm8514StippleFS: x%x (=%d) not a window\n",dummy,dummy) ;
	return ;
    }

    if ( ( alu = ( (ppcPrivGC *) pGC->devPrivates[mfbGCPrivateIndex].ptr )->colorRrop.alu ) == GXnoop )
	return ;

    SETSPANPTRS(nInit, n, pwidthInit, pwidth, pptInit, 
		ppt, pwidthFree, pptFree, fSorted) ;

    pStipple = pGC->stipple ;
    stippleWidth = pStipple->drawable.width ;

    /* this replaces rotating the stipple.  Instead, we just adjust the offset
     * at which we start grabbing bits from the stipple */
    xSrc = pGC->patOrg.x + pDrawable->x ;
    ySrc = pGC->patOrg.y + pDrawable->y ;

    /* Grab From Pre-Calculated Storage */
    pm = ( (ppcPrivGC *) pGC->devPrivates[mfbGCPrivateIndex].ptr )->colorRrop.planemask ;
    fg = ( (ppcPrivGC *) pGC->devPrivates[mfbGCPrivateIndex].ptr )->colorRrop.fgPixel ;

    while (n--)
    {
	iline = (ppt->y - ySrc) % pStipple->drawable.height ;
	maxwidth = _8514_SCREENWIDTH - ppt->x ;
	*pwidth = MIN(*pwidth,maxwidth) ;
	data = pStipple->devPrivate.ptr + iline*stippleWidth ;

        if ( !saved && !ibm8514cursorSemaphore )
	     saved = ibm8514CheckCursor(ppt->x%xSrc,ppt->y,
					   	 *pwidth+stippleWidth,1) ;
	/* I am only going to call replace ONCE, after the whole
	   stipple id done */

	/* set up stipple off screen */
	xshift = (ppt->x - xSrc) % stippleWidth ;
	ibm8514AlignMonoImage(WPLANE0, alu,
				STIPX, STIPY+1, stippleWidth, 1, data) ;
	if (xshift) 
		{/* shift the stipple left, then tack on end to the right */
		ibm8514Bitblt(GXcopy,RPLANE0,WPLANE0,STIPX+xshift,STIPY+1,
			STIPX,STIPY,stippleWidth-xshift,1) ;
		ibm8514Bitblt(GXcopy,RPLANE0,WPLANE0,STIPX,STIPY+1,
			STIPX+stippleWidth-xshift,STIPY,xshift,1) ;
		}
	totlen = stippleWidth ;
	while ( totlen<*pwidth)
		{ /* widen stipple to totlen of area to be stippled */
	  	ibm8514Bitblt(GXcopy,RPLANE0,WPLANE0,
			STIPX,STIPY,totlen,STIPY,totlen,1) ;
	  	totlen += totlen ;
	  	}


    	ibm8514ClearQueue( 2 ) ;
	SETXMIN(ppt->x) ; /* use clip to draw stippled line */
	SETXMAX(*pwidth + ppt->x) ;

	ibm8514BlitFG(RPLANE0,pm,fg,alu,
			STIPX,STIPY,ppt->x%xSrc,ppt->y,*pwidth+stippleWidth,1) ;

    	ibm8514ClearQueue(2) ;
	SETXMIN(0) ;
	SETXMAX(_8514_SCREENWIDTH-1) ;

	ppt++ ;
	pwidth++ ;
    }

    DEALLOCATE_LOCAL(pptFree) ;
    DEALLOCATE_LOCAL(pwidthFree) ;
    if (saved)
	ibm8514ReplaceCursor() ;

    return ;
}


void
ibm8514OPStippleFS(pDrawable, pGC, nInit, pptInit, pwidthInit, fSorted)
DrawablePtr pDrawable ;
GC		*pGC ;
int		nInit ;		/* number of spans to fill */
DDXPointPtr pptInit ;		/* pointer to list of start points */
int *pwidthInit ;		/* pointer to list of n widths */
int fSorted ;
{
    unsigned long int pm ;
    unsigned long int fg ;
    unsigned long int bg ;
    int alu ;
				/* next three parameters are post-clip */
    int n ;			/* number of spans to fill */
    register DDXPointPtr ppt ;	/* pointer to list of start points */
    register int *pwidth ;	/* pointer to list of n widths */
    int		iline ;		/* first line of stipple to use */
    PixmapPtr	pStipple ;	/* pointer to stipple we want to fill with */
    int		xSrc, ySrc, stippleWidth, xshift,
		maxwidth, totlen, saved = FALSE ;
    pointer data ;
    int *pwidthFree ;		/* copies of the pointers to free */
    DDXPointPtr pptFree ;

TRACE(("ibm8514StippleFS((pDrawable = x%x, pGC = x%x, nInit = x%x, pptInit = x%x, pwidthInit = x%x, fSorted = x%x)\n",
	pDrawable, pGC, nInit, pptInit, pwidthInit, fSorted)) ;
    if ( pDrawable->depth != 8 )
    {
	ErrorF("ibm8514StippleFS: depth != 8\n") ;
	return ;
    }

    if (pDrawable->type != DRAWABLE_WINDOW)
    {
        int dummy ;
	dummy = (int) pDrawable->type ;
	ErrorF("ibm8514StippleFS: x%x (=%d) not a window\n",dummy,dummy) ;
	return ;
    }

    if ( ( alu = ( (ppcPrivGC *) pGC->devPrivates[mfbGCPrivateIndex].ptr )->colorRrop.alu ) == GXnoop )
	return ;

    pm = ( (ppcPrivGC *) pGC->devPrivates[mfbGCPrivateIndex].ptr )->colorRrop.planemask ;
    fg = ( (ppcPrivGC *) pGC->devPrivates[mfbGCPrivateIndex].ptr )->colorRrop.fgPixel ;
    bg = ( (ppcPrivGC *) pGC->devPrivates[mfbGCPrivateIndex].ptr )->colorRrop.bgPixel ;

    SETSPANPTRS(nInit, n, pwidthInit, pwidth, pptInit, 
		ppt, pwidthFree, pptFree, fSorted) ;

    pStipple = pGC->stipple ;
    stippleWidth = pStipple->drawable.width ;

    /* this replaces rotating the stipple.  Instead, we just adjust the offset
     * at which we start grabbing bits from the stipple */
    xSrc = pGC->patOrg.x + pDrawable->x ;
    ySrc = pGC->patOrg.y + pDrawable->y ;

    while (n--)
    {
	iline = (ppt->y - ySrc) % pStipple->drawable.height ;
	maxwidth = _8514_SCREENWIDTH - ppt->x ;
	*pwidth = MIN(*pwidth,maxwidth) ;
	data = pStipple->devPrivate.ptr + iline*stippleWidth ;

        if ( !saved && !ibm8514cursorSemaphore )
            saved = ibm8514CheckCursor(ppt->x%xSrc,ppt->y,
					   	 *pwidth+stippleWidth,1) ;
	/* I am only going to call replace ONCE, after the whole
	   stipple id done */

	/* set up stipple off screen */
	xshift = (ppt->x - xSrc) % stippleWidth ;
	ibm8514AlignMonoImage(WPLANE0,alu,STIPX,STIPY+1,stippleWidth,1,data) ;
	if (xshift) 
		{/* shift the stipple left, then tack on end to the right */
		ibm8514Bitblt(GXcopy,RPLANE0,WPLANE0,STIPX+xshift,STIPY+1,
			STIPX,STIPY,stippleWidth-xshift,1) ;
		ibm8514Bitblt(GXcopy,RPLANE0,WPLANE0,STIPX,STIPY+1,
			STIPX+stippleWidth-xshift,STIPY,xshift,1) ;
		}

	totlen = stippleWidth ;
	while ( totlen<*pwidth)
	  { /* widen stipple to totlen of area to be stippled */
	  ibm8514Bitblt(GXcopy,RPLANE0,WPLANE0,
			STIPX,STIPY,totlen,STIPY,totlen,1) ;
	  totlen += totlen ;
	  }

    	ibm8514ClearQueue( 2 ) ;
	SETXMIN(ppt->x) ; /* use clip to draw stippled line */
	SETXMAX(*pwidth + ppt->x) ;

	ibm8514BlitFGBG(RPLANE0,pm,fg,bg,alu,
			STIPX,STIPY,ppt->x%xSrc,ppt->y,*pwidth+stippleWidth,1) ;

    	ibm8514ClearQueue(2) ;
	SETXMIN(0) ;
	SETXMAX(_8514_SCREENWIDTH-1) ;

	ppt++ ;
	pwidth++ ;
    }

    DEALLOCATE_LOCAL(pptFree) ;
    DEALLOCATE_LOCAL(pwidthFree) ;
    if (saved)
	ibm8514ReplaceCursor() ;

    return ;
}
