/*
 * Copyright IBM Corporation 1987,1990
 *
 * All Rights Reserved
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted,
 * provided that the above copyright notice appear in all copies and that 
 * both that copyright notice and this permission notice appear in
 * supporting documentation, and that the name of IBM not be
 * used in advertising or publicity pertaining to distribution of the
 * software without specific, written prior permission.
 *
 * IBM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
 * ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL
 * IBM BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
 * ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
 * SOFTWARE.
 *
*/
/*
 * PRPQ 5799-PFF (C) COPYRIGHT IBM CORPORATION 1987,1990
 * LICENSED MATERIALS - PROPERTY OF IBM
 * REFER TO COPYRIGHT INSTRUCTIONS FORM NUMBER G120-2083
 */
/*
 *  Hardware interface routines for IBM 8514/A adapter for
 *  X.11 server(s) on IBM equipment.
 *
 */
/* $Header: /andrew/X11/r3src/release/server/ddx/ibm/ibm8514/RCS/brcFont.c,v 30.2 89/02/28 18:16:03 paul Exp $ */
/* $Source: /andrew/X11/r3src/release/server/ddx/ibm/ibm8514/RCS/brcFont.c,v $ */

#ifndef lint
static char *rcsid = "$Header: /andrew/X11/r3src/release/server/ddx/ibm/ibm8514/RCS/brcFont.c,v 30.2 89/02/28 18:16:03 paul Exp $" ;
#endif

/* Cached Font Manager
 *
 * Try to stuff a font off screen and remember where it is
 * Always draw characters aligned to make life easy on the hardware
 * If no room, leave for Image Glyph Blit
 * When releasing, free up the space
 *
 */
#include "X.h"
#include "Xproto.h"
#include "fontstruct.h"
#include "dixfontstr.h"
#include "dixfont.h"
#include "font.h"
#include "scrnintstr.h"

#include "mfb.h"

#include "OScompiler.h"

#include "x8514.h"

#include "brcFonts.h"

#include "ibmTrace.h"

ibm8514FontCacheRec ibm8514FontCacheEntry[NUMFONTPLANES] ;

void
ibm8514InitFontCache()
{
register int i ;

TRACE( ( "ibm8514InitFontCache()\n" ) ) ;

ibm8514FontCacheEntry[0].RPlaneMask = RPLANE2 ;
ibm8514FontCacheEntry[0].WPlaneMask = WPLANE2 ;
ibm8514FontCacheEntry[1].RPlaneMask = RPLANE3 ;
ibm8514FontCacheEntry[1].WPlaneMask = WPLANE3 ;
ibm8514FontCacheEntry[2].RPlaneMask = RPLANE4 ;
ibm8514FontCacheEntry[2].WPlaneMask = WPLANE4 ;
ibm8514FontCacheEntry[3].RPlaneMask = RPLANE5 ;
ibm8514FontCacheEntry[3].WPlaneMask = WPLANE5 ;
ibm8514FontCacheEntry[4].RPlaneMask = RPLANE6 ;
ibm8514FontCacheEntry[4].WPlaneMask = WPLANE6 ;
ibm8514FontCacheEntry[5].RPlaneMask = RPLANE7 ;
ibm8514FontCacheEntry[5].WPlaneMask = WPLANE7 ;

for ( i = 0 ; i < NUMFONTPLANES ; i++ )
	{
	ibm8514FontCacheEntry[i].numInstalled 		= 0 ;
	ibm8514FontCacheEntry[i].FirstAvailableLine	= FONTCACHESTARTLINE ;
	ibm8514FontCacheEntry[i].NumLinesAvailable	= FONTCACHELENGTH ;
	ibm8514FontCacheEntry[i].FontList		= NULL ;
	}
return ;
}

extern int ibm8514NumberOfPlanes ;

void
ibm8514FreeFontChars( pChars, numChars )
register InstalledCharPtr *pChars ;
register int numChars ;
{
register InstalledCharPtr *pNextChar = pChars ;

while ( numChars-- )
	Xfree( *pNextChar++ ) ;
Xfree( pChars ) ;

return ;
}

Bool
ibm8514RealizeFont( pscr, pFont )
    ScreenPtr	pscr ;
    FontPtr	pFont ;
{
    FontInfoPtr		pfi = pFont->pFI ;
    CharInfoPtr		maxb = &pfi->maxbounds ;
    int			lines, linesneeded, width, height, i,
			numchars, firstchar, lastchar, found,
			CacheEntries, destX, destY, glw, glh,
			relativeY, wplane, padwidth ;
    InstalledFontPtr	ptr, pIFont ;
    char		*glyphs ;
    CharInfoPtr		pCinfo ;

    TRACE( ( "ibm8514RealizeFont: realizing 0x%x\n", pFont ) ) ;

    if ( pfi->lastRow == 0 ) {
	numchars = n1dChars( pfi ) ;
	firstchar = pfi->chFirst ;
	lastchar = pfi->chLast ;
    }
    else { /* XXX  This code needs to be looked at more  XXX */
	numchars = n2dChars( pfi ) ;
	pCinfo = pFont->pCI ;
	for ( firstchar = -1, i = 0 ;
	      ( ( i < 0xFFFF ) && ( firstchar == -1 ) ) ;
	      i++ )
		if ( pCinfo[i].exists )
			firstchar = i ;
	if ( ( i + numchars ) > 0xFFFF ) {
		ErrorF("ibm8514RealizeFont: bad 16bit realize") ;
		return mfbRealizeFont( pscr, pFont ) ;
	}
	lastchar = firstchar + numchars - 1 ;
    }

    lines = 1 ;
    width = 0 ;
    height = GLYPHHEIGHTPIXELS( maxb ) ;
    if ( GLYPHWIDTHPIXELS( maxb ) > FONTCACHEWIDTH ) {
	ErrorF( "Xibm: 8514: Not enough cache space (wide glyph)...") ;
	ErrorF( "Font was 0x%x\n", pFont ) ;
	return mfbRealizeFont( pscr, pFont ) ;
    }

    for ( i = 0 ; i < numchars ; i++ ) {
	pCinfo = (CharInfoPtr) &(pFont->pCI[i]) ;
	width += GLYPHWIDTHBYTES( pCinfo ) ;
	if ( width > FONTCACHEBYTEWIDTH ) {
		width = GLYPHWIDTHBYTES( pCinfo ) ;
		lines++ ;
	}
    }

    linesneeded = lines * height ;
    CacheEntries = ibm8514NumberOfPlanes - 2 ; /* 1 for stage, 1 for fill, */
					      /* rest are for fonts	*/

    for ( i = 0, found = -1 ; ( i < CacheEntries ) && ( found == -1 ) ; i++ )
	if ( linesneeded <= ibm8514FontCacheEntry[i].NumLinesAvailable )
		found = i ;
    if ( found == -1 ) /* Can't find enough space !! */
	return mfbRealizeFont( pscr, pFont ) ;

/* OK, we've space, we're going to go off-screen */
    pIFont = (InstalledFontRec *) Xalloc( sizeof (InstalledFontRec) ) ;
    if ( !pIFont )
	{
	ErrorF( "ibm8514RealizeFont: Cannot Xalloc for 0x%x\n", pFont ) ;
	return mfbRealizeFont( pscr, pFont ) ;
	}
    pIFont->ppCharacter =
	(InstalledCharPtr *) Xalloc( numchars * sizeof (InstalledCharPtr) ) ;
    if ( !pIFont->ppCharacter )
	{
	ErrorF( "ibm8514RealizeFont: Cannot Xalloc for 0x%x\n", pFont ) ;
	Xfree( pIFont ) ;
	return mfbRealizeFont( pscr, pFont ) ;
	}

    pIFont->firstchar = firstchar ;
    pIFont->lastchar = lastchar ;
    pIFont->numchars = numchars ;
    pIFont->CacheIndex = found ;
    pIFont->cacheheight = linesneeded ;

    destX = 0 ;
    relativeY = 0 ;
    destY = pIFont->startline =
	ibm8514FontCacheEntry[found].FirstAvailableLine ;

    /* allocate, install, fill chars */
    wplane = ibm8514FontCacheEntry[found].WPlaneMask ;

    for ( i = 0 ; i < numchars ; i++ ) {
	pIFont->ppCharacter[i] =
		(InstalledCharPtr) Xalloc( sizeof (InstalledCharRec) ) ;
        if ( !(pIFont->ppCharacter[i]) ) {
		ErrorF("ibm8514RealizeFont: Cannot Xalloc for 0x%x\n", pFont ) ;
		ibm8514FreeFontChars( pIFont->ppCharacter, i ) ;
		Xfree( pIFont ) ;
		return mfbRealizeFont( pscr, pFont ) ;
	}

	pCinfo = pIFont->ppCharacter[i]->pInfo = &(pFont->pCI[i]) ;

	if ( pCinfo->exists ) {
		padwidth = 8 * GLYPHWIDTHBYTES( pCinfo ) ;
		if ( destX + padwidth > FONTCACHEWIDTH ) {
			destX = 0 ;
			destY += height ; /* NEW LINE */
			relativeY += height ;
		}
		pIFont->ppCharacter[i]->x = destX ;
		pIFont->ppCharacter[i]->y = relativeY ;
		pIFont->ppCharacter[i]->w = glw = GLYPHWIDTHPIXELS( pCinfo ) ;
		pIFont->ppCharacter[i]->h = glh = GLYPHHEIGHTPIXELS( pCinfo ) ;
		glyphs = pFont->pGlyphs + pCinfo->byteOffset ;
		TRACE( (
"Font Realize align:pl=%d,destX=%d,destY=%d,glw=%d,glh=%d,glyphs=x%x,char=%d\n",
		 	wplane, destX, destY, glw, glh, glyphs, i ) ) ;

		/* dont do zero width or height glyphs */
		if ( glw && glh )
			ibm8514ByteAlignMonoImage( wplane, GXcopy, destX, destY,
						   glw, glh, glyphs ) ;
		destX += padwidth ;
	}
    }

    /* tack the Installed Font into the beginning of the fontlist */
    ptr = ibm8514FontCacheEntry[found].FontList ;
    ibm8514FontCacheEntry[found].FontList = pIFont ;
    pIFont->NextFont = ptr ;

    ibm8514FontCacheEntry[found].numInstalled++ ;
    ibm8514FontCacheEntry[found].FirstAvailableLine += linesneeded ;
    ibm8514FontCacheEntry[found].NumLinesAvailable -= linesneeded ;

    /* ok, so tell the world that it's been off-screened */
    pFont->devPriv[pscr->myNum] = (pointer) pIFont ;
    pIFont->pFont = pFont ;

    return TRUE ;
}

Bool
ibm8514UnrealizeFont( pscr, pFont )
    ScreenPtr	pscr ;
    FontPtr	pFont ;
{
int 			freeheight, blitheight, blitstart, blitdest ;
InstalledFontPtr	currentfont, *lastfont, pIFont ;
ibm8514FontCachePtr	pFC ;

pIFont = (InstalledFontPtr) pFont->devPriv[pscr->myNum] ;

/* this code depends on knowing what is going on in the mfb.  I am assuming
that the mfbrealizefont routine will only store a 0,1,2 in the devPriv
field, whereas I store a pointer.  In case the mfb grows, I will check
the field to see if it is a mfb number else assuming a pointer
*/

switch ( (long) pIFont ) {
	case FT_VARPITCH:
	case FT_FIXPITCH:
	case FT_SMALLPITCH:
		return mfbUnrealizeFont( pscr, pFont ) ;
	default:
		break ; /* It is an off-screen cached font ! */
}

TRACE( ( "ibm8514UnrealizeFont: unrealizing 0x%x\n", pFont ) ) ;

/* Free the font's character's data in core */
ibm8514FreeFontChars( pIFont->ppCharacter, pIFont->numchars ) ;

pFC = (ibm8514FontCachePtr) &(ibm8514FontCacheEntry[pIFont->CacheIndex]) ;

freeheight = pIFont->cacheheight ;
blitstart = pIFont->startline+freeheight ;
blitheight = 0 ;
blitdest = pIFont->startline ;

currentfont = pFC->FontList ;
lastfont = (InstalledFontPtr *) &(pFC->FontList) ;
/* notify all lower (earlier in list) fonts that they are moved up */
while ( currentfont != pIFont ) {
	currentfont->startline -= freeheight ;
	blitheight += currentfont->cacheheight ;
	lastfont = (InstalledFontPtr *) &(currentfont->NextFont) ;
	currentfont = currentfont->NextFont ;
}
/* move them up */
if ( blitheight )
	ibm8514Bitblt( GXcopy, pFC->RPlaneMask, pFC->WPlaneMask,
		       0, blitstart, 0, blitdest,
		       FONTCACHEWIDTH, blitheight) ;

pFC->FirstAvailableLine -= freeheight ;
pFC->NumLinesAvailable += freeheight ;
pFC->numInstalled-- ;
*lastfont = pIFont->NextFont ;
Xfree( pIFont ) ;

return TRUE ;
}

#ifdef FONTDUMP
FontDump( pscr, pFont )
    ScreenPtr   pscr ;
    FontPtr	pFont ;
{
InstalledFontPtr 	pIF ;
ibm8514FontCachePtr	pFC ;

pIF = (InstalledFontPtr) pFont->devPriv[pscr->myNum] ;
pFC = (ibm8514FontCachePtr) &(ibm8514FontCacheEntry[pIF->CacheIndex]) ;

ErrorF( "FontDump: 0x%x\n", pFont ) ;
ErrorF( "InstalledFont:\n" ) ;
ErrorF( "\tCacheIndex = %d\n", pIF->CacheIndex ) ;
ErrorF( "\tstartline = %d\n", pIF->startline ) ;
ErrorF( "\tcacheheight = %d\n", pIF->cacheheight ) ;
ErrorF( "\tfirstchar = %d\n", pIF->firstchar ) ;
ErrorF( "\tlastchar = %d\n", pIF->lastchar ) ;
ErrorF( "\tnumchars = %d\n", pIF->numchars ) ;
ErrorF( "\tNextFont = %x\n", pIF->NextFont ) ;

ErrorF( "CacheIndex:\n" ) ;
ErrorF( "\tRplanemask, Wplanemask = %x, %x\n",
	pFC->RPlaneMask,pFC->WPlaneMask ) ;
ErrorF( "\tnumInstalled = %d\n", pFC->numInstalled ) ;
ErrorF( "\tLinesAvail, First line = %d, %d\n",
	pFC->FirstAvailableLine, pFC->NumLinesAvailable  ) ;
ErrorF( "\n" ) ;
}
#endif

/* The X font from which it came */
static FontPtr *ibm8514SavedFontList = (FontPtr *) 0 ;
static int ibm8514SavedfontCount = 0 ;

void
ibm8514CreateSavedFontList()
{
InstalledFontPtr brcFonts ;
InstalledFontPtr nextInstalled ;
int i ;
int fontCount ;
int tPcnt ;

fontCount = 0 ;
for ( i = 0 ; i < NUMFONTPLANES ; i++ ) {
	fontCount += ibm8514FontCacheEntry[i].numInstalled ;
	ibm8514FontCacheEntry[i].FirstAvailableLine	= FONTCACHESTARTLINE ;
	ibm8514FontCacheEntry[i].NumLinesAvailable	= FONTCACHELENGTH ;
}
if ( !( ibm8514SavedFontList =
		(FontPtr *) Xalloc( fontCount * sizeof (FontPtr) ) ) )
	return ; /* Blew It !! */

ibm8514SavedfontCount = 0 ;
for ( i = 0 ; i < NUMFONTPLANES ; i++ ) {
	brcFonts = ibm8514FontCacheEntry[i].FontList ;
	for ( tPcnt = ibm8514FontCacheEntry[i].numInstalled ;
	      tPcnt-- ; ) {
		ibm8514SavedFontList[ibm8514SavedfontCount++] =
			brcFonts->pFont ;
		ibm8514FreeFontChars( brcFonts->ppCharacter,
				      brcFonts->numchars ) ;
		nextInstalled = brcFonts->NextFont ;
		Xfree( brcFonts ) ;
		brcFonts = nextInstalled ;
	}
	ibm8514FontCacheEntry[i].numInstalled 		= 0 ;
	ibm8514FontCacheEntry[i].FontList		= NULL ;
}

return ;
}

void
ibm8514RestoreOffScreenFonts( pScr )
ScreenPtr pScr ;
{
FontPtr *fontList = ibm8514SavedFontList ;

ibm8514InitFontCache() ;
while ( ibm8514SavedfontCount-- )
	ibm8514RealizeFont( pScr, *fontList++ ) ;

Xfree( ibm8514SavedFontList ) ;
ibm8514SavedFontList = (FontPtr *) 0 ;

return ;
}
