/*
 * Copyright IBM Corporation 1987,1990
 *
 * All Rights Reserved
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted,
 * provided that the above copyright notice appear in all copies and that 
 * both that copyright notice and this permission notice appear in
 * supporting documentation, and that the name of IBM not be
 * used in advertising or publicity pertaining to distribution of the
 * software without specific, written prior permission.
 *
 * IBM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
 * ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL
 * IBM BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
 * ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
 * SOFTWARE.
 *
*/
/*
 * PRPQ 5799-PFF (C) COPYRIGHT IBM CORPORATION 1987,1990
 * LICENSED MATERIALS - PROPERTY OF IBM
 * REFER TO COPYRIGHT INSTRUCTIONS FORM NUMBER G120-2083
 */
/*
 *  Hardware interface routines for IBM 8514/A adapter for
 *  X.11 server(s) on IBM equipment.
 *
 */

/* $Header: /andrew/X11/r3src/release/server/ddx/ibm/ibm8514/RCS/brcGBlt.c,v 30.0 89/01/23 19:23:37 paul Exp $ */
/* $Source: /andrew/X11/r3src/release/server/ddx/ibm/ibm8514/RCS/brcGBlt.c,v $ */

#ifndef lint
static char *rcsid = "$Header: /andrew/X11/r3src/release/server/ddx/ibm/ibm8514/RCS/brcGBlt.c,v 30.0 89/01/23 19:23:37 paul Exp $";
#endif

/* 
 * Image Glyph Blit
 * For use when font cache is full
 *
 */

#include "X.h"
#include "Xmd.h"
#include "Xproto.h"
#include "fontstruct.h"
#include "dixfontstr.h"
#include "gcstruct.h"
#include "windowstr.h"
#include "scrnintstr.h"
#include "pixmapstr.h"
#include "regionstr.h"

#include "OScompiler.h"

#include "ppc.h"

#include "x8514.h"

#include "ibmTrace.h"

extern int ibm8514cursorSemaphore;
extern int mfbGCPrivateIndex;

void
ibm8514ImageGlyphBlt( pDrawable, pGC, x, y, nglyph, ppci, pglyphBase)
    DrawablePtr pDrawable;
    GC 		*pGC;
    int 	x, y;
    unsigned int nglyph;
    CharInfoPtr *ppci;		/* array of character info */
    unsigned char *pglyphBase;	/* start of array of glyphs */
{
    int CursorIsSaved;
    ExtentInfoRec info;	/* used by QueryGlyphExtents() */
    BoxRec bbox;	/* string's bounding box */
    xRectangle backrect;/* backing rectangle to paint.
			   in the general case, NOT necessarily
			   the same as the string's bounding box
			*/
    CharInfoPtr pci;
    int xorg, yorg;	/* origin of drawable in bitmap */
    int w;		/* width of glyph in bits */
    int h;		/* height of glyph */
    register unsigned char *pglyph;
			/* pointer to current row of glyph */
    int nbox;
    BoxPtr pbox;
    int i ;
    RegionPtr pRegion;
    unsigned long int pm, bg, fg ;
    int x0, y0 ;

    TRACE(("ibm8514ImageGlyphBlt( pDrawable = 0x%x, pGC = 0x%x, x=%d, y=%d, nglyph=%d, ppci= 0x%x, pglyphBase= 0x%x)\n", pDrawable, pGC, x, y, nglyph, ppci, pglyphBase));
    if ( !( pGC->planemask & ibm8514ALLPLANES ) )
	return ;

    xorg = pDrawable->x;
    yorg = pDrawable->y;

    QueryGlyphExtents(pGC->font, ppci, nglyph, &info);

    x += xorg;
    y += yorg;

    backrect.x = x + info.overallLeft;
    backrect.y = y - pGC->font->pFI->fontAscent;
    backrect.width = info.overallRight - info.overallLeft;
    backrect.width = MAX( backrect.width, info.overallWidth );
    backrect.height = pGC->font->pFI->fontAscent + 
		      pGC->font->pFI->fontDescent;

    bbox.x1 = x + info.overallLeft;
    bbox.x2 = x + info.overallRight;
    bbox.y1 = y - info.overallAscent;
    bbox.y2 = y + info.overallDescent;

    pRegion = ((ppcPrivGC *)(pGC->devPrivates[mfbGCPrivateIndex].ptr))->pCompositeClip;
    nbox = REGION_NUM_RECTS(pRegion);
    if ( nbox == 0 )
	return;


    pbox = REGION_RECTS(pRegion);
    pm =  pGC->planemask;
    fg =  pGC->fgPixel;
    bg =  pGC->bgPixel;
    CursorIsSaved = !ibm8514cursorSemaphore && ibm8514CheckCursor( backrect.x, backrect.y, backrect.width, backrect.height );
    for ( i = nbox ; i-- ; pbox++ ) {
	ibm8514ClearQueue(4);
	SETXMIN(pbox->x1);
	SETYMIN(pbox->y1);
	SETXMAX(pbox->x2-1);
	SETYMAX(pbox->y2-1);
	ibm8514DrawRectangle( bg, GXcopy, pm,
		backrect.x, backrect.y,
		backrect.width, backrect.height);
    }

    ibm8514ClearQueue(4);
    SETXMIN(0);
    SETYMIN(0);
    SETXMAX(_8514_SCREEN_WIDTH-1);
    SETYMAX( 1023 ) ;

    if ( CursorIsSaved )
	ibm8514ReplaceCursor();

    CursorIsSaved = !ibm8514cursorSemaphore && ibm8514CheckCursor( bbox.x1, bbox.y1, bbox.x2-bbox.x1, bbox.y2-bbox.y1 );

    switch ( (*pGC->pScreen->RectIn)(
		  ( (ppcPrivGC *)(pGC->devPrivates[mfbGCPrivateIndex].ptr))->pCompositeClip, &bbox ) )
    {
      case rgnOUT:
	break;
      case rgnIN:

        while (nglyph--)
        {
	    pci = *ppci;
	    pglyph = pglyphBase + pci->byteOffset;
	    w = GLYPHWIDTHPIXELS(pci);
	    h = GLYPHHEIGHTPIXELS(pci);
	    x0 = x + pci->metrics.leftSideBearing;
	    y0 = y - pci->metrics.ascent;
	    /* draw offscreen */
	    ibm8514ByteAlignMonoImage( MONO_STAGE_WPLANE, GXcopy,
				       MONO_STAGE_X, MONO_STAGE_Y,
				       w, h, pglyph ) ;
	    /* blit onscreen */
	    ibm8514BlitFG( MONO_STAGE_RPLANE, pm, fg, GXcopy,
			   MONO_STAGE_X, MONO_STAGE_Y, x0, y0, w, h ) ;

	    /* update character origin */
	    x += pci->metrics.characterWidth;
	    ppci++;
        } /* while nglyph-- */
	break;
      case rgnPART:
      {
	int nbox;
	BoxPtr pbox;
	int i;
	RegionPtr prgnClip;
	BoxRec cbox;
	int glx, gly;

        while (nglyph--)
        {
	    pci = *ppci;
	    pglyph = pglyphBase + pci->byteOffset;
	    w = GLYPHWIDTHPIXELS(pci);
	    h = GLYPHHEIGHTPIXELS(pci);
	    cbox.x1 = glx = x + pci->metrics.leftSideBearing;
	    cbox.y1 = gly = y - pci->metrics.ascent;
	    cbox.x2 = cbox.x1 + w;
	    cbox.y2 = cbox.y1 + h;

	    switch ((*pGC->pScreen->RectIn)(
		  ((ppcPrivGC *)(pGC->devPrivates[mfbGCPrivateIndex].ptr))->pCompositeClip, &cbox))

	    {
	      case rgnOUT:
		break;
	      case rgnIN:
		/* draw offscreen */
	    	ibm8514ByteAlignMonoImage( MONO_STAGE_WPLANE, GXcopy,
				           MONO_STAGE_X, MONO_STAGE_Y,
				           w, h, pglyph ) ;
		/* blit onscreen */
	    	ibm8514BlitFG( MONO_STAGE_RPLANE, pm, fg, GXcopy,
			       MONO_STAGE_X, MONO_STAGE_Y,
			       glx, gly, w, h ) ;
		break;
	      case rgnPART:
		prgnClip =
		  (* ((WindowPtr)pDrawable)->drawable.pScreen->RegionCreate)(
		  &cbox, 
		  REGION_NUM_RECTS(((ppcPrivGC *)(pGC->devPrivates[mfbGCPrivateIndex].ptr))->pCompositeClip)) ;
		(* ((WindowPtr)pDrawable)->drawable.pScreen->Intersect)
			( prgnClip, prgnClip, 
			  ((ppcPrivGC *)(pGC->devPrivates[mfbGCPrivateIndex].ptr))->pCompositeClip ) ;
		if ( !( nbox = REGION_NUM_RECTS(prgnClip) ) )
		    break;
		pbox = REGION_RECTS(prgnClip);
		/* draw offscreen */
	    	ibm8514ByteAlignMonoImage( MONO_STAGE_WPLANE, GXcopy,
					   MONO_STAGE_X, MONO_STAGE_Y,
					   w, h, pglyph ) ;
/* ****** THIS STINKS & MUST BE FIXED SOMEDAY -- SOON ****** */
		for ( i = nbox ; i-- ; pbox++ ) {
			ibm8514ClearQueue( 4 ) ;
			SETXMIN(pbox->x1);
			SETYMIN(pbox->y1);
			SETXMAX(pbox->x2-1);
			SETYMAX(pbox->y2-1);
			/* blit onscreen*/
	    		ibm8514BlitFG( MONO_STAGE_RPLANE, pm, fg, GXcopy,
				       MONO_STAGE_X, MONO_STAGE_Y,
				       glx, gly, w, h ) ;
TRACE(("gbltPARTPART: call BlitFG: x=%d, y=%d, w=%d, h=%d\n", glx,gly,w,h));
		}

		(* ((WindowPtr)pDrawable)->drawable.pScreen->RegionDestroy)
			(prgnClip);
		ibm8514ClearQueue( 4 );
		SETXMIN(0);
		SETYMIN(0);
		SETXMAX(_8514_SCREEN_WIDTH-1);
		SETYMAX( 1023 ) ;
		break;
	    }
	    /* update character origin */
	    x += pci->metrics.characterWidth;
	    ppci++;
        } /* while nglyph-- */

      }
      default:
	break;
    }

    if ( CursorIsSaved )
	ibm8514ReplaceCursor();
    return ;
}
