/*
 * Copyright IBM Corporation 1987,1990
 *
 * All Rights Reserved
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted,
 * provided that the above copyright notice appear in all copies and that 
 * both that copyright notice and this permission notice appear in
 * supporting documentation, and that the name of IBM not be
 * used in advertising or publicity pertaining to distribution of the
 * software without specific, written prior permission.
 *
 * IBM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
 * ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL
 * IBM BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
 * ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
 * SOFTWARE.
 *
*/
/*
 * PRPQ 5799-PFF (C) COPYRIGHT IBM CORPORATION 1987,1990
 * LICENSED MATERIALS - PROPERTY OF IBM
 * REFER TO COPYRIGHT INSTRUCTIONS FORM NUMBER G120-2083
 */
/*
 *  Hardware interface routines for IBM 8514/A adapter for
 *  X.11 server(s) on IBM equipment.
 *
 */

/***********************************************************
Copyright 1987 by Digital Equipment Corporation, Maynard, Massachusetts,
and the Massachusetts Institute of Technology, Cambridge, Massachusetts.

			All Rights Reserved

Permission to use, copy, modify, and distribute this software and its
documentation for any purpose and without fee is hereby granted,
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in
supporting documentation, and that the names of Digital or MIT not be
used in advertising or publicity pertaining to distribution of the
software without specific, written prior permission.

DIGITAL DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
DIGITAL BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
SOFTWARE.

******************************************************************/

/* $Header: /andrew/X11/r3src/r3plus/server/ddx/ibm/ibm8514/RCS/brcGC.c,v 6.12 89/07/06 13:55:40 jeff Exp $ */
/* $Source: /andrew/X11/r3src/r3plus/server/ddx/ibm/ibm8514/RCS/brcGC.c,v $ */

#ifndef lint
static char *rcsid = "$Header: /andrew/X11/r3src/r3plus/server/ddx/ibm/ibm8514/RCS/brcGC.c,v 6.12 89/07/06 13:55:40 jeff Exp $" ;
#endif

#include "X.h"
#include "Xproto.h"
#include "windowstr.h"
#include "window.h"
#include "pixmapstr.h"
#include "scrnintstr.h"
#include "misc.h"
#include "font.h"
#include "gcstruct.h"
#include "cursorstr.h"
#include "region.h"

#include "mistruct.h"

#include "../../mfb/mfb.h"

#include "OScompiler.h"

#include "ppc.h"
#include "ppcProcs.h"

#include "brcProcs.h"
#include "ibmTrace.h"

#ifdef Use8514HardwareDashes
extern void ibm8514ZeroDash() ;		/* will be .h */
#endif

extern void miWideLine() ;
extern int mfbGCPrivateIndex;

Mask
ibm8514ChangeGCtype( pGC, devPriv )
register GC *pGC ;
register ppcPrivGCPtr devPriv ;
{
	if ( devPriv->lastDrawableType == DRAWABLE_PIXMAP ) {
	    devPriv->FillArea	= mfbSolidInvertArea ;
	    pGC->ops->CopyArea	= miCopyArea ;
	    pGC->ops->PolyFillRect	= miPolyFillRect ;
	    pGC->ops->FillPolygon	= miFillPolygon ;
	    pGC->ops->ImageText8	= miImageText8 ;
	    pGC->ops->ImageText16	= miImageText16 ;
	    pGC->ops->PolyText8	= miPolyText8 ;
	    pGC->ops->PolyText16	= miPolyText16 ;
	    pGC->ops->PushPixels	= miPushPixels ;
    	    pGC->ops->PolyGlyphBlt	= miPolyGlyphBlt ;
	    pGC->ops->PolyArc	= miPolyArc ;
	    pGC->ops->PolyFillArc	= miPolyFillArc ;
	    pGC->ops->PolySegment	= miPolySegment ;
	    pGC->ops->PolyRectangle	= miPolyRectangle ;
	}
	else {
	    devPriv->FillArea	= ppcAreaFill ;
	    pGC->ops->CopyArea	= ppcCopyArea ;
	    pGC->ops->PolyFillRect	= ppcPolyFillRect ;
	    pGC->ops->FillPolygon	= ibm8514FillPolygon ;
	    pGC->ops->ImageText8	= (void (*)()) ibm8514ImageText8 ;
	    pGC->ops->ImageText16	= (void (*)()) ibm8514ImageText16 ;
	    pGC->ops->PolyText8	= ibm8514PolyText8 ;
	    pGC->ops->PolyText16	= ibm8514PolyText16 ;
	    pGC->ops->PushPixels	= ibm8514PushPixels ;
    	    pGC->ops->PolyGlyphBlt	= ppcPolyGlyphBlt ;
	}
	return;
}

Mask
ibm8514ChangeWindowGC( pGC, changes )
register GC *pGC ;
register Mask changes ;
{
register ppcPrivGCPtr devPriv = (ppcPrivGCPtr) (pGC->devPrivates[mfbGCPrivateIndex].ptr) ;
register unsigned long int index ; /* used for stepping through bitfields */
register Mask bsChanges = 0 ;

#define LOWBIT( x ) ( x & - x ) /* Two's complement */
    while ( index = LOWBIT( changes ) ) {
	switch ( index ) {

	  case GCLineStyle:
	  case GCLineWidth:
		if ( pGC->lineStyle == LineSolid ) {
	    		pGC->ops->PolySegment = ( ( pGC->lineWidth == 0 )
				? ppcScrnZeroSegs : miPolySegment ) ;
	    		pGC->ops->Polylines = ( ( pGC->lineWidth == 0 )
				? ppcScrnZeroLine : miWideLine ) ;
	    		pGC->ops->PolyArc = ( ( pGC->lineWidth == 0 )
				? ppcPolyZeroArc : miPolyArc ) ;
		}
		else {
	    		pGC->ops->PolySegment = miPolySegment;
#ifdef Use8514HardwareDashes
			if ( pGC->lineWidth == 0 ) {
				extern void ibm8514_do_dashline_gc() ;
				ibm8514_do_dashline_gc( pGC ) ;
			}
			else {
				pGC->ops->Polylines = miWideDash ;
			}
#else
			pGC->ops->Polylines = ( pGC->lineWidth == 0 )
					? ppcScrnZeroDash : miWideDash ;
#endif
			pGC->ops->PolyArc = miPolyArc;
		}
	    /*
	     * If these are just square boxes with no funny business
	     * going on we can call the fast routine that draws
	     * rectangles without floating point.
	     */
	    if ( ( pGC->lineStyle == LineSolid ) 
			&& ( pGC->joinStyle == JoinMiter ) 
			&& ( pGC->lineWidth != 0 ) )
		pGC->ops->PolyRectangle = ppcPolyRectangle;
	    else
		pGC->ops->PolyRectangle = miPolyRectangle;

	    changes &= ~( GCLineStyle | GCLineWidth ) ;
	    break ;
	  case GCJoinStyle:
	    pGC->ops->LineHelper =
		( pGC->joinStyle == JoinMiter ) ? miMiter : miNotMiter ;
	    /*
	     * If these are just square boxes with no funny business
	     * going on we can call the fast routine that draws
	     * rectangles without floating point.
	     */
	    if ( ( pGC->lineStyle == LineSolid ) 
			&& ( pGC->joinStyle == JoinMiter ) 
			&& ( pGC->lineWidth != 0 ) )
		pGC->ops->PolyRectangle = ppcPolyRectangle;
	    else
		pGC->ops->PolyRectangle = miPolyRectangle;
	    changes &= ~ index ; /* i.e. changes &= ~ GCJoinStyle */
	    break ;

	  case GCBackground:
	    if ( pGC->fillStyle != FillOpaqueStippled ) {
		changes &= ~ index ; /* i.e. changes &= ~GCBackground */
		break ;
	    } /* else Fall Through */
	  case GCForeground:
	    if ( pGC->fillStyle == FillTiled ) {
		changes &= ~ index ; /* i.e. changes &= ~GCForeground */
		break ;
	    } /* else Fall Through */
	  case GCFunction:
	  case GCPlaneMask:
	  case GCFillStyle:
	    { /* new_fill */
		int fillStyle = devPriv->colorRrop.fillStyle ;
		/* install a suitable fillspans */
		if ( fillStyle == FillSolid )
		    pGC->ops->FillSpans = ibm8514SolidFS ;
		else if ( fillStyle == FillStippled )
		    pGC->ops->FillSpans = ppcStippleWindowFS ;
		else if ( fillStyle == FillOpaqueStippled )
		    pGC->ops->FillSpans = ppcOpStippleWindowFS ;
		else /* fillStyle == FillTiled */
		    pGC->ops->FillSpans = ibm8514TileFS ;
		pGC->ops->PolyFillArc = ppcPolyFillArc;
	    } /* end of new_fill */
	    changes &= ~( GCBackground | GCForeground
		     | GCFunction
		     | GCPlaneMask | GCFillStyle ) ;
	    break ;

	default:
	    ErrorF( "ibm8514ValidateGC: Unexpected GC Change\n" ) ;
	    changes &= ~ index ; /* Remove it anyway */
	    break ;
	}
    }
    return bsChanges ;
}
