/*
 * Copyright IBM Corporation 1987,1990
 *
 * All Rights Reserved
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted,
 * provided that the above copyright notice appear in all copies and that 
 * both that copyright notice and this permission notice appear in
 * supporting documentation, and that the name of IBM not be
 * used in advertising or publicity pertaining to distribution of the
 * software without specific, written prior permission.
 *
 * IBM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
 * ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL
 * IBM BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
 * ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
 * SOFTWARE.
 *
*/
/*
 * PRPQ 5799-PFF (C) COPYRIGHT IBM CORPORATION 1987,1990
 * LICENSED MATERIALS - PROPERTY OF IBM
 * REFER TO COPYRIGHT INSTRUCTIONS FORM NUMBER G120-2083
 */
/* $Header: /andrew/X11/r3src/release/server/ddx/ibm/ibm8514/RCS/brcGetSp.c,v 6.3 89/02/14 22:23:05 paul Exp $ */
/* $Source: /andrew/X11/r3src/release/server/ddx/ibm/ibm8514/RCS/brcGetSp.c,v $ */

#ifndef lint
static char *rcsid = "$Header: /andrew/X11/r3src/release/server/ddx/ibm/ibm8514/RCS/brcGetSp.c,v 6.3 89/02/14 22:23:05 paul Exp $" ;
#endif

#include "X.h"
#include "Xmd.h"

#include "region.h"
#include "gc.h"
#include "windowstr.h"
#include "pixmapstr.h"
#include "scrnintstr.h"
#include "servermd.h"

#include "ibmTrace.h"

extern void ppcGetSpans() ;

void
ibm8514GetSpans( pDrawable, wMax, ppt, pwidth, nspans, pdstStart )
    DrawablePtr		pDrawable ;
    int			wMax ;
    register DDXPointPtr ppt ;
    int			*pwidth ;
    int			nspans ;
    unsigned long int *pdstStart ;
{
    register unsigned int *pdst ;	/* where to put the bits */
    register unsigned int width ;

    if ( pDrawable->type != DRAWABLE_WINDOW )
	{
	ppcGetSpans( pDrawable, wMax, ppt, pwidth, nspans, pdstStart ) ;
	return ;
	}

/*******************************************************************/
    /* read back the slices */
    for ( pdst = pdstStart ; nspans-- ; ppt++, pwidth++ ) {
	width = *pwidth ;
	ibm8514ReadColorImage( ppt->x, ppt->y, width, 1, pdst,
			       ( width + 3 ) & ~3 ) ;
	pdst += ( width + 3 ) >> 2 ; /* width is in 32 bit words */
    }
/*******************************************************************/

    return ;
}
