/*
 * Copyright IBM Corporation 1987,1990
 *
 * All Rights Reserved
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted,
 * provided that the above copyright notice appear in all copies and that 
 * both that copyright notice and this permission notice appear in
 * supporting documentation, and that the name of IBM not be
 * used in advertising or publicity pertaining to distribution of the
 * software without specific, written prior permission.
 *
 * IBM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
 * ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL
 * IBM BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
 * ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
 * SOFTWARE.
 *
*/
/*
 * PRPQ 5799-PFF (C) COPYRIGHT IBM CORPORATION 1987,1990
 * LICENSED MATERIALS - PROPERTY OF IBM
 * REFER TO COPYRIGHT INSTRUCTIONS FORM NUMBER G120-2083
 */
/*
 *  Hardware interface routines for IBM 8514/A adapter for
 *  X.11 server(s) on IBM equipment.
 *
 */

/* $Header: /andrew/X11/r3src/release/server/ddx/ibm/ibm8514/RCS/brcImg.c,v 30.1 89/04/29 21:59:24 jeff Exp $ */
/* $Source: /andrew/X11/r3src/release/server/ddx/ibm/ibm8514/RCS/brcImg.c,v $ */

#ifndef lint
static char *rcsid = "$Header: /andrew/X11/r3src/release/server/ddx/ibm/ibm8514/RCS/brcImg.c,v 30.1 89/04/29 21:59:24 jeff Exp $" ;
#endif

/* IMAGES
 * Read and Write Full Color Images to/from 8514/A
 *
 */
#include "X.h"

#include "servermd.h"

#include "OScompiler.h"

#include "x8514.h"

#include "ibmTrace.h"

extern int mergexlate[16] ;
extern int ibm8514cursorSemaphore ;

extern void blockoutw() ;
extern void blockinw() ;

void
ibm8514DrawColorImage( x, y, w, h, data, RowIncrement, merge, planes )
int x,y ;
register int w ;
int h ;
register unsigned char *data ;
int RowIncrement ;
int merge ;
unsigned long int planes ;
{
int saved ;

TRACE( ( "ibm8514DrawColorImage(x=%d,y=%d,w=%d,h=%d,data=x%x,RowIncrement=%d,merge=x%x,planes=x%x)\n",
	x, y, w, h, data, RowIncrement, merge, planes ) ) ;

if ( ( w <= 0 ) || ( h <= 0 ) )
	return ;

saved = !ibm8514cursorSemaphore && ibm8514CheckCursor( x, y, w, h ) ;

ibm8514ATRNotBusy ;
ibm8514ClearQueue( 7 ) ;
PLNWENBL( planes ) ;
SETFN1( FNVAR, mergexlate[ merge ] ) ; /* don't overlook that FNVAR */
SETX0( x ) ;
SETY0( y ) ;
SETLX( w - 1 ) ;
SETLY( h - 1 ) ;

COMMAND( ibm8514WriteZData ) ;

/* NOTE: we write half as many shorts as bytes */
if ( w == RowIncrement )
	blockoutw( data, ( ( w * h ) + 1 ) >> 1 ) ;
else if ( w & 1 ) { /* MOD 2 == 1 */
	int extrah ;
	unsigned char tchar ;
	int almostw ;

	extrah = h & 1 ;
	h >>= 1 ; /* write half line pairs */
	if ( almostw = --w >> 1 ) {
		while ( h-- ) { /* write half line pairs */
		/* WARNING: arg to blockoutw may not be 16-bit aligned here ! */
			blockoutw( data, almostw ) ;
			tchar = data[ w ] ;
			data += RowIncrement ;
#if IMAGE_BYTE_ORDER == MSBFirst
			outw( VARDATA, ( tchar << 8 ) | *data ) ;
#else
			outw( VARDATA, tchar | ( ( *data ) << 8 ) ) ;
#endif
		/* WARNING: arg to blockoutw may not be 16-bit aligned here ! */
			blockoutw( data + 1, almostw ) ;
			data += RowIncrement ;
		}
		/* WARNING: arg to blockoutw may not be 16-bit aligned here ! */
		if ( extrah )
			blockoutw( data, almostw + 1 ) ;
	}
	else {
		while ( h-- ) { /* write half line pairs */
			tchar = data[ w ] ;
			data += RowIncrement ;
#if IMAGE_BYTE_ORDER == MSBFirst
			outw( VARDATA, ( tchar << 8 ) | *data ) ;
#else
			outw( VARDATA, tchar | ( ( *data ) << 8 ) ) ;
#endif
			data += RowIncrement ;
		}
		/* WARNING: arg to blockoutw may not be 16-bit aligned here ! */
		if ( extrah )
#if IMAGE_BYTE_ORDER == MSBFirst
			outw( VARDATA, ( *data << 8 ) ) ;
#else
			outw( VARDATA, *data ) ;
#endif
	}
}
else
	for ( w >>= 1 ; h-- ; data += RowIncrement )
		blockoutw( data, w ) ;

ibm8514ClearQueue( 3 ) ;  /* following a blockout */
SETFN1( FNCOLOR1, FNREPLACE ) ;
PLNWENBL( ibm8514ALLPLANES ) ;

if ( saved )
	ibm8514ReplaceCursor() ;

return ;
}

void
ibm8514ReadColorImage( x, y, lx, ly, data, RowIncrement )
int x ;
int y ;
int lx ;
int ly ;
register unsigned char *data ;
int RowIncrement ;
{
int saved ;

TRACE( ( "ibm8514ReadColorImage(x=%d,y=%d,lx=%d,ly=%d,data=x%x,RowIncrement=%d)\n",
	x, y, lx, ly, data, RowIncrement ) ) ;

if ( ( lx <= 0 ) || ( ly <= 0 ) )
	return ;

saved = !ibm8514cursorSemaphore && ibm8514CheckCursor( x, y, lx, ly ) ;

ibm8514ATRNotBusy ;
ibm8514CheckQueue( 4 ) ;
PLNWENBL( ibm8514ALLPLANES ) ;
PLNRENBL( ibm8514ALLPLANES ) ;
SETMODE( M_DEPTH ) ;
SETFN1( FNVAR, FNREPLACE ) ;
ibm8514CheckQueue( 5 ) ;
SETX0( x ) ;
SETY0( y ) ;
SETLX( lx - 1 ) ;
SETLY( ly - 1 ) ;
COMMAND( ibm8514ReadZData ) ;

if ( lx == RowIncrement )
	blockinw( data, ( lx * ly ) / 2 ) ;
/* NOTE: we read half as many shorts as bytes */
else if ( lx & 1 ) { /* MOD 2 == 1 */
	unsigned short int shrt ;
	int extrah ;
	int almostw ;

	almostw = --lx >> 1 ;
	extrah = ly & 1 ;
	ly >>= 1 ;
	while ( ly-- ) { /* write half line pairs */
		blockinw( data, almostw ) ;
		shrt = inw( VARDATA ) ;
#if IMAGE_BYTE_ORDER == MSBFirst
		data[ lx ] = shrt >> 8 ; /* Top 8 bits */
		data += RowIncrement ;
		*data = shrt & 0xFF ; /* Bottom 8 bits */
#else
		data[ lx ] = shrt & 0xFF ; /* Bottom 8 bits */
		data += RowIncrement ;
		*data = shrt >> 8 ; /* Top 8 bits */
#endif
		/* WARNING: arg to blockinw may not be 16-bit aligned here ! */
		blockinw( data + 1, almostw ) ;
		data += RowIncrement ;
	}
	if ( extrah ) {
		blockinw( data, almostw ) ;
		shrt = inw( VARDATA ) ;
#if IMAGE_BYTE_ORDER == MSBFirst
		data[ lx ] = shrt >> 8 ; /* Top 8 bits */
#else
		data[ lx ] = shrt & 0xFF ; /* Bottom 8 bits */
#endif
	}
}
else
	for ( lx >>= 1 ; ly-- ; data += RowIncrement )
		blockinw( data, lx ) ;

ibm8514ClearQueue( 2 ) ;
SETFN1( FNCOLOR1, FNREPLACE ) ;
SETMODE( M_ONES ) ;

if ( saved )
	ibm8514ReplaceCursor() ;

return ;
}
