/*
 * Copyright IBM Corporation 1987,1990
 *
 * All Rights Reserved
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted,
 * provided that the above copyright notice appear in all copies and that 
 * both that copyright notice and this permission notice appear in
 * supporting documentation, and that the name of IBM not be
 * used in advertising or publicity pertaining to distribution of the
 * software without specific, written prior permission.
 *
 * IBM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
 * ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL
 * IBM BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
 * ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
 * SOFTWARE.
 *
*/
/*
 * PRPQ 5799-PFF (C) COPYRIGHT IBM CORPORATION 1987,1990
 * LICENSED MATERIALS - PROPERTY OF IBM
 * REFER TO COPYRIGHT INSTRUCTIONS FORM NUMBER G120-2083
 */
/*
 *  Hardware interface routines for IBM 8514/A adapter for
 *  X.11 server(s) on IBM equipment.
 *
 */

#include <fcntl.h>
#include <sys/ioctl.h>

#if defined(ibm032) && defined(BSDrt)
#define ATR
#include <machinecons/buf_emul.h>
#else
#ifdef i386
#if defined(IBM_OS_HAS_HFT) || !defined(IBM_OS_HAS_X_QUEUE)
#include "ibmXhftMap.h"
#endif
	/* Nothing Yet */
#else
	******** ERROR ********
#endif
#endif

#include "X.h"
#include "miscstruct.h"
#include "scrnintstr.h"
#include "cursorstr.h"

#include "ibmScreen.h"
#include "ibmTrace.h"

#include "x8514.h"

extern void ibmInfoMsg() ;

extern PixmapFormatRec ibm8514Formats[] ;
/* GLOBAL FILE DESCRIPTOR -- for ioctl's etc. */
int ibm8514FD = -1 ;

/*ARGSUSED*/
void
ibm8514osdInit( index )
register int index ;
{
    TRACE( ( "ibm8514osdInit()\n" ) ) ;
#ifdef ibm032
	/* Nothing Yet */
#else
#ifdef i386
	/* Nothing Yet */
#else
	******** ERROR ********
#endif
#endif
return ;
}

/******************************************************************************/

void
ibm8514SetVideoRegisters()
{
#if !defined(BSDrt)
  /* THE FOLLOWING 8 OUTPUT VALUES ARE MAGIC NUMBERS */
  /* Note that they are not queued */
  /* This is the only place they occur, so screw the #define theory */
    ibm8514outw( 0x12e8, 0x0660 ) ;	 /* frame total width */
    ibm8514outw( 0x1ae8, 0x0600 ) ;	 /* frame sync posn */
    ibm8514outw( 0x16e8, 0x05fb ) ;	 /* frame blank start */
    outb( 0x1ee8, 0x08 ) ;		 /* frame sync width */
    ibm8514outw( 0x02e8, 0x009d ) ;	 /* line total length */
    ibm8514outw( 0x0ae8, 0x0081 ) ;	 /* line sync posn */
    ibm8514outw( 0x06e8, 0x007f ) ;	 /* line blank start */
    ibm8514outw( 0x0ee8, 0x0016 ) ;	 /* line sync width */
  /* END MAGIC NUMBERS */
#endif
    return ;
}

/******************************************************************************/

int
ibm8514Probe()
{
register int fd ;

#if defined(IBM_OS_HAS_X_QUEUE) || defined(BSDrt)
    if ( ( fd = open( IBM8514_DEV_FILE, O_RDWR | O_NDELAY ) ) >= 0 ) {
#if defined(i386)
	(void) ioctl( fd, 'B'<<8|1, 0 ) ; /* 8514 specific I/O permissions !! */
#else
	(void) ioctl( fd, BUFINIT8514, 0 ) ;
#endif
    }
    else /* Open of device file failed */
#endif /* IBM_OS_HAS_X_QUEUE */
#if defined(IBM_OS_HAS_HFT)
    {
	if ( ( fd = hftProbe( IBM8514xHFTid ) ) < 0 )
	    return fd ;
    }
#else /* No hft and initial devFile open failed */
	return -1 ;
#endif /* defined(IBM_OS_HAS_HFT) */

    ibmInfoMsg( "Found a %d-plane 8514a with ",
		ibm8514Formats[0].depth = ibm8514QueryPlanes() ) ;

    switch ( ibm8514QueryHead() )
	{
	case PseudoColor:
		ibmInfoMsg( "a Color display\n" ) ;
		break ;
	case GrayScale:
		ibmInfoMsg( "a Grayscale display\n" ) ;
		break ;
	default:
		ibmInfoMsg( "no known display\n" ) ;
		ErrorF( "Not bothering with headless 8514\n" ) ;
		(void) close( fd ) ;
		return -1 ;
	}
	return ibm8514FD = fd ;
	/*NOTREACHED*/
}

#if defined(ibm032) && defined(ATRIO)
/* on the 386 blockoutw should be assembly coded to use "rep outs %dx, *%esi" */
void
blockoutw( values, n )
register unsigned char *values ;
register int n ;
{
    /* I/O port type is 4 bytes for 6152 but only 2 for i386 !! */
    register volatile unsigned long int *ptr ;

if ( !n )
    return ;

ptr = (volatile unsigned long int *) ( VARDATA | WORDADD ) ;

/* Test Alignment */
if ( ( (unsigned long int) values ) & 1 ) {
    register unsigned long int tmpBuf ;

    tmpBuf = *values++ << 16 ; /* Now We're Aligned */
    while ( --n ) {
	tmpBuf |= *( (unsigned short int *) values ) ;
    	*ptr = (unsigned long int) ( tmpBuf >> 8 ) ;
	values += sizeof (unsigned short int) ;
    	tmpBuf <<= 16 ;
    }
    *ptr = (unsigned long int) ( ( tmpBuf >> 8 ) | *values ) ;
}
else
    for ( n++ ; --n ; values += sizeof (unsigned short int) )
    	*ptr = (unsigned long int) *( (unsigned short int *) values ) ;

return ;
}

void
blockinw( data, n )
register unsigned char *data ;
register int n ;
{
/* I/O port type is 4 bytes for 6152 but only 2 for i386 !! */
register unsigned long int *ptr ;

if ( !n )
	return ;

ptr = (unsigned long int *) ( VARDATA | WORDADD ) ;

/* Test Alignment */
if ( ( (unsigned long int) data ) & 1 ) {
    register unsigned long int tmpBuf ;

    tmpBuf = *ptr ;
    *data++ = tmpBuf >> 8 ;
    tmpBuf <<= 16 ;
    while ( --n ) {
	tmpBuf |= (unsigned short) *ptr ;
	*( (unsigned short int *) data ) = tmpBuf >> 8 ;
	tmpBuf <<= 16 ;
	data += sizeof (unsigned short int) ;
    }
    *data = tmpBuf >> 16 ;

}
else
    for ( n++ ; --n ; data += sizeof (unsigned short int) )
	*( (unsigned short int *) data ) = (unsigned short) *ptr ;

return ;
}

#else
#if defined(i386) && defined(PCIO)

#if defined(USE_PORTABLE_BLOCKOUTW)
void
blockoutw( values, n )
register unsigned short *values ;
register int n ;
{
#if HALFQBUF != 4
	******** ERROR ********
#endif
    for ( ; n >= HALFQBUF ; n -= HALFQBUF ) {
       	ibm8514ClearQueue( HALFQBUF ) ;
    	outw( VARDATA, *values++ ) ;	/* This assume that HALFQBUF is 4 */
    	outw( VARDATA, *values++ ) ;
    	outw( VARDATA, *values++ ) ;
    	outw( VARDATA, *values++ ) ;
    }
    if ( n ) {		/* Left over < HALFQBUF */
       	ibm8514ClearQueue( n ) ;
    	while ( n-- )
    		outw( VARDATA, *values++ ) ;
    }
    return ;
}

#endif /* #if defined(USE_PORTABLE_BLOCKOUTW) */

void
blockinw( data, n )
register unsigned char *data ;
register int n ;
{
for ( n++ ; --n ; data += sizeof (unsigned short int) )
	*( (unsigned short int *) data ) = inw( VARDATA ) ;

return ;
}
#else
	******** ERROR -- RT w/ Family-1 Bus ??
#endif
#endif
