/*
 * Copyright IBM Corporation 1987,1990
 *
 * All Rights Reserved
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted,
 * provided that the above copyright notice appear in all copies and that 
 * both that copyright notice and this permission notice appear in
 * supporting documentation, and that the name of IBM not be
 * used in advertising or publicity pertaining to distribution of the
 * software without specific, written prior permission.
 *
 * IBM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
 * ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL
 * IBM BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
 * ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
 * SOFTWARE.
 *
*/
/*
 * PRPQ 5799-PFF (C) COPYRIGHT IBM CORPORATION 1987,1990
 * LICENSED MATERIALS - PROPERTY OF IBM
 * REFER TO COPYRIGHT INSTRUCTIONS FORM NUMBER G120-2083
 */
/*
 *
 * Hardware interface routines for IBM 8514/A adapter for
 * X.11 server(s) on IBM equipment.
 *
 */
/* $Header: /andrew/X11/r3src/release/server/ddx/ibm/ibm8514/RCS/x8514.h,v 30.0 89/01/23 19:24:45 paul Exp $ */
/* $Source: /andrew/X11/r3src/release/server/ddx/ibm/ibm8514/RCS/x8514.h,v $ */

#if !defined(lint) && !defined(LOCORE) && defined(RCS_HDRS)
static char *rcsidx8514 = "$Header: /andrew/X11/r3src/release/server/ddx/ibm/ibm8514/RCS/x8514.h,v 30.0 89/01/23 19:24:45 paul Exp $";
#endif

#if !defined(i386) && !defined(iAPX386) && !defined(iAPX286)
/* ibm 6152 */
#ifndef ATR
#define ATR
#endif
#ifndef ATRIO
#define ATRIO
#endif
#ifdef PCIO
#undef PCIO
#endif

#else
/* ibm AIX/386 */
#ifdef ATR
#undef ATR
#endif
#ifndef PCIO
#define PCIO
#endif
#ifdef ATRIO
#undef ATRIO
#endif

#endif

#if defined(ibm032) && defined(BSDrt)

#define SWAP_ADJUST( x ) (x) /* Code originally written for the rt */

extern unsigned short ibm8514inw() ;
#define ibm8514outw(port, val16) \
	outw( port, (((val16 & 0x0000FF00)>>8) | ((val16 & 0x000000FF)<<8)) )

/* The folowing are two magic addresses for the ATR kernel */
#define BYTEADD 0xD00F0000
#define WORDADD 0xD00E0000

#else
#if defined(i386) || defined(iAPX386) || defined(iAPX286)

/* Code originally written for the rt */
#define SWAP_ADJUST( x ) ((((x)&0xFF)<<8)|(((x)>>8)&0xFF))

#define ibm8514inw( addr ) inw( (addr) )
#define ibm8514outw(port, val16) outw( (port), (val16) )

#else
	******** ERROR ********
#endif
#endif

/* Memory Reference Portability Macros */
#include "ibmIOArch.h"

/* Device Register Definitions */
#include "ibm8514reg.h"

/* Supported display tube types */
#define HEAD_GRAY1024 	1
#define HEAD_COLOR1024 	2
#define HEAD_GRAY640 	5
#define HEAD_COLOR640 	6
#define HEAD_NONE 	7

#define HALFQBUF	4

/* Psuedo-Functions for adapter control */
#define QSTAT ( ibm8514inw( QSTATADD ) )
#define QCTRL ( ibm8514inw( QCTRLADD ) )
#define QCSTAT ( ibm8514inw( 0x02E8 ) )

#define ibm8514NotBusy \
	while ( QSTAT & 0x0200 ) /* Do Nothing */ ;

/* Note N must be < 9, otherwise the result is indeterminate */
#define ibm8514ClearQueue( numSlots )	\
	while ( ( 0x0100 >> ( numSlots ) ) & QSTAT ) ;

#if defined(ATRIO) || ( defined(ibm032) && defined(BSDrt) )
#define ibm8514CheckQueue(N)	/* Noop on 6152 !! */
#define ibm8514ATRNotBusy 	ibm8514NotBusy
#else
#define ibm8514CheckQueue(N)	ibm8514ClearQueue(N)
#define ibm8514ATRNotBusy 	/* No-op on 386 */
#endif

#define _8514_SCREENHEIGHT	768
#define _8514_SCREENWIDTH	1024
#define _8514_SCREEN_HEIGHT	768
#define _8514_SCREEN_WIDTH	1024

#define ibm8514MaxCursorWidth	32
#define ibm8514MaxCursorHeight	32
#define SAVELOCX 0
#define SAVELOCY ( _8514_SCREENHEIGHT + 1 )
#define CUR1LOCX ( SAVELOCX + ibm8514MaxCursorWidth )
#define CUR1LOCY ( _8514_SCREENHEIGHT + 1 )
#define CUR0LOCX ( CUR1LOCX + ibm8514MaxCursorWidth )
#define CUR0LOCY ( _8514_SCREENHEIGHT + 1 )
#define C1X 		CUR1LOCX
#define C1Y		( _8514_SCREENHEIGHT + 1 )
#define C0X		CUR0LOCX
#define C0Y		( _8514_SCREENHEIGHT + 1 )
#define SAVEX		SAVELOCX
#define SAVEY		( _8514_SCREENHEIGHT + 1 )
#define CURD_X		ibm8514MaxCursorWidth
#define CURD_Y		ibm8514MaxCursorHeight

#define TILE_X		96
#define TILE_Y		( _8514_SCREENHEIGHT + 1 )
#define ROTTILE_X	128
#define ROTTILE_Y	( _8514_SCREENHEIGHT + 1 )
#define MAXTILESIZE	32

#define STIPX		0
#define MAXSTIPPLEWIDTH	( _8514_SCREENWIDTH - STIPX )
#define STIPY		802
#define MAXSTIPPLEHEIGHT 220
#define FILL_STAGE_WPLANE	0x02
#define FILL_STAGE_RPLANE	0x02
#define MONO_STAGE_SIZE		200
#define MONO_STAGE_WPLANE	WPLANE0
#define MONO_STAGE_RPLANE	RPLANE0
#define MONO_STAGE_X		0
#define MONO_STAGE_Y		803

/* Default Colors */
#define IBM8514_BLACK_PIXEL 0
#define IBM8514_WHITE_PIXEL 1

/* Name of device file for "unix" ( Not AIX ) */
#define IBM8514_DEV_FILE "/dev/ibm8514"

/* Tom's stylistic effects */
#define then

#ifndef TRUE
#define TRUE -1
#endif

#ifndef FALSE
#define FALSE 0
#endif
