%
% This file is a product of Sun Microsystems, Inc. and is provided for
% unrestricted use provided that this legend is included on all tape
% media and as a part of the software program in whole or part.  Users
% may copy or modify this file without charge, but are not authorized to
% license or distribute it to anyone else except as part of a product
% or program developed by the user.
% 
% THIS FILE IS PROVIDED AS IS WITH NO WARRANTIES OF ANY KIND INCLUDING THE
% WARRANTIES OF DESIGN, MERCHANTIBILITY AND FITNESS FOR A PARTICULAR
% PURPOSE, OR ARISING FROM A COURSE OF DEALING, USAGE OR TRADE PRACTICE.
% 
% This file is provided with no support and without any obligation on the
% part of Sun Microsystems, Inc. to assist in its use, correction,
% modification or enhancement.
% 
% SUN MICROSYSTEMS, INC. SHALL HAVE NO LIABILITY WITH RESPECT TO THE
% INFRINGEMENT OF COPYRIGHTS, TRADE SECRETS OR ANY PATENTS BY THIS FILE
% OR ANY PART THEREOF.
% 
% In no event will Sun Microsystems, Inc. be liable for any lost revenue
% or profits or other special, indirect and consequential damages, even
% if Sun has been advised of the possibility of such damages.
% 
% Sun Microsystems, Inc.
% 2550 Garcia Avenue
% Mountain View, California  94043
%

%
% "@(#)go4.cps 9.2 88/01/18
%
% Copyright (c) 1987 by Sun Microsystems, Inc.
%

% Constants need in both C & PostScript
C: #define BOARD_SIZE  19

% PostScript constants
#define DONE_TAG      1
#define DAMAGE_TAG    2
#define BOARD_SIZE   19
#define BOARD_MAX    18
#define LINE_WIDTH  .02

cdef initialize()

/black_color    0 0 0 rgbcolor def
/white_color    1 1 1 rgbcolor def
/board_color    .9 .69 .28 rgbcolor def         % Wood color
/line_color     black_color def

/repair { % - => - (repair the board)
    DAMAGE_TAG tagprint uniquecid dup typedprint
    [exch cidinterest] forkeventmgr
    waitprocess pop
} def

/draw_board { % - => - (draw the playing surface)
    board_color setcolor clippath fill
    line_color setcolor
    0 1 BOARD_MAX {
        dup 0 moveto 0 BOARD_MAX rlineto
        0 exch moveto BOARD_MAX 0 rlineto
    } for
    stroke
    pause
} def

/makewin { %  - => - (builds a go window)
      /GoWindow DefaultWindow                          % create a subclass
      dictbegin
           /FrameLabel ( 2nd Go board ) def
      dictend
      classbegin
           /PaintClient { repair } def        
           /PaintIcon {
                 .5 fillcanvas
                 0 strokecanvas
           } def  
           /DestroyClient {                            % override method
                 DONE_TAG tagprint
           } def
           /ClientPath { % x y w h => -
                 4 2 roll translate
                 BOARD_SIZE div exch BOARD_SIZE div exch scale
                 .5 .5 translate
                 -.5 -.5 BOARD_SIZE BOARD_SIZE rectpath
           } def
           /IconPath {ClientPath} def

       classend def

       /win framebuffer /new GoWindow send def          % cliche
       /reshapefromuser win send                        % resize window
       /map win send                                        % draw it
} def
% end initialize()

%  function call definitions
cdef done() => DONE_TAG()
cdef draw_board(int id)
     id {draw_board} sendcidevent
cdef get_damage(int id) => DAMAGE_TAG(id)
cdef repaired(int id)
     id {exit} sendcidevent
cdef execute () 
     makewin
