/*
 * This file is a product of Sun Microsystems, Inc. and is provided for
 * unrestricted use provided that this legend is included on all tape
 * media and as a part of the software program in whole or part.  Users
 * may copy or modify this file without charge, but are not authorized to
 * license or distribute it to anyone else except as part of a product
 * or program developed by the user.
 * 
 * THIS FILE IS PROVIDED AS IS WITH NO WARRANTIES OF ANY KIND INCLUDING THE
 * WARRANTIES OF DESIGN, MERCHANTIBILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE, OR ARISING FROM A COURSE OF DEALING, USAGE OR TRADE PRACTICE.
 * 
 * This file is provided with no support and without any obligation on the
 * part of Sun Microsystems, Inc. to assist in its use, correction,
 * modification or enhancement.
 * 
 * SUN MICROSYSTEMS, INC. SHALL HAVE NO LIABILITY WITH RESPECT TO THE
 * INFRINGEMENT OF COPYRIGHTS, TRADE SECRETS OR ANY PATENTS BY THIS FILE
 * OR ANY PART THEREOF.
 * 
 * In no event will Sun Microsystems, Inc. be liable for any lost revenue
 * or profits or other special, indirect and consequential damages, even
 * if Sun has been advised of the possibility of such damages.
 * 
 * Sun Microsystems, Inc.
 * 2550 Garcia Avenue
 * Mountain View, California  94043
 */

#ifndef lint
static	char sccsid[] = "@(#)misc.c 1.2 88/01/18 Copyright 1987 Sun Micro";
#endif

/*
 *	Copyright (c) 1987 by Sun Microsystems, Inc.
 *	Steve Isaac 12/18/87
 *
 */

/* Copyright (c) 1985 Massachusetts Institute of Technology              */
/* Copyright (c) 1985   Digital Equipment Corporation                    */

/* misc.c */

#include <stdio.h>
#include <setjmp.h>
#include <signal.h>
#include <ctype.h>
#include <pwd.h>
#include <sgtty.h>
#include <sys/time.h>
#include <sys/file.h>
#include "NeWS.h"
#include "ptyx.h"
#include "data.h"
#include "error.h"

int	ps_next_user_token;

xevents()
{
    int         keycode,
                length;
    char	*s;
    int         pty = term.screen.respond;
    long	arg;

    do {
	if (ps_keyhit(&keycode))
	    Input(&term.keyboard, &term.screen, keycode);
	else if (ps_sizechanged(&screen_cols, &screen_rows, 
                 &screen_pixwidth, &screen_pixheight))
	    changesize();
	else if (ps_insertsellength(&selectionlength)) {
                 if (selectionbuffer != 0) 
                     free(selectionbuffer);   
                 if ((selectionbuffer = (char *) malloc(selectionlength)) == 0)
	             fprintf(stderr, "Selection buffer malloc failed; selection not done\n");
             }
	else if (ps_insertselstring(selectionbuffer)) {
                 s = selectionbuffer;
                 length = selectionlength;
	         while (length-- > 0)
	             unparseputc(*s++, pty);
             }
	else if (ps_exit()) {
             exit(0);
        }
	else {
	    fprintf(stderr, "Bogus token encountered\n");
	    psio_dropbuf(PostScriptInput);
	}
	ioctl(psio_fileno(PostScriptInput), FIONREAD, &arg);
    } while (psio_availinputbytes(PostScriptInput) > 0 || arg > 0);
}

Timer(val)
    long        val;
{
    struct itimerval it;

    bzero(&it, sizeof(it));
    it.it_value.tv_usec = val;
    setitimer(ITIMER_REAL, &it, (struct itimerval *) 0);
}

Bell()
{
    extern Terminal term;
    register Screen *screen = &term.screen;

    if (screen->visualbell)
	ps_flashscreen();
    else {
	/* ring a physical bell */
    }
}

StartLog(screen)
    register Screen *screen;
{

#ifdef X
    register char *cp;
    register int i;
    static char *log_default;
    char       *malloc(),
               *rindex();
    extern      logpipe();

    if (screen->logging || (screen->inhibit & I_LOG))
	return;
    if (screen->logfile == NULL || *screen->logfile == 0) {
	if (screen->logfile)
	    free(screen->logfile);
	if (log_default == NULL)
	    mktemp(log_default = log_def_name);
	if ((screen->logfile = malloc(strlen(log_default) + 1)) == NULL)
	    return;
	strcpy(screen->logfile, log_default);
    }
    if (*screen->logfile == '|') {	/* exec command */
	int         p[2];
	static char *shell;

	if (pipe(p) < 0 || (i = fork()) < 0)
	    return;
	if (i == 0) {		/* child */
	    close(p[1]);
	    dup2(p[0], 0);
	    close(p[0]);
	    dup2(fileno(stderr), 1);
	    dup2(fileno(stderr), 2);
	    close(fileno(stderr));
	    fileno(stderr) = 2;
	    close(screen->display->fd);
	    close(screen->respond);
	    if (!shell) {
		register struct passwd *pw;
		char       *getenv(),
		           *malloc();
		struct passwd *getpwuid();

		if (((cp = getenv("SHELL")) == NULL || *cp == 0)
			&& ((pw = getpwuid(screen->uid)) == NULL ||
			    *(cp = pw->pw_shell) == 0) ||
			(shell = malloc(strlen(cp) + 1)) == NULL)
		    shell = "/bin/sh";
		else
		    strcpy(shell, cp);
	    }
	    signal(SIGHUP, SIG_DFL);
	    signal(SIGCHLD, SIG_DFL);
	    setgid(screen->gid);
	    setuid(screen->uid);
	    execl(shell, shell, "-c", &screen->logfile[1], 0);
	    fprintf(stderr, "%s: Can't exec `%s'\n", xterm_name,
		    &screen->logfile[1]);
	    exit(ERROR_LOGEXEC);
	}
	close(p[0]);
	screen->logfd = p[1];
	signal(SIGPIPE, logpipe);
    }
    else {
	if (access(screen->logfile, F_OK) == 0) {
	    if (access(screen->logfile, W_OK) < 0)
		return;
	}
	else if (cp = rindex(screen->logfile, '/')) {
	    *cp = 0;
	    i = access(screen->logfile, W_OK);
	    *cp = '/';
	    if (i < 0)
		return;
	}
	else if (access(".", W_OK) < 0)
	    return;
	if ((screen->logfd = open(screen->logfile, O_WRONLY | O_APPEND |
				  O_CREAT, 0644)) < 0)
	    return;
	chown(screen->logfile, screen->uid, screen->gid);

    }
    screen->logstart = screen->TekEmu ? Tbptr : bptr;
    screen->logging = TRUE;
#endif
}

CloseLog(screen)
    register Screen *screen;
{

#ifdef X
    if (!screen->logging || (screen->inhibit & I_LOG))
	return;
    FlushLog(screen);
    close(screen->logfd);
    screen->logging = FALSE;
#endif
}

FlushLog(screen)
    register Screen *screen;
{

#ifdef X
    register char *cp;
    register int i;

    cp = screen->TekEmu ? Tbptr : bptr;
    if ((i = cp - screen->logstart) > 0)
	write(screen->logfd, screen->logstart, i);
    screen->logstart = screen->TekEmu ? Tbuffer : buffer;
#endif
}

logpipe()
{

#ifdef X
    register Screen *screen = &term.screen;

    if (screen->logging)
	CloseLog(screen);
#endif
}

do_osc(func)
    int         (*func) ();
{
}

Panic(s, a)
    char       *s;
    int         a;
{

#ifdef DEBUG
    if (debug) {
	fprintf(stderr, "%s: PANIC!	", xterm_name);
	fprintf(stderr, s, a);
	fputs("\r\n", stderr);
	fflush(stderr);
    }
#endif DEBUG
}

SysError(i)
    int         i;
{
    fprintf(stderr, "%s: Error %d, errno %d:", xterm_name, i, errno);
    perror("");
    Cleanup(i);
}

Error(i)
    int         i;
{
    fprintf(stderr, "%s: Error %d\n", xterm_name, i);
    Cleanup(i);
}

/*
 * cleanup by sending SIGHUP to client processes
 */
Cleanup(code)
    int         code;
{
    extern Terminal term;
    register Screen *screen;

    screen = &term.screen;
    if (screen->pid > 1)
	killpg(getpgrp(screen->pid), SIGHUP);
    Exit(code);
}

/*
 * sets the value of var to be arg in the Unix 4.2 BSD environment env. Var
 * should end with '=' (bindings are of the form "var=value"). This procedure
 * assumes the memory for the first level of environ was allocated using
 * calloc, with enough extra room at the end so not to have to do a realloc().
 */
Setenv(var, value)
    register char *var,
               *value;
{
    extern char **environ;
    register int index = 0;
    register int len = strlen(var);

    if (value == 0)
	return;
    while (environ[index] != NULL) {
	if (strncmp(environ[index], var, len) == 0) {
	    /* found it */
	    environ[index] = (char *) malloc(len + strlen(value) + 1);
	    strcpy(environ[index], var);
	    strcat(environ[index], value);
	    return;
	}
	index++;
    }

#ifdef DEBUG
    if (debug)
	fputs("expanding env\n", stderr);
#endif DEBUG

    environ[index] = (char *) malloc(len + strlen(value) + 1);
    strcpy(environ[index], var);
    strcat(environ[index], value);
    environ[++index] = NULL;
}

/*
 * returns a pointer to the first occurrence of s2 in s1, or NULL if there are
 * none.
 */
char       *
strindex(s1, s2)
    register char *s1,
               *s2;
{
    register char *s3;
    char       *index();

    while ((s3 = index(s1, *s2)) != NULL) {
	if (strncmp(s3, s2, strlen(s2)) == 0)
	    return (s3);
	s1 = ++s3;
    }
    return (NULL);
}

