/*
 * This file is a product of Sun Microsystems, Inc. and is provided for
 * unrestricted use provided that this legend is included on all tape
 * media and as a part of the software program in whole or part.  Users
 * may copy or modify this file without charge, but are not authorized to
 * license or distribute it to anyone else except as part of a product
 * or program developed by the user.
 * 
 * THIS FILE IS PROVIDED AS IS WITH NO WARRANTIES OF ANY KIND INCLUDING THE
 * WARRANTIES OF DESIGN, MERCHANTIBILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE, OR ARISING FROM A COURSE OF DEALING, USAGE OR TRADE PRACTICE.
 * 
 * This file is provided with no support and without any obligation on the
 * part of Sun Microsystems, Inc. to assist in its use, correction,
 * modification or enhancement.
 * 
 * SUN MICROSYSTEMS, INC. SHALL HAVE NO LIABILITY WITH RESPECT TO THE
 * INFRINGEMENT OF COPYRIGHTS, TRADE SECRETS OR ANY PATENTS BY THIS FILE
 * OR ANY PART THEREOF.
 * 
 * In no event will Sun Microsystems, Inc. be liable for any lost revenue
 * or profits or other special, indirect and consequential damages, even
 * if Sun has been advised of the possibility of such damages.
 * 
 * Sun Microsystems, Inc.
 * 2550 Garcia Avenue
 * Mountain View, California  94043
 */

#ifndef lint
static	char sccsid[] = "@(#)mkpstoctbl.c 9.3 88/01/19 Copyright 1985 Sun Micro";
#endif

/*
 * Copyright (c) 1985 by Sun Microsystems, Inc.
 */

/*-
	Make the tables needed by pstoc

	mkpstoctbl.c, Sun Jun 15 15:14:44 1986

		James Gosling,
		Sun Microsystems
 */

#ifdef REF
#include <sys/types.h>
#include <ref/config.h>
#endif
#include "encoding.h"
#include <stdio.h>

char oplength[256];
char optype[256];
char ttype[256];

#define set1(p,v)	(*(p)=(v))
#define set2(p,v)	(set1(p,v),set1(p+1,v))
#define set4(p,v)	(set2(p,v),set2(p+2,v))
#define set8(p,v)	(set4(p,v),set4(p+4,v))
#define set16(p,v)	(set8(p,v),set8(p+8,v))

set256(p,v)
    register int *p;
    register v;
{
    register    i;
    v = v & 0xFF;
    v = v | (v << 8);
    v = v | (v << 16);
    for (i = 256 / sizeof(int); --i >= 0;)
	*p++ = v;
}

write_array(name,array)
	char *name;
	register char *array;
{
    register i;
    printf("\nstatic unsigned char %s[256] = {", name);
    for (i = 0; i<256; i++) {
	if ((i&0xF)==0) printf("\n\t");
	printf("%3d,",*array++&0xFF);
    }
    printf("\n};\n");
}

main() {
    set256(oplength,1);
    set256(optype,0);
    set256(ttype,0);
    ttype['c'] = enc_string+1;
    ttype['d'] = enc_int;
    ttype['e'] = enc_int+1;
    ttype['f'] = enc_IEEEfloat;
    ttype['s'] = enc_string;
    ttype['u'] = enc_int;
    bcopy(ttype+'a', ttype+'A', 26);
    ttype['F'] = enc_IEEEdouble;
    ttype['p'] = enc_syscommon;
    {	register i;
	for (i = 0; i<16; i++) {
	    oplength[enc_int + i] = (i&3)+1;
	    oplength[enc_short_string+i] = i+1;
	}
    }
    set4(optype+enc_string, enc_string);
    optype[enc_IEEEfloat] = enc_IEEEfloat;
    optype[enc_IEEEdouble] = enc_IEEEdouble;
    set16(optype+enc_int, enc_int);
    set16(optype+enc_short_string, enc_string);
    oplength[enc_string] = -2;
    oplength[enc_string+1] = -3;
    oplength[enc_string+2] = -4;
    oplength[enc_string+3] = -5;
    oplength[enc_IEEEfloat] = 5;
    oplength[enc_IEEEdouble] = 9;
    oplength[enc_tag] = 2;
    printf("/* This was automatically generated by mkpstoctbl, don't edit it */\n");
    write_array("oplength",oplength);
    write_array("optype", optype);
    write_array("ttype", ttype);
    exit(0);
}
