;-------------------------------------------------------------
;
;       Name:   CACHE.ASM. Program to enable or disable the
;               cache controller.
;       
;	Author:	Desmond Yuen
;
;	Date:	Dec 19th, 1992
;
;	Revision History: 
;
;       Copyright (C) by Intel Corporation 1992. All rights reserved
;
;-----------------------------------------------------------------


	INCLUDE	SUPERSET.INC

BLANK   EQU     20H     ; SPACE


code    SEGMENT
        ASSUME  cs:code, ds:code
        

        ORG     5DH
param1  LABEL   BYTE   		; first parameter

        ORG     100H

EXTRN	open_ibu:near, close_386sl:near

start:

	call    open_ibu
        mov     dx, OMLCR
        in      al, DX
        mov     bl, [param1]
        cmp     bl, BLANK
        jz      help
        cmp     AL, '0' 	; disable cache controller
        ja      enable
        and     AL, 7FH
        jmp     send
enable: or      AL, 80H
send:   out     DX, AL
done:
	call	close_386sl
        mov     AX, 4C00H
        int     21H             ; terminate program

help:   mov     ah, 09h		; Display help message
        push    ds
        push    ss
        pop     ds
        mov     dx, offset HELP_MES
        int     21h
        pop     ds
        jmp     done


;-------------------------------------------------------------
;
;                       DATA AREA
;
;-------------------------------------------------------------


HELP_MES         DB      'USAGE: CACHE -  0 = disable, 1 = enable$'
                

code    ENDS
        END     start        
