
;------------------------------------------------------------------
;
;	SFS.ASM: This file contains routines for accessing
;	the Special Features Set.
;
;	Author:	Desmond Yuen
;
;	Date:	Jan 21, 1992
;
;	Revision History: 
;
;-----------------------------------------------------------------


Include	superset.inc

code	segment	byte	public 'code'
	assume cs:code

EXTRN   open_ibu:near, close_386sl:near, open_360sl:near, close_360sl:near

PUBLIC	enable_sfs, disable_sfs



;-------------------------------------------------------------
;
;       enable_sfs: enable special features set
;
;       Input:  None
;
;       Output: carry flag set if not opened
;
;-------------------------------------------------------------

enable_sfs proc near

	push	ax

        call    open_ibu
        mov     dx, SFR         
        mov     al, 01h
        out     dx, al          ; set SFCPUEN bit
        call    close_386sl

        call    open_360sl
        mov     al, CFGR2
        out     CFGINDEX, al
        in      al, CFGDATA
        or      al, 08h         ; set SFIO_EN bit
        out     CFGDATA, al
        call    close_360sl

        out     SFS_ENABLE, al  ; dummy write to enable SFS

        mov     dx, SFS_INDEX   ; read/write test to index register
        mov     al, 0DDh
        out     dx, al
        in      al, dx
        cmp     al, 0DDh        
        jz      sfs_open        ; SFS is enabled
        stc

sfs_open:
	pop	ax
        ret

enable_sfs endp

;-------------------------------------------------------------
;
;       disable_sfs: disable special features set
;
;       Input:  None
;
;       Output: None
;
;-------------------------------------------------------------

disable_sfs proc near

	push	ax

        out     SFS_DISABLE, al  ; dummy write to disable SFS

        mov     dx, SFS_INDEX   ; read/write test to index register
        mov     al, 0DDh
        out     dx, al
        in      al, dx
        cmp     al, 0DDh        
        jnz     sfs_close       ; SFS is closed
        stc
sfs_close:
	pop	ax
        ret

disable_sfs endp


code	ends
	end
