

;------------------------------------------------------------------
;
;	SUPERSET.INC: This file contains equates for the 386SL
;	superset extension registers.
;
;	Author:	Desmond Yuen
;
;	Date:	Oct 15th, 1990
;
;	Revision History:
;
;------------------------------------------------------------------




; Equates for registers inside normal address space

FPP_CNTL        EQU     02H
CPUPWRMODE      EQU	 22H
CFGSTAT 	EQU	 23H
CFGINDEX	EQU	 24H
CFGDATA 	EQU	 25H
EMSCNTLREG	EQU	 28H
EMSINDEXREG	EQU	 2AH
EMSDPREG	EQU	 2CH
PORT_92 	EQU	 92H
SFS_INDEX       EQU     0AEH
SFS_DATA        EQU     0AFH
FAST_CPU_RESET	EQU	0EFH
FAST_A20_GATE	EQU	0EEH
MCP_REG_0	EQU	0F0H
MCP_REG_1	EQU	0F1H
SLOW_CPU	EQU	0F4H
FAST_CPU	EQU	0F5H
SFS_DISABLE	EQU	0F9H
SFS_ENABLE	EQU	0FBH
PORT_102	EQU	102H
FS_NMI_CNTRL	EQU     461H

; Equates for registers inside IBU

OMSR            EQU	25H
OMRBCR	        EQU	300H
OMLCR	        EQU	301H
OMDCR	        EQU	302H
OMSACR	        EQU	304H
OMSBCR	        EQU	306H
OMSCCR	        EQU	308H
OMSDCR	        EQU	30AH
OMSECR	        EQU	30CH
OMSFCR	        EQU	30EH
OMBRCR	        EQU	310H
GAACR	        EQU	311H
GABCR	        EQU	312H
NCACR	        EQU	314H
NCBCR	        EQU	316H
NCCCR	        EQU	318H
NCDCR	        EQU	31AH
NCECR	        EQU	31CH
NCFCR	        EQU	31EH
NCGCR	        EQU	700H
SMFILO	        EQU	702H
SMLIL	        EQU	704H
SFR	        EQU	705H
EMSBASE         EQU	706H



; Equates for registers inside OMCU

MCMODE          EQU	300H
MCRF	        EQU	301H
MCAS	        EQU	302H
MCSRAMWS        EQU	303H
MCDRAMMD	EQU     304H
MCBS		EQU     306H
MCPELA		EQU     308H
MCPELB		EQU     30AH
SIGNATURE	EQU     30EH
MCSMRAM 	EQU     310H
MCRASTO		EQU     312H

; Equates for registers inside EBU

EBC1CR		EQU     300H
EBC2CR		EQU     700H
ISAWINDOW	EQU     0B00H

; Equates for registers inside CCU

CCR		EQU     300H

; Equates for registers inside the 360SL configuration space

DMA_STP_CLK             EQU	 2DH
ROMCS_DEC	        EQU	 2FH
CFGR1		        EQU	 60H
CFGR2		        EQU	 61H
CFGR3		        EQU	 62H
DMA_WS1 	        EQU	 63H
DMA_WS2 	        EQU	 64H
COMABAL 	        EQU	 72H
COMABAH 	        EQU	 73H
COMBBAL 	        EQU	 74H
COMBBAH 	        EQU	 75H
T2CH1CNT	        EQU	 81H
T2CH2CNT	        EQU	 82H
T2COMMAND	        EQU	 83H
STP_BRK_CFG0	        EQU	0B0H
STP_BRK_CFG1	        EQU	0B1H
STP_BRK_CFG2	        EQU	0B2H
SYS_EVNT_CFG0	        EQU	0B3H
SYS_EVNT_CFG1	        EQU	0B4H
SYS_EVNT_CFG2	        EQU	0B5H
SM_REQ_CNTRL	        EQU	0B6H
SM_REQ_STS	        EQU	0B7H
SPND_STS	        EQU	0B8H
STDBY_TMR_CNTRL         EQU	0B9H
LSTDBY_STS	        EQU	0BAH
LTRP_STS	        EQU	0BBH
RESUME_MASK	        EQU	0BCH
SMI_CLR 	        EQU	0BDH
SUS_WRN_TMR	        EQU	0BEH
TRP_ADRL_DEV0	        EQU	0C0H
TRP_ADRH_DEV0	        EQU	0C1H
TRP_ADR_MSK_DEV0	EQU     0C2H
LSTDBY_TMR_DEV0 	EQU     0C3H
TRP_ADRL_DEV1		EQU     0C8H
TRP_ADRH_DEV1		EQU     0C9H
TRP_ADR_MSK_DEV1	EQU     0CAH
LSTDBY_TMR_DEV1 	EQU     0CBH
TRP_ADRL_DEV2		EQU     0D0H
TRP_ADRH_DEV2		EQU     0D1H
TRP_ADR_MSK_DEV2	EQU     0D2H
LSTDBY_TMR_DEV2 	EQU     0D3H
TRP_ADRL_DEV3		EQU     0D8H
TRP_ADRH_DEV3		EQU     0D9H
TRP_ADR_MSK_DEV3	EQU     0DAH
LSTDBY_TMR_DEV3 	EQU     0DBH
TRP_ADRL_DEV4		EQU     0E0H
TRP_ADRH_DEV4		EQU     0E1H
TRP_ADR_MSK_DEV4	EQU     0E2H
LSTDBY_TMR_DEV4 	EQU     0E3H
TRP_ADRL_DEV5		EQU     0E8H
TRP_ADRH_DEV5		EQU     0E9H
TRP_ADR_MSK_DEV5	EQU     0EAH
LSTDBY_TMR_DEV5 	EQU     0EBH
APWR_TMRH		EQU     0F0H
APWR_TMRL		EQU     0F1H
GSTDBY_TMRH		EQU     0F2H
GSTDBY_TMRL		EQU     0F3H
SUS_WRN_TMR_APWR	EQU     0F4H
SUS_WRN_TMR_BAT 	EQU     0F5H
SUS_WRN_TMR_SRBTN	EQU     0F6H
CRST_TMR		EQU     0F7H
CRST_PULSE		EQU     0F8H
SMI_MARK		EQU     0F9H
IDXLCK                  EQU     0FAH
EXT_STS 		EQU     0FBH
KC_CLK_CNTRL		EQU     0FCH
STP_CLK 		EQU     0FDH
PWROFF_CNTRL		EQU     0FEH
SUS_REF			EQU     0FFH


