 
;------------------------------------------------------------------
;
;       CFGSPACE.ASM: This file contains routines for accessing
;       the SL SUPERSET extension registers.
;
;       Author: Desmond Yuen
;
;       Date:   Dec 19, 1992
;
;       Revision History: 
;
;       Copyright (C) by Intel Corporation 1992. All rights reserved
;
;
;-----------------------------------------------------------------


	INCLUDE SUPERSET.INC

CODE    SEGMENT BYTE PUBLIC 'CODE'
	ASSUME CS:CODE

PUBLIC  open_cpupwrmode, close_cpupwrmode, open_ibu, open_omcu
PUBLIC  open_ebu, open_ccu, close_386sl, open_360sl
PUBLIC  read_360sl, write_360sl, close_360sl



;-------------------------------------------------------------
;
;       open_cpupwrmode: open CPUPWRMODE register
;
;       Input:  None
;
;       Output: carry flag set if not opened
;
;-------------------------------------------------------------

open_cpupwrmode proc near

	push    ax
	mov     ax, 8000h       ; execute unlocking sequence
	out     23h, al
	xchg    ah, al
	out     22h, al
	out     22h, ax
	in      al, 22h         ; is it opened?
	and     al, 01
	jnz     open_cpu_exit
	stc

open_cpu_exit:

	pop     ax
	ret

open_cpupwrmode endp

;-------------------------------------------------------------
;
;       close_cpupwrmode: lock CPUPWRMODE register
;
;       Input:  None
;
;       Output: None
;
;-------------------------------------------------------------

close_cpupwrmode proc near

	push    ax
	in      al, 23h
	or      al, 01h         ; set lock bit
	out     23h, al
	in      al, 22h
	and     al, 01          ; is it closed
	jz      close_cpu_exit
	stc

close_cpu_exit:

	pop     ax
	ret

close_cpupwrmode endp

;-------------------------------------------------------------
;
;       open_ibu: open IBU configuration space
;
;       Input: None
;
;       Output: None
;
;-------------------------------------------------------------

open_ibu proc near

	call    open_cpupwrmode
	push    ax
	in      al, 22h
	or      al, 0Ah         ; enable IBU
	and     al, 0FBh        
	out     22h, al
	pop     ax
	call    close_cpupwrmode
	ret

open_ibu endp


;-------------------------------------------------------------
;
;       open_omcu: open OMCU configuration space
;
;       Input: None
;
;       Output: None
;
;-------------------------------------------------------------

open_omcu proc near
	
	call    open_cpupwrmode
	push    ax
	in      al, 22h
	or      al, 02h         ; enable OMCU
	and     al, 0F3h        
	out     22h, al
	pop     ax
	call    close_cpupwrmode
	ret

open_omcu endp


;-------------------------------------------------------------
;
;       open_ebu: open EBU configuration space
;
;       Input: None
;
;       Output: None
;
;-------------------------------------------------------------

open_ebu proc near

	call    open_cpupwrmode
	push    ax
	in      al, 22h
	or      al, 0Eh         ; enable EBU
	out     22h, al
	pop     ax
	call    close_cpupwrmode
	ret

open_ebu endp

;-------------------------------------------------------------
;
;       open_ccu: open CCU configuration space
;
;       Input: None
;
;       Output: None
;
;-------------------------------------------------------------

open_ccu proc near

	call    open_cpupwrmode
	push    ax
	in      al, 22h
	or      al, 06h         ; enable CCU
	and     al, 0F7h
	out     22h, al
	pop     ax
	call    close_cpupwrmode
	ret

open_ccu endp

;-------------------------------------------------------------
;
;       close_386sl: close all configuration spaces on 386SL
;
;       Input: None
;
;       Output: None
;
;-------------------------------------------------------------

close_386sl proc near

	push    ax
	in      al, 22h         ; is CPUPWRMODE unlocked
	and     al, 01h
	jnz     short en
	call    open_cpupwrmode
en:     in      al, 22h
	and     al, 0FDH        ; disable all configuration
	out     22h, al         ; spaces
	call    close_cpupwrmode
	pop     ax
	ret

close_386sl endp

;-------------------------------------------------------------
;
;       open_360sl: open 360SL configuration space
;
;       Input: None
;
;       Output: None
;
;-------------------------------------------------------------       


open_360sl proc near

	push    dx
	push    ax
	mov     dx,0FC23H       ; 1st IO address
	in      al,dx           ; 1st dummy IO read 
	mov     dx,0F023H       ; 2nd IO address
	in      al,dx           ; 2nd dummy IO read 
	mov     dx,0C023H       ; 3rd IO address
	in      al,dx           ; 3rd dummy IO read 
	mov     dx,00023H       ; 4th IO address
	in      al,dx           ; 4th dummy IO read 
	pop     ax
	pop     dx
	ret

open_360sl endp


;-------------------------------------------------------------
;
;  read_360sl: get 360SL register value             
;  Input  : bl = index of a 360SL register
;  Output : al = data read
;
;-------------------------------------------------------------
 
read_360sl proc near

	mov     al,bl           ; POINT TO THE INDEX.
	out     CFGINDEX,al     ; PROGRAM CFGINDEX REGISTER.
	in      al,CFGDATA      ; READ THE DATA.
	ret

read_360sl endp

;-------------------------------------------------------------
;
;  write_360sl: write new value into a 360SL register
;
;  Input  : bl = index of the 360SL register
;           bh = Data to be written 
;  Output : None.
;
;-------------------------------------------------------------


write_360sl proc near

	mov     al, bl          ; POINT TO THE INDEX.
	out     CFGINDEX, al    ; PROGRAM CFGINDEX REGISTER.
	mov     al, bh          ; GET THE DATA TO BE WRITTEN.
	out     CFGDATA, al     ; WRITE IT.
	ret

write_360sl endp



;-------------------------------------------------------------
;
;       close_360sl: close 360SL configuration space
;
;       Input: None
;
;       Output: None
;
;-------------------------------------------------------------

close_360sl proc near

	push    ax
	mov     al, IDXLCK
	out     CFGINDEX, al
	mov     al, 01h         ; set lock bit
	out     CFGDATA,  al
	pop     ax
	ret

close_360sl endp

code    ends
	end
