
;-------------------------------------------------------------
;
;	LTRP.ASM: This file contains routines that handle
;	local trap requests
;
;	Author:	Desmond Yuen
;
;	Date: Dec 19, 1992
;
;	Revision History:
;
;	Copyright 1992 by McGraw-Hill, Inc. All rights reserved.
;
;------------------------------------------------------------------


Include Superset.inc

code	segment	public	'code'
	assume	cs:code

PUBLIC	exec_ltrp, exec_trap_0,exec_trap_1,exec_trap_2,exec_trap_3
PUBLIC  exec_trap_4, exec_trap_5, smout_on

EXTRN   open_360sl:near, read_360sl:near, write_360sl:near, close_360sl:near
EXTRN   open_ibu:near, close_386sl:near

;       SMOUT PINS ASSIGNMENT:

;      --------------------------
;     | SMOUT0 | FLOPPY DRIVE    |
;      --------------------------
;     | SMOUT1 | SERIAL PORT A   |
;      --------------------------
;     | SMOUT2 - SERIAL PORT B   |
;      --------------------------
;     | SMOUT3 - HARD DISK       |
;      --------------------------
;     | SMOUT4 - PARALLEL PORT   |
;      --------------------------
;     | SMOUT5 - FLASH VPP       |
;      --------------------------


;------------------------------------------------------------------
;
;	exec_ltrp: Procedure to process local trap request
;
;	Input:	None
;
;	Output:	None
;
;-------------------------------------------------------------------



exec_ltrp	proc	near		; local trap request
	mov	al, 0e4h		; local trap post code
	out	80h, al
	call	open_360sl
	mov	bl, LTRP_STS
	call	read_360sl      	; read LSTDBY request reg
        call    close_360sl
	shr	al, 1			; is it a device 0 trap request
	jnc	trp1			; no
	call	exec_trap_0
trp1:	shr	al, 1	 		; is it a device 1 trap request
	jnc	trp2			; no
	call	exec_trap_1
trp2:	shr	al, 1			; is it a device 2 trap request
	jnc	trp3			; no
	call	exec_trap_2
trp3:	shr	al, 1			; is it a device 3 trap request
	jnc	trp4	   		; no
	call	exec_trap_3
trp4:	shr	al, 1			; is it a device 4 trap request
	jnc	trp5			; no
	call	exec_trap_4
trp5:	shr	al, 1			; is it a device 5 trap request
	jnc	notrp			; no
	call	exec_trap_5
notrp:	
        call    open_360sl
        mov     bl, LTRP_STS		; clear trap request
        mov     bh, 0h
        call    write_360sl
        call	close_360sl		; exit
	ret
exec_ltrp	endp


;------------------------------------------------------------------
;
;	exec_trap_0: Procedure to handle local trap request 0
;
;	Input:	None
;
;	Output:	None
;
;-------------------------------------------------------------------


exec_trap_0	proc	near
        push    ax
        call    open_360sl              
        mov     bl, TRP_ADR_MSK_DEV0    ; disable IO trap
        call    read_360sl
        and     al, 7fh
        mov     bh, al
        call    write_360sl

        mov     bl, STDBY_TMR_CNTRL     ; enable lstdby
        call    read_360sl
        or      al, 01h
        mov     bh, al
        call    write_360sl

        call    close_360sl
        mov     bh, 0           	; power up floppy drive
        call    smout_on

        mov     al, 0d0h
        out     80h, al
        pop     ax
	ret
exec_trap_0	endp



;------------------------------------------------------------------
;
;	exec_trap_1: Procedure to handle local trap request 1
;
;	Input:	None
;
;	Output:	None
;
;-------------------------------------------------------------------


exec_trap_1	proc	near
        push    ax
        call    open_360sl              
        mov     bl, TRP_ADR_MSK_DEV1    ; disable IO trap
        call    read_360sl
        and     al, 7fh
        mov     bh, al
        call    write_360sl

        mov     bl, STDBY_TMR_CNTRL     ; enable lstdby
        call    read_360sl
        or      al, 02h
        mov     bh, al
        call    write_360sl

        call    close_360sl
        mov     bh, 1           	; re-enable RS232 buffer
        call    smout_on

        mov     al, 0d1h
        out     80h, al
        pop     ax
	ret
exec_trap_1	endp


;------------------------------------------------------------------
;
;	exec_trap_2: Procedure to handle local trap request 2
;
;	Input:	None
;
;	Output:	None
;
;-------------------------------------------------------------------


exec_trap_2	proc	near
        push    ax
        call    open_360sl              
        mov     bl, TRP_ADR_MSK_DEV2    ; disable IO trap
        call    read_360sl
        and     al, 7fh
        mov     bh, al
        call    write_360sl

        mov     bl, STDBY_TMR_CNTRL     ; enable lstdby
        call    read_360sl
        or      al, 04h
        mov     bh, al
        call    write_360sl

        call    close_360sl
        mov     bh, 2           	; re-enable RS232 buffer
        call    smout_on

        mov     al, 0d2h
        out     80h, al
        pop     ax
	ret
exec_trap_2	endp



;------------------------------------------------------------------
;
;	exec_trap_3: Procedure to handle local trap request 3
;
;	Input:	None
;
;	Output:	None
;
;-------------------------------------------------------------------


exec_trap_3	proc	near
        push    ax
        call    open_360sl              
        mov     bl, TRP_ADR_MSK_DEV3    ; disable IO trap
        call    read_360sl
        and     al, 7fh
        mov     bh, al
        call    write_360sl

        mov     bl, STDBY_TMR_CNTRL     ; enable lstdby
        call    read_360sl
        or      al, 08h
        mov     bh, al
        call    write_360sl

        call    close_360sl
        mov     bh, 3           	; re-enable RS232 buffer
        call    smout_on

        mov     al, 0d3h
        out     80h, al
        pop     ax
	ret
exec_trap_3	endp



;------------------------------------------------------------------
;
;	exec_trap_4: Procedure to handle local trap request 4
;
;	Input:	None
;
;	Output:	None
;
;-------------------------------------------------------------------


exec_trap_4	proc	near
        push    ax
        call    open_360sl              
        mov     bl, TRP_ADR_MSK_DEV4    ; disable IO trap
        call    read_360sl
        and     al, 7fh
        mov     bh, al
        call    write_360sl

        mov     bl, STDBY_TMR_CNTRL     ; enable lstdby
        call    read_360sl
        or      al, 010h
        mov     bh, al
        call    write_360sl

        call    close_360sl
        mov     bh, 4           	; re-enable LPT buffer
        call    smout_on

        mov     al, 0d4h
        out     80h, al
        pop     ax

	ret
exec_trap_4	endp



;------------------------------------------------------------------
;
;	exec_trap_5: Procedure to handle local trap request 5
;
;	Input:	None
;
;	Output:	None
;
;-------------------------------------------------------------------


exec_trap_5	proc	near
; not used
	ret
exec_trap_5	endp


;-------------------------------------------------------------
;
;
;       smout_on:  Set smout pin (SMOUT pins are high by default)
;
;       Input:  bh = pin number
;
;       Output: None
;
;-------------------------------------------------------------


smout_on   proc near

        cmp     bh, 0           	; pin 0?
        ja      pin1
        mov     bh, 01h
        jmp     send
pin1:   cmp     bh, 1           	; pin 1?
        ja      pin2
        mov     bh, 02h
        jmp     send
pin2:   cmp     bh, 2           	; pin 2?
        ja      pin3
        mov     bh, 04h
        jmp     send
pin3:   cmp     bh, 3           	; pin 3?
        ja      pin4
        mov     bh, 08h
        jmp     send
pin4:   cmp     bh, 4           	; pin 4?
        ja      pin5
        mov     bh, 10h
        jmp     send
pin5:   cmp     bh,  5           	; pin 5?
        mov     bh, 20h
send:
        call	open_360sl
	mov	bl, SMOUT_CNTRL
        call	read_360sl
        or      al, bh
	mov	bh, al
        call	write_360sl
        call	close_360sl
        ret

smout_on endp


code	ends
	end

