
;-------------------------------------------------------------
;
;
;       NAME    SPEED.ASM. Program to change the speed of the
;               CPU.
;
;       Usage   SPEED   DIVISOR
;
;	Author:	Desmond Yuen
;
;	Date:	Dec 19, 1992
;
;	Revision History: 
;
;       Copyright (C) by McGraw-Hill, Inc 1992. All rights reserved
;
;
;
;-------------------------------------------------------------


	INCLUDE	SUPERSET.INC


blank   EQU     20H     	; space
FULL    EQU     00H     	; full speed
HALF    EQU     10H     	; divide by 2
FOURTH  EQU     20H     	; divide by 4
EIGHTH  EQU     30H     	; divide by 8


CODE    SEGMENT
        ASSUME  CS:CODE, DS:CODE

EXTRN	open_cpupwrmode:near, close_cpupwrmode:near

        ORG     5DH
param1  LABEL   BYTE    ; divisor

        ORG     100H

start:


; get divisor

        call	open_cpupwrmode
        MOV     AL, [param1]
        CMP     AL, blank       ; anything?
        JZ      help
        CMP     AL, '1'         ; divide by 1?
        JA      two
        MOV     BITMASK, FULL
        JMP     set
two:    CMP     AL, '2'         ; divide by 2?
        JA      three
        MOV     BITMASK, HALF
        JMP     set
three:  CMP     AL, '4'         ; divide by 4?
        JA      four    
        MOV     BITMASK, FOURTH
        JMP     set
four:   CMP     AL, '8'         ; divide by 8?
        JA      help
        MOV     BITMASK, EIGHTH
set:    IN      AL, 22H
        OR      AL, BITMASK
        OUT     22H, AL
        JMP     done       
help:   MOV     AH, 09H
        PUSH    DS
        PUSH    SS
        POP     DS
        MOV     DX, OFFSET HELP_MES
        INT     21H
        POP     DS
done:
        call	close_cpupwrmode
        MOV     AX, 4C00H
        INT     21H             ; terminate program

;-------------------------------------------------------------
;
;                       DATA AREA
;
;-------------------------------------------------------------


HELP_MES        DB      'USAGE: SPEED - DIVISOR (1/2/4/8)$'
BITMASK         DB      ?                


CODE    ENDS
        END     start        

