
;-------------------------------------------------------------
;
;
;       NAME    MCPSPEED.ASM: Program to change the speed of the
;               CPU.
;
;       Usage   MCPSPEED   DIVISOR
;
;	Author:	Desmond Yuen
;
;	Date:	Dec 19, 1992
;
;	Revision History: 
;
;       Copyright (C) by McGraw-Hill, Inc 1992. All rights reserved
;
;-------------------------------------------------------------




blank   EQU     20H     	; space
FULL    EQU     00H     	; full speed
HALF    EQU     10H     	; divide by 2
FOURTH  EQU     20H     	; divide by 4
EIGHTH  EQU     30H     	; divide by 8


code    SEGMENT
        ASSUME  cs:code, ds:code


        ORG     5Dh
param1  LABEL   BYTE    	; divisor
        ORG     100h

start:

; open cpupwrmode register

        mov     ax, 8000h       ; execute unlocking sequence
        out     23h, al
        xchg    ah, al
        out     22h, al
        out     22h, ax

; set mcp clock to full speed

        in      al, 23h
        and     al, 0c7h

; get divisor

        push    ax
        mov     al, [param1]
        cmp     al, blank       ; anything?
        jz      help
        cmp     al, '0'         ; stop cpu clock
        ja      one
        pop     ax
        or      al, 0FFh
        jmp     set
one:    cmp     al, '1'         ; divide by 1?
        ja      two
        pop     ax
        jmp     set
two:    cmp     al, '2'         ; divide by 2?
        ja      four
        pop     ax
        or      al, 0CFh
        jmp     set
four:   cmp     al, '4'         ; divide by 4?
        ja      six
        pop     ax
        or      al, 0D7h
        jmp     set
six:    cmp     al, '6'         ; divide by 16?
        ja      eight
        pop     ax
        or      al, 0E7h
        jmp     set
eight:  cmp     al, '8'         ; divide by 8?
        ja      help
        pop     ax
        or      al, 0DFh
        jmp     set
set:    
        out     23h, al
        jmp     done       
help:   mov     ah, 09H
        mov     dx, OFFSET HELP_MES
        int     21h
done:              

; close cpupwrmode register

        in      al, 23h
        or      al, 01h         ; set lock bit
        out     23h, al

        mov     ax, 4C00h
        int     21h             ; terminate program

;-------------------------------------------------------------
;
;                       DATA AREA
;
;-------------------------------------------------------------


HELP_MES        DB      'USAGE: SPEED - DIVISOR (0/1/2/4/6/8)$'
BITMASK         DB      ?                


CODE    ENDS
        END     start        

