;---------------------------------------------------------------------------
;
; %FILE     x86.inc
; %VSS-REV  $Revision: 1 $
; %VERSION  1.1
; %CREATED  1995.07.31
; %REVISED  $Date: 10/30/96 5:26p $
; %AUTHOR   Michael C. Draeger 
; %PROJECT  NS486SXF evaluation board software
; %PART     NS486SXF 
; %SUMMARY  macros for various x86 instructions 
;     
; %VSS      $Author: Miked $ $Date: 10/30/96 5:26p $ $Revision: 1 $
;
; DESCRIPTION
;
;   Macros that do x86 instructions that Masm does not like to code.
;
; RELEASE HISTORY
;
;   1.0   1995.08.01  mcd  genesis
;   1.1   1996.10.30  mcd  updated headers for VSS SCCS
;
; COPYRIGHT
;
;      (c) 1995, 1996 National Semiconductor Corporation
;
;---------------------------------------------------------------------------
        
; jmpfp - far intersegment jump

jmpfp MACRO seg, off
        db 0eah                         ; opcode for far jump (JMP ptr16:32)
        dd off                          ; offset                    
        dw seg                          ; code segment
ENDM

; jmpn - near (32 bit) jump

jmpn  MACRO off
        db 0E9h                         ; opcode for near jump (JMP rel32)         
        dd off                          ; relative offset
ENDM

;---------------------------------------------------------------------------
; END       x86.inc 
;---------------------------------------------------------------------------
