//---------------------------------------------------------------------------
//
// %FILE     biu.c
// %VSS-REV  $Revision: 16 $
// %CREATED  1995.12.22
// %REVISED  $Date: 4/18/97 4:00p $
// %AUTHOR   Noreen Bell 
// %PROJECT  NS486SXF evaluation board software
// %PART     NS486SXF
// %SUMMARY  Bus Interface Unit module
//     
// %VSS      $Author: Miked $ $Date: 4/18/97 4:00p $ $Revision: 16 $
//
// DESCRIPTION
//
//   This file contains code for the NS486SXF Bus Interface Unit
//
// HISTORY
//
/*
 *
 * $History: biu.c $ 
 * 
 * *****************  Version 16  *****************
 * User: Miked        Date: 4/18/97    Time: 4:00p
 * Updated in $/nsdemo
 * Partial update for SXL.  New header (comment) changes.
 * 
 * *****************  Version 14  *****************
 * User: Miked        Date: 8/06/96    Time: 11:59a
 * Updated in $/nsdemo
 * Version 1.4.  Maintainance release.  See README.TXT for info.
 * 
 * *****************  Version 13  *****************
 * User: Miked        Date: 7/23/96    Time: 2:25p
 * Updated in $/nsdemo
 * Maintainance release.  README.TXT describes changes.
 * 
 * *****************  Version 12  *****************
 * User: Miked        Date: 7/22/96    Time: 10:57a
 * Updated in $/nsdemo
 * Minor change: ORes in CS8.  Only depends on BIU_V_CS_EN for
 * default Flash Loader chip selects.
 * 
 * *****************  Version 11  *****************
 * User: Miked        Date: 7/22/96    Time: 10:47a
 * Updated in $/nsdemo
 * Fixed bug: now only enables CS3,4 if used for cache bug rev B).
 * 
 * *****************  Version 10  *****************
 * User: Miked        Date: 7/16/96    Time: 11:54a
 * Updated in $/nsdemo
 * Updated for rev C0 release.
 * 
 * *****************  Version 9  *****************
 * User: Noreen       Date: 6/19/96    Time: 2:17p
 * Updated in $/nsdemo
 * Changed revision check to B insted of C
 * 
 * *****************  Version 8  *****************
 * User: Noreen       Date: 6/19/96    Time: 2:12p
 * Updated in $/nstest
 * Cache  fix is now exceuted based on revision of device.
 * 
 * *****************  Version 7  *****************
 * User: Miked        Date: 6/07/96    Time: 10:04a
 * Updated in $/nsdemo
 * Commented out un-cacheable space fix.  Rev C doesn't need this.  May do
 * this based on chip ID later.
 * 
 * *****************  Version 6  *****************
 * User: Miked        Date: 5/03/96    Time: 2:50p
 * Updated in $/nsdemo
 * Maintainence release.
 * 
 * *****************  Version 5  *****************
 * User: Miked        Date: 4/23/96    Time: 1:03p
 * Updated in $/nsdemo
 * Added CS3 and CS4 to try to workaround B2 cache problem.  Cleaned up a
 * little.  Added comments.
 * 
 * *****************  Version 4  *****************
 * User: Miked        Date: 4/18/96    Time: 1:16p
 * Updated in $/nsdemo
 * Modified release history.
 * 
 * *****************  Version 3  *****************
 * User: Noreen       Date: 4/18/96    Time: 11:34a
 * Updated in $/nsdemo
 * Updated comments for version release
 * 
 * *****************  Version 2  *****************
 * User: Miked        Date: 4/12/96    Time: 1:45p
 * Updated in $/nstest
 * Revised headers for VSS.
 *
 */
//
// COPYRIGHT
//
//      (c) 1995, 1996, 1997 National Semiconductor Corporation
//
// NOTES
//
//   This module currently writes absolute values to BIU registers.
//   It should really do read-modify-write.  As it is now, this code
//   depends on whatever boot code comes before this to be using chip
//   selects exactly as we are expecting.  This is the case for the SSI
//   and Pharlap evaluation tools which this code currently runs under.
//
//   The "BOILER" example included with the NS486SXF software sets up the
//   chip selects as the Flash Loader does.  Pharlap relies on the Flash
//   Loader to set this stuff up, so it will be identical.  SSI does their
//   own set up, but it is identical to what the Flash Loader currently
//   does.
//
//   The point: this module is not very generic.  The values set in
//   NS486CFG.H can not be changed without being aware of how the Flash
//   Loader sets up chip selects.  This is not a big problem as for the
//   evaluation board there is no real reason to change the chip selects.
//   Just be aware of this.
//
//---------------------------------------------------------------------------

#include "biu.h"

//---------------------------------------------------------------------------
// FUNCTION     BIU_Initialize()
//
// INPUT        none
// OUTPUT       none    
//
// RETURN      USHORT
//               SUCCESS - if successful
//
// DESCRIPTION
//      This function initializes the BIU control registers to enable access
//      to the NS486 peripherals.
//
//      In addition logical chip selects are programmed in this function.
//
//---------------------------------------------------------------------------

USHORT BIU_Initialize(void)
{

// Enable access to peripherals
  IOW_BYTE(BIU_CONTROL1, BIU_V_CONTROL1);
  IOW_BYTE(BIU_CONTROL2, BIU_V_CONTROL2);

// Chip select 8 is used to shadow Flash for DMA transfer

  // Program Base Address for logical CS8
  IOW_WORD(BIU_CSBAR8_0, BIU_V_CSBAR8_0);
  IOW_WORD(BIU_CSBAR8_2, BIU_V_CSBAR8_2);

  // Program MASK for decoding addresses
  IOW_WORD(BIU_CSARR8_0, BIU_V_CSARR8_0);
  IOW_WORD(BIU_CSARR8_2, BIU_V_CSARR8_2);
  
  //Insert Delay into logical CS8 accesses
  IOW_BYTE(BIU_CSATR4, BIU_V_CSATR4);

  //Map logical CS8 to External CS0
  IOW_BYTE(BIU_RBSR, BIU_V_RBSR);
  
//Program IO Cycle Type and width
  IOW_BYTE(BIU_CS_TYPE, BIU_V_CS_TYPE);
  IOW_BYTE(BIU_P16LCSR, BIU_V_P16LCSR);

//Enable logical CS decodes
  IOW_BYTE(BIU_CS_EN, (BIU_V_CS_EN | 0x80 ) );  // defaults + CS8
  
// Chip select 3 and 4 are used to workaround a cache problem.  This fix
// should be done in boot code, after which other code should not change
// the registers used.  This is not a good example of how to implement
// the workaround.  Please see the NS486SXF revision B2 User Information
// sheet for how to properly implement the workaround.  This is put here
// to draw attention to the fix and allow this code to work fine without
// having the proper fix in place.  (The cache problem was not affecting this
// code until after this point.)
  
  if ((gDeviceInfo.id == ID_NS486SXF)
     && (gDeviceInfo.rev == SXF_REV_B))
  {

     // Program Base Address for logical CS3, 4

     IOW_WORD(BIU_CSBAR3_0, BIU_V_CSBAR3_0);
     IOW_WORD(BIU_CSBAR3_2, BIU_V_CSBAR3_2);
     IOW_WORD(BIU_CSBAR4_0, BIU_V_CSBAR4_0);
     IOW_WORD(BIU_CSBAR4_2, BIU_V_CSBAR4_2);

     // Program MASK for decoding addresses
  
     IOW_WORD(BIU_CSARR3_0, BIU_V_CSARR4_0);
     IOW_WORD(BIU_CSARR3_2, BIU_V_CSARR4_2);
     IOW_WORD(BIU_CSARR4_0, BIU_V_CSARR4_0);
     IOW_WORD(BIU_CSARR4_2, BIU_V_CSARR4_2);
  
     //Timing
  
     IOW_BYTE(BIU_CSATR2, BIU_V_CSATR2);

     //Enable logical CS decodes
     
     IOW_BYTE(BIU_CS_EN, ( BIU_V_CS_EN | 0x8C ) );  // defaults + CS3,4,8
  
  }


  return SUCCESS;

}

//---------------------------------------------------------------------------
// END       biu.c
//---------------------------------------------------------------------------
