;---------------------------------------------------------------------------
;
; %FILE     cpu.asm
; %VSS-REV  $Revision: 9 $
; %CREATED  1996.06.28
; %REVISED  $Date: 4/18/97 4:01p $
; %AUTHOR   Michael C. Draeger 
; %PROJECT  NS486SXF evaluation board software
; %PART     NS486SXF, NS486SXL
; %SUMMARY  Simple assembly routines for NSDEMO
;     
; %VSS      $Author: Miked $ $Date: 4/18/97 4:01p $ $Revision: 9 $
;
; DESCRIPTION
;
;   This assembly module has simple routines which are called by NSDEMO
;   to perform tasks that can not be done in C.
;
;   This is desirable to inline assembly, as the different compilers
;   support inline assembly differently.  32 bit Borland C++ does not
;   seem to support inline assembly without also purchasing TASM.
;   Using assembly "THUNK" functions for interrupts also simplifies the
;   interrupt handling, as the C compilers do not provide consistent
;   ways to handle interrupts directly.
;
;   Since not everyone has an assembler, this code is assembled into
;   "cpu.o" instead of "cpu.obj".  This avoids accidental deletion of the
;   object file.  If you do with to re-assemble this code, you can use
;   MASM, TASM, or WASM as follows:
;
;     ml /c /Focpu.o cpu.asm
;
;     tasm /mx cpu.asm, cpu.o
;
;     wasm -focpu.o cpu.asm
;   
; HISTORY
;
;  $History: cpu.asm $ 
; 
; *****************  Version 9  *****************
; User: Miked        Date: 4/18/97    Time: 4:01p
; Updated in $/nsdemo
;  New header (comment) changes.
; 
; *****************  Version 8  *****************
; User: Miked        Date: 8/06/96    Time: 11:59a
; Updated in $/nsdemo
; Version 1.4.  Maintainance release.  See README.TXT for info.
; 
; *****************  Version 7  *****************
; User: Miked        Date: 8/05/96    Time: 2:34p
; Updated in $/nsdemo
; Misc. fixes: renamed segment to _TEXT, declared functions as near or
; far as appropriate.  No real difference, but this should make the code
; consistant between the different tools.
; 
; *****************  Version 6  *****************
; User: Miked        Date: 7/23/96    Time: 3:44p
; Updated in $/nsdemo
; Fixed typo in EXTRN declaration and added ASSUME statement to allow
; assembly with TASM.  (MASM and WASM work both ways.)
; 
; *****************  Version 5  *****************
; User: Miked        Date: 7/23/96    Time: 2:25p
; Updated in $/nsdemo
; Maintainance release.  README.TXT describes changes.
; 
; *****************  Version 4  *****************
; User: Miked        Date: 7/23/96    Time: 11:43a
; Updated in $/nsdemo
; Added ISR thunk routines and removed IRTED routines.  Now hook
; interrupt vectors to these THUNK routines, which call C ISRs.
; 
; *****************  Version 3  *****************
; User: Miked        Date: 7/16/96    Time: 11:54a
; Updated in $/nsdemo
; Updated for rev C0 release.
; 
; *****************  Version 2  *****************
; User: Miked        Date: 7/01/96    Time: 4:35p
; Updated in $/nsdemo
; Added some notes on entry code.
; 
; *****************  Version 1  *****************
; User: Miked        Date: 6/28/96    Time: 2:10p
; Created in $/nsdemo
; Initial version of assembly code for NSDEMO.
;
; COPYRIGHT
;
;      (c) 1996, 1997 National Semiconductor Corporation
;
; NOTES
;
;   Borland and Microsoft add an underscore (_) to C functions.
;   Thus when you call _cpu_cli, it will call the routine __cpu_cli.
;   Watcom does not seem to do this by default.  The __cdecl modifier
;   should be used with the ISR funtions to ensure consistency.  When
;   the __cdecl modifier is used, an underscore will be added to the
;   ISR funtion in all three compilers.
;
;   Near and far modifiers are used in this file to ensure that the
;   different assemblers assembly this file correctly.
;
;   The segment in this file is called "_TEXT" which is the default
;   code segment produced by the compilers.  In previous versions this
;   file used the name "CODESG" which resulted in additional segments.
;   This change was made to make sure the different linkers properly
;   linked the object files.
;
;---------------------------------------------------------------------------

.486p

; start of code

_TEXT SEGMENT DWORD USE32 PUBLIC 'CODE'

ASSUME CS:_TEXT

; ISR functions called by the ISR THUNK functions here

EXTRN _ISR_PIT1:near
EXTRN _ISR_PIT_WD:near
EXTRN _ISR_RTC:near
EXTRN _ISR_PCM:near

; these routines are PUBLIC.  I.e., C can call them.

PUBLIC __cpu_cli
PUBLIC __cpu_sti
PUBLIC __cpu_enable_cache
PUBLIC __cpu_disable_cache
PUBLIC _ISR_PIT1_THUNK
PUBLIC _ISR_PIT_WD_THUNK
PUBLIC _ISR_RTC_THUNK
PUBLIC _ISR_PCM_THUNK

; __cpu_cli - perform a CLI instruction

__cpu_cli  PROC near
	   cli
	   ret
__cpu_cli  ENDP

; __cpu_sti - perform a STI instruction

__cpu_sti  PROC near
	   sti
	   ret
__cpu_sti  ENDP

; __cpu_disable_cache - set the CD bit in CR0 (disable cache)

__cpu_disable_cache     PROC near
			mov eax, cr0
			or eax, 40000000h
			mov cr0, eax
			ret
__cpu_disable_cache     ENDP

; __cpu_enable_cache - clear the CD bit in CR0 (enable cache)

__cpu_enable_cache      PROC near
			mov eax, cr0
			and eax, 0BFFFFFFFh
			mov cr0, eax
			ret
__cpu_enable_cache      ENDP

; THUNK functions for ISRs.  These functions are hooked to the IDT
; and thus called upon interrupts.  They call C functions in the
; normal code to handle the interrupt.

_ISR_PIT1_THUNK PROC far
	sti
	cld
	pushad
	call _ISR_PIT1
	popad
	iretd
_ISR_PIT1_THUNK ENDP

_ISR_PIT_WD_THUNK PROC far
	sti
	cld
	pushad
	call _ISR_PIT_WD
	popad
	iretd
_ISR_PIT_WD_THUNK ENDP

_ISR_RTC_THUNK PROC far
	sti
	cld
	pushad
	call _ISR_RTC
	popad
	iretd
_ISR_RTC_THUNK ENDP

_ISR_PCM_THUNK PROC far
	sti
	cld
	pushad
	call _ISR_PCM
	popad
	iretd
_ISR_PCM_THUNK ENDP

_TEXT ENDS

END

;---------------------------------------------------------------------------
; END       cpu.asm
;---------------------------------------------------------------------------
