//---------------------------------------------------------------------------
//
// %FILE     rtc.h
// %VSS-REV  $Revision: 13 $
// %CREATED  1995.12.20
// %REVISED  $Date: 4/18/97 4:22p $
// %AUTHOR   Noreen Bell
// %PROJECT  NS486SXF evaluation board software
// %PART     NS486SXF (B0+), NS486SXL
// %SUMMARY  Real Time Clock header module
//     
// %VSS      $Author: Miked $ $Date: 4/18/97 4:22p $ $Revision: 13 $
//
// DESCRIPTION
//
//   This header file contains definitions for the Real Time Clock
//
// HISTORY
//
/*
 *
 * $History: rtc.h $
 * 
 * *****************  Version 13  *****************
 * User: Miked        Date: 4/18/97    Time: 4:22p
 * Updated in $/nsdemo
 * Added fields for new rtc.c changes.  Reformatted a little.   New header
 * (comment) changes.
 * 
 * *****************  Version 12  *****************
 * User: Miked        Date: 12/04/96   Time: 4:08p
 * Updated in $/nsdemo
 * Added missing function prototypes.
 * 
 * *****************  Version 11  *****************
 * User: Miked        Date: 12/04/96   Time: 1:45p
 * Updated in $/nsdemo
 * Stupid change in release history.
 * 
 * *****************  Version 10  *****************
 * User: Miked        Date: 12/04/96   Time: 1:37p
 * Updated in $/nsdemo
 * Updated version to 1.6.
 * 
 * *****************  Version 9  *****************
 * User: Miked        Date: 10/03/96   Time: 4:54p
 * Updated in $/nsdemo
 * Added #defines for modified RTC.C: added several commands, added
 * Periodic Interrupt rate defines, etc.
 * 
 * *****************  Version 8  *****************
 * User: Miked        Date: 8/06/96    Time: 11:59a
 * Updated in $/nsdemo
 * Version 1.4.  Maintainance release.  See README.TXT for info.
 * 
 * *****************  Version 7  *****************
 * User: Miked        Date: 7/23/96    Time: 2:26p
 * Updated in $/nsdemo
 * Maintainance release.  README.TXT describes changes.
 * 
 * *****************  Version 6  *****************
 * User: Miked        Date: 7/16/96    Time: 11:54a
 * Updated in $/nsdemo
 * Updated for rev C0 release.
 * 
 * *****************  Version 5  *****************
 * User: Miked        Date: 7/01/96    Time: 11:36a
 * Updated in $/nsdemo
 * Removed stuff about Dates Of Month Alarm - which is not useful.  An
 * update to the datasheet will explain how this register works.
 * 
 * *****************  Version 4  *****************
 * User: Miked        Date: 5/03/96    Time: 2:50p
 * Updated in $/nsdemo
 * Maintainence release.
 * 
 * *****************  Version 3  *****************
 * User: Noreen       Date: 4/18/96    Time: 12:35p
 * Updated in $/nsdemo
 * Updated comments for version release
 * 
 * *****************  Version 2  *****************
 * User: Noreen       Date: 4/12/96    Time: 3:01p
 * Updated in $/nstest
 * Updated headers for VSS
 *
 */
//
// COPYRIGHT
//
//      (c) 1995, 1996, 1997 National Semiconductor Corporation
//
//---------------------------------------------------------------------------

#ifndef RTC_H_INC
#define RTC_H_INC

//---------------------------------------------------------------------------
// Required headers

#include "nsglobal.h"

//---------------------------------------------------------------------------
// Function Structures

typedef struct {                                   
	USHORT Seconds;       // seconds 
	USHORT SecondsAlarm;  // seconds alarm
	USHORT Minutes;       // minutes
	USHORT MinutesAlarm;  // minutes alarm
	USHORT Hours;         // hours
	USHORT HoursAlarm;    // hours alarm
	USHORT DayOfWeek;     // day of week
	USHORT DateOfMonth;   // date of month
	USHORT Month;         // month
	USHORT Year;          // year
	USHORT PeriodicRate;  // periodic interrupt rate
    BYTE   ModeData;      // mode specifics
    BYTE   IntStatus;     // interrupt flags
	USHORT Command;       // command to perform
} RTC_SET;

//---------------------------------------------------------------------------
// Register Locations
//
// Registers in the Elentari RTC are accessed with an index.  The following
// are the register's for each index.

#define RTC_SECONDS           0x00
#define RTC_ALARM_SECONDS     0x01
#define RTC_MINUTES           0x02
#define RTC_ALARM_MINUTES     0x03
#define RTC_HOURS             0x04
#define RTC_ALARM_HOURS       0x05
#define RTC_DAYOFWEEK         0x06
#define RTC_DAYOFMONTH        0x07
#define RTC_MONTH             0x08
#define RTC_YEAR              0x09
#define RTC_CRA               0x0A
#define RTC_CRB               0x0B
#define RTC_CRC               0x0C
#define RTC_CRD               0x0D
#define RTC_ALARM_DAYOFMONTH  0x7F

//CMOS RAM Registers
#define RTC_CMOS_BASE         0x0E
#define RTC_CMOS_SIZE         50

//---------------------------------------------------------------------------
// Register Bit Definitions

// Control Register A Bits

#define CRA_RATE_NONE   (0)      // No interrupts needed

#define CRA_DIVIDERON   (2<<4)   // Turn On Divider On
#define CRA_DIVIDEROFF  (0)      // Turn off Divider (Conservse power)

#define CRA_UIP         (1<<7)   // Update in Progress

#define CRA_PERIOD_INTRATE      0x0F  //Periodic Interrupt Rate Mask
#define RTC_PERIODIC_RATE_NONE  0     //
#define RTC_PERIODIC_RATE_1     1     //   3.90625  ms
#define RTC_PERIODIC_RATE_2     2     //   7.8125   ms
#define RTC_PERIODIC_RATE_3     3     // 122.070    us
#define RTC_PERIODIC_RATE_4     4     // 244.141    us
#define RTC_PERIODIC_RATE_5     5     // 488.281    us
#define RTC_PERIODIC_RATE_6     6     // 976.562    us
#define RTC_PERIODIC_RATE_7     7     //   1.953125 ms
#define RTC_PERIODIC_RATE_8     8     //   3.90625  ms
#define RTC_PERIODIC_RATE_9     9     //   7.8125   ms
#define RTC_PERIODIC_RATE_10    10    //  15.625    ms
#define RTC_PERIODIC_RATE_11    11    //  31.25     ms
#define RTC_PERIODIC_RATE_12    12    //  62.5      ms
#define RTC_PERIODIC_RATE_13    13    // 125        ms
#define RTC_PERIODIC_RATE_14    14    // 250        ms
#define RTC_PERIODIC_RATE_15    15    // 500        ms

// Control Register B 

#define CRB_SET_DONE                  (0<<7)    // Normal Time keeping
#define CRB_SET_TIME                  (1<<7)

#define CRB_PERIODIC_ENABLE           (1<<6)   
#define CRB_ALARM_ENABLE              (1<<5)
#define CRB_UIE                       (1<<4)

#define CRB_DATA_BINARY               (1<<2)
#define CRB_DATA_BCD                  (0)
					      
#define CRB_TIME_24                   (1<<1)    // 24 hour Time
#define CRB_TIME_12                   (0)       // 12 hour time

#define CRB_DAYLIGHT_SAVING_ENABLE    (1)       // Day light Savings enable
#define CRB_DAYLIGHT_SAVING_DISABLE   (0)

#define CRB_DisableClock (1<<7)

// Control Register C  (Read only - status)

#define CRC_INTERRUPT_PENDING   (1<<7)          
#define CRC_PERIODIC_PENDING    (1<<6)
#define CRC_ALARM_PENDING       (1<<5)
#define CRC_UPDATE_PENDING      (1<<4)

// Control Register D

#define CRD_VALID_TIME          (1<<7)      // if set Time or Sram is valid

//---------------------------------------------------------------------------
// Register values

// Init value for CRA: normal timekeeping, no periodic interrupt
#define CRA_InitVal   ( CRA_RATE_NONE | CRA_DIVIDERON )

// Init value for CRB: written if VRT is invalid in Init code.
#define CRB_InitVal  ( CRB_DATA_BINARY \
		             | CRB_TIME_24 \
		             | CRB_DAYLIGHT_SAVING_ENABLE )

// Don't care value for RTC Alarm registers
#define ALARM_DONT_CARE  0xFF

//---------------------------------------------------------------------------
// Commands that can be used with RTC_Command

//RTC_Set Command definitions
#define GET_TIME_DATE           1
#define SET_TIME                2
#define SET_DATE                3
#define GET_ALARM               4
#define SET_ALARM               5
#define SET_PERIODIC_ALARM      6
#define DISABLE_ALARM           7
#define DISABLE_PERIODIC_ALARM  8
#define CLEAR_INTERRUPT         9
#define GET_PERIODIC_ALARM      10
#define SET_MODE                11

// These are used with the SET_MODE command
// They are defined the same as the register bits, but are aliased to
// provide a define to user code that is more "generic".
// Note that RTC_MODE_BINARY, RTC_MODE_24, and RTC_MODE_DAYLIGHT_SAVING_ENABLE
// are nonzero, so can be used in bitwise AND and OR operations.  The
// other three are defined as 0, so can be used in an OR operation, but
// not in a bitwise AND operation.

#define RTC_MODE_BINARY                     CRB_DATA_BINARY
#define RTC_MODE_BCD                        CRB_DATA_BCD
#define RTC_MODE_24                         CRB_TIME_24
#define RTC_MODE_12                         CRB_TIME_12
#define RTC_MODE_DAYLIGHT_SAVING_ENABLE     CRB_DAYLIGHT_SAVING_ENABLE
#define RTC_MODE_DAYLIGHT_SAVING_DISABLE    CRB_DAYLIGHT_SAVING_DISABLE

//---------------------------------------------------------------------------
// External Function Prototypes

extern USHORT RTC_Initialize(void);
extern USHORT RTC_Command(RTC_SET * pTimeInfo);
extern USHORT RTC_RAM_Read(USHORT offset, USHORT * pvalue);
extern USHORT RTC_RAM_Write(USHORT offset, USHORT value);

//---------------------------------------------------------------------------

#endif  // #ifndef RTC_H_INC

//---------------------------------------------------------------------------
// END       rtc.h
//---------------------------------------------------------------------------
