
#include	"mac.h"
#include	"mac.x"

/*
 *   Standard linear search for	pseudo op.
 */
pscan()
{
	register int i;
	register char *t;

	t = clabel;
	if (*t == 'd' && *(t+1)	== 'c' && *(t+2) != 's' && !*(t+3))  {

		/*
		 *   Special define constant (dc?)
		 */
		for (i=0; i<4; i++)
			if (*(t+2) == head.dctype[i].f_class)
				return(i);
		return(ERR);
		}

	/*
	 *   Scan remaining pseudo ops.
	 */
	for (i=4; plabel[i]; i++)  {
		if (compar(clabel, plabel[i]))
			return(i);
		}

	return(ERR);
}


/*
 *   Binary search of opcode table.
 */
oscan()
{
	register char *r;			/* pointer to opcodes */
	register int i;
	register int j;
	register int k;

	i = 0;
	j = head.h_ops - 1;
	while (i <= j)	{
		k = (i + j) >> 1;
		r = &opcode[0] + (k * head.h_o_len);
		switch (cmp(clabel, r))	 {

			case  1:
				i = k +	1;
				break;

			case  0:
				/*
				 *   found symbolic.
				 */
				return(k);

			case -1:
				j = k -	1;
				break;

			}
		}
	/*
	 *   Not found.
	 */
	return(ERR);
}

/*
 *	Define a symbol
 *	Symbol will be placed at the end of a linked list
 *	the base of which is indexed by the first character 
 *	of the symbol
 *
 */

defsym(name, member, value)
register char	*name;
register int	member;
register int	value;
{
	register struct	st *q;
	register int cmp;
	register struct st *prv;
	extern struct st *dslot();

	/*
	 *   Check for local symbol <$xxxxx>
	 *   If local, place it as a subtree under
	 *   the most recently defined permanent symbol
	 *
	 *   Generate an error if there are no permanent
	 *   symbols yet
	 */
	if(name[0] == '$'){
	  if(lastsym == ERR){
	    synerr("(defsym) No permanent symbol defined yet",name);
	    return(ERR);
	  }
	  q = &symtab[lastsym];
	  if(!q->s_loc){
	    /*
	     * no other local symbols, add the first one
	     */
	    q->s_loc = dslot(name);
	    q = q->s_loc;
	    q->s_loc = ERR;		/* mark entry as local */
	    goto exit;
	  }

	  /*
	   * Scan local symbol table under permanent symbol 'lastsym'
	   * Put new entry at the end if it isn't already defined
	   */
	  q = q->s_loc;			/* point to lsb under symbol */
	  while(q){
	    if(cmpsym(name, q->s_name) == 0){
	      if(q->s_mode & DEFN){
	        synerr("mult def label ",&q->s_name);
	        return(ERR);
	      }
	      else
	        goto exit;		/* ref before defn */
	    }
	    prv = q;
	    q = q->s_next;
	  }
	  q   = dslot(name);
	  prv->s_next = q;
	  q->s_loc = ERR;		/* mark entry as local */
	  goto exit;
	}

	/*********************************************
	 *   Scan regular symbol table:              *
	 *	if label is present, return index,   *
	 *	if not - define	a slot in the table, *
	 *	mark the symbol	as referenced but    *
	 *	undefined, and return the index.     *
	 *********************************************/

	q = fchar[member];			/* point to the hash bucket */

	if (!q){
	  /*
	   * bucket is empty.. create the first entry
	   */
	  q = dslot(name);
	  fchar[member] = q;
	  goto exit;
	}
	  /*
	   * search the linked list for the symbol
	   * add to the list in front if new symbol < old symbol
	   * add to the end if nothing greater than new symbol
	   */

	prv = &fchar[member];
	while (q){				/* scan forward */
	  cmp = cmpsym(name, q->s_name);

	  if (cmp == 0){
	    if(q->s_mode & DEFN){
	      synerr("mult def label ",&q->s_name);
	      return(ERR);
	    }
	    else
	      goto exit;			/* ref before def */
	  }

	  if (cmp < 0){
	    if(prv == &fchar[member]){
	      /*
	       * insert between head ptr and old first elt
	       */
	      fchar[member] = dslot(name);	/* point head at new */
	      prv = fchar[member];		/* use prv to point to new */
	      prv->s_next = q;			/* link new with current */
	      q = prv;				/* make q the one we added */
	      goto exit;
	    }
	    /*
	     * insert between prv and q
	     */
	    prv->s_next = dslot(name);		/* link last one to new one */
	    prv = prv->s_next;			/* point to new one with prv */
	    prv->s_next = q;			/* link new with current */
	    q = prv;				/* make q the one we added */
	    goto exit;
	  }
	      
	  /*
	   * new symbol is greater than current symbol
	   * scan forward until end or new < current
	   */
	  if(q->s_next == 0){
	    /*
	     * at end of list
	     * insert new one at the end
	     */
	    q->s_next = dslot(name);		/* link in new one */
	    q = q->s_next;			/* make new one current */
	    goto exit;
	  }
	  else {
	    prv = q;				/* make current old one */
	    q = q->s_next;			/* make next one current */
	  }
	}

exit:
	q->s_mode |= DEFN;
	q->s_value = value;

#ifdef DEBUG
	if(*option('z')&2)
	  printf("def <%s> val = %d mode = %04x q = %o lastsym = %d\n",
		  name,q->s_value,q->s_mode,q,lastsym);
#endif

	return(q-symtab);			/* rtn offset to sym entry*/

}

/*
 * Look up a symbol
 * Mark it as referenced if it's there
 * Define it and mark it referenced if it wasn't
 */

lkpsym(name, member)
register char	*name;
register int	member;
{
	register struct	st *q;
	register struct st *prv;
	register int cmp;

	/*
	 *  Check for local symbol <$xxxx>
	 *  Check under 'lastsym' subtree for it
	 *  If there are no permanent symbols yet,
	 *  generate a syntax error
	 */
	if(name[0] == '$'){
	  if(lastsym == ERR){
	    synerr("(lkpsym) No permanent symbol defined yet",name);
	    return(ERR);
	  }
	  q = &symtab[lastsym];
	  /*
	   * if there are no local symbols, create the first one
	   */
	  if(q->s_loc == 0){
	    q->s_loc = dslot(name);
	    q = q->s_loc;
	    q->s_loc = ERR;		/* mark as local */
	    goto exit;
 	  }
	  /*
	   * if there were some already, traverse the list
	   * if you can't find this one, add it to the end
	   */
	  q = q->s_loc;
	  while(q){
	    if(cmpsym(name,q->s_name) == 0)
	      goto exit;
	    prv = q;
	    q = q->s_next;
	  }
	  /*
	   * name wasn't in the list, append it
	   */
	  q = dslot(name);
	  prv->s_next = q;
	  q->s_loc = ERR;	/* mark as local */
	  goto exit;
	}

	/*
	 * Scan regular symbol table
	 */
	q = fchar[member];			/* point to hash bucket */
	if (!q){				/* if nothing in the bucket */
	  q = dslot(name);			/* add & mark as referenced */
	  fchar[member] = q;			/* update bucket pointer */
	  goto exit;
	}

	prv = &fchar[member];
	while(q){
	  cmp = cmpsym(name, q->s_name);

	  if (cmp == 0)
	   goto exit;				/* symbol found */

	  if (cmp < 0){
	    if(prv == &fchar[member]){
	      /*
	       * insert between head ptr and old first elt
	       */
	      fchar[member] = dslot(name);	/* point head at new */
	      prv = fchar[member];		/* use prv to point to new */
	      prv->s_next = q;			/* link new with current */
	      q = prv;				/* make q the one we added */
	      goto exit;
	    }
	    /*
	     * insert between prv and q
	     */
	    prv->s_next = dslot(name);		/* link last one to new one */
	    prv = prv->s_next;			/* point to new one with prv */
	    prv->s_next = q;			/* link new with current */
	    q = prv;				/* make q the one we added */
	    goto exit;
	  }

	  /*
	   * new symbol is greater than current symbol
	   * scan forward unless ptr to next symbol is null
	   * if we're at the end of the list, put it there
	   */
	  if(q->s_next == 0){
	    /*
	     * at end of list
	     * insert new one at the end
	     */
	    q->s_next = dslot(name);		/* link in new one */
	    q = q->s_next;			/* make new one current */
	    goto exit;
	  }
	  else {
	    prv = q;				/* make current old one */
	    q = q->s_next;			/* make next one current */
	  }
	}

exit:
	q -> s_mode |= REFR;

#ifdef DEBUG
	if(*option('z')&2)
	  printf("lkp <%s> mode = %04x q = %o lastsym = %d\n",
		  name,q->s_mode,q,lastsym);
#endif

	return(q-symtab);			/* rtn offset in sym tbl */
	
}

/*
 *   cmpsym:	Same as compare except successful
 *		match also occurs if a ':' appears in
 *		the first
 */
cmpsym(r, s)
register char *r;
register char *s;
{
	register int i;
	i = 1;
	while (*r == *s)  {
	  if ((*r == '\0')&&(*s =='\0'))
	    return(0);
	  r++;
	  s++;
	  if(i == SNAMLEN)
	    return(0);		/* SNAMLEN chrs match */
	  else
	    i++;
	}
	if((*s == '\0')&&(*r == ':'))
	  return(0);
	else
	  return(*r-*s);
}

/*
 *	Allocate some more symbol space
 */
char *
cpget()
{
	register char *core;
	register char *cp;	

	if ((core = sbrk( 32*ST )) == 0)	{
	  synerr("symbol table overflow","");
	  exit(1);
	}

	if( core != endcore){
	  fprintf(stderr,"?symbol area.  core = %06o endcore = %06o\n",
	           core, endcore);
	  exit(1);
	}

	endcore	+= (32 * ST);		/* set new top of core */

#ifdef DEBUG
	if(*option('Z')){
	 printf("cpget: coreptr = %o endcore = %o core = %o\n",
		 coreptr,endcore,core);
	}
#endif

	return(1);				/* non-zero on success */
}

/*
 *   Define a symbol table entry.
 *
 *   Get next available	slot and return	a pointer to it.
 */
struct st *
dslot(name)
char	*name;
{
	register struct	st *q;
	register char	*s;
	register int	idx;

	q = coreptr;			/* point to next free spot in mem */

	if (q  >= endcore)		/* symbol won't fit, alloc more  */ 
	  cpget();

	s = name;
	q->s_mode = 0;

	for(idx = 0; idx < SNAMLEN; idx++) {

	  if(*s == ':'){
	    if(*++s == ':')	     	     /* eat colons, check for "::"   */
	      q->s_mode = EXPO | gblidx++;   /* "sym::" same as "export sym" */
	    while(idx++ < SNAMLEN)	     /* colons are end of symbol     */
	      q->s_name[idx] = '\0';
	    break;
	  }

	  if(*s > ' ')			/* symbol chrs must be printable */
	    q->s_name[idx] = *s++;
	  else {
	    while(idx++ < SNAMLEN)	/* if ctl or spc, rest is null */
	      q->s_name[idx] = '\0';
	      break;
	  }
	}

	q->s_next  = NUL;

#ifdef DEBUG
	if(*option('z')=='2')
	 printf("dslot: adr %o name=%s value = 0x%08x mode=0x%04x\n",
	         q,q->s_name,q->s_value,q->s_mode);
#endif

	nsyms++;			/* bump symbol count */
	coreptr	+= ST;			/* point to next slot in tbl */
	return(q);
}
