/*
 * SCCS info --- @(#)psconfig.c	1.17   12/2/94
 */
/*
 * Copyright (c) 1994 by Castelle
 * The use of this software is restricted to Castelle customers.
 *
 *
 * THIS SOFTWARE IS PROVIDED BY THE CASTELLE ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE CASTELLE BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 *	psconfig.c	-	Print Server Configuration Program over IP/TCP
 *
 */

#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <string.h>
#include <ctype.h>
#include <netdb.h>
#include <stdio.h>

#include <psipcfg.h>
#include <ps_text.h>

#define FALSE 0
#define TRUE 1

#define ENABLE_NOVELL	1
#define ENABLE_UNIX		2

struct	psipcfg		config;		/* configuration block */

#define NbytePerParm	138
#define	Nparm		20
char  parm[Nparm][NbytePerParm];
u_short pa1flag, se1flag;
u_short pa2flag, se2flag, vaflag, reset_flag, show_flag;
u_short pa1_norp_flag, se1_norp_flag, spa1_flag;
u_short pa2_norp_flag, se2_norp_flag;
u_short nopflag, nop_1_flag, vnflag, clbuf_flag, init_flag;
u_short	get_mc_flag, set_mc_flag, get_mq_flag, set_func_flag;
u_short	ipa_flag, route_flag, mask_flag, parity1_flag, parity2_flag;
u_short	baud1_flag, dbits1_flag, sbits1_flag, fcntl1_flag;
u_short	baud2_flag, dbits2_flag, sbits2_flag, fcntl2_flag;

/*
 *
 *	Common procedure for sending and receiving
 *
 */

int send_receive(sock, op, param1, param2)
int		sock;
u_char	op;
unsigned long param1;
unsigned long param2;
{
	unsigned long		*dwptr, actual;
	unsigned short		*wptr;
    struct tcpipcfg *tcpip_cfg;

	config.cfgop = op;
    config.status = 1;
	config.cfglen = htons(sizeof(struct tcpipcfg));
	dwptr = (unsigned long *) config.cfgbuf;
	if (op == PSIPCFG_SUBNETMASK) {
		tcpip_cfg = (struct tcpipcfg *) dwptr;
		tcpip_cfg->subnetmask = (unsigned long) param1;
	}
	else
	if (op == PSIPCFG_GATEWAY) {
		tcpip_cfg = (struct tcpipcfg *) dwptr;
		tcpip_cfg->gate0 = (unsigned long) param1;
	}
	else
	if (op == PSIPCFG_ADDRESS) {
		tcpip_cfg = (struct tcpipcfg *) dwptr;
		tcpip_cfg->ifaddr = (unsigned long) param1;
	}
	else {
		*dwptr = (unsigned long) htonl(param1);
		dwptr = (unsigned long *) &config.cfgbuf[4];
		*dwptr = (unsigned long) htonl(param2);
	}

	/* Send diagnostic query via connected socket */
	if (write(sock, &config, sizeof(config)) < 0) {
       	printf(TEXT_INSTALL_17);
		return(5);
	}

	/* read diagnostic data from the socket */
	if ((actual = read(sock, &config, sizeof(config))) < 0) {
       	printf(TEXT_INSTALL_18);
		return(6);
	}
	else
		return(0);
}

/*
 *
 *	TCP client to configure a Castelle print server
 *
 */

main(argc, argv)
int argc;
char *argv[];
{
   int    i, index, bt_chk=1, delay_cnt=1;
   int    sts = 0;
   int    j, k, m, n;
   u_long port_num;
   u_long pa1_language_value, se1_language_value;
   u_long pa2_language_value, se2_language_value;
   u_long pa1_report_value, se1_report_value;
   u_long pa2_report_value, se2_report_value, spa1_value;
   u_long length;
   u_long copy_from, set_to, more, actual, *dwptr;
   u_long set_value, func_value;
   int    sock, exit_code;
   struct sockaddr_in server;
   struct hostent     *hp, *gethostbyname();
   u_long ip_address, gate_address;
   u_long mask_value, parity1_value, parity2_value;
   u_long baud1_value, dbits1_value, sbits1_value, fcntl1_value;
   u_long baud2_value, dbits2_value, sbits2_value, fcntl2_value;
   char   h[16], ps_sn[9];
   Sconfig_data fs_cfg;
   struct tcpipcfg tcpip_cfg;
   char netid_cfg[16];
   struct in_addr ipaddr;
   
   printf("       %s%s\n%s\n", TEXT_UXCONFIG_VNAME, TEXT_UXCONFIG_VNUM, TEXT_COPY_RIGHT);
   memset(&config, 0, sizeof(config));
   if (argc < 3) {
     if (argc == 2)
       showSyntax(argv[1]);
     else
       showSyntax(config.serno);
     exit(1);
   }

   nop_1_flag = nopflag = show_flag = FALSE;
   vaflag = clbuf_flag = init_flag = FALSE;
   pa1flag = pa2flag = se1flag = se2flag = reset_flag = FALSE;
   pa1_norp_flag = pa2_norp_flag = spa1_flag = FALSE;
   se1_norp_flag = se2_norp_flag = FALSE;
   parity2_flag = FALSE;
   set_func_flag = get_mc_flag = set_mc_flag = get_mq_flag = FALSE;
   ipa_flag = route_flag = mask_flag = parity1_flag = FALSE;
   baud1_flag = dbits1_flag = sbits1_flag = fcntl1_flag = FALSE;
   baud2_flag = dbits2_flag = sbits2_flag = fcntl2_flag = FALSE;
   for (i = 1; i < argc; i++) {
     strcpy(parm[i], argv[i]);
     j = strlen(argv[i]);
     for (k = 0; k < j; k++) {
       if ((parm[i][k] > 96) && (parm[i][k] < 123))
          parm[i][k] -= 32;
     }
   }

   /* create socket */
   sock = socket(AF_INET, SOCK_STREAM, 0);
   if (sock < 0) {
     printf(TEXT_INSTALL_10);
     exit(2);
   }

   /* connect socket using name specified */
   server.sin_family = AF_INET;

   hp = gethostbyname(argv[1]);
   if (hp == 0) {
     printf(TEXT_INSTALL_11, argv[1]);
     exit(3);
   }   
   memcpy((char *)&server.sin_addr, (char *) hp->h_addr, hp->h_length);
   server.sin_port = htons(PSIPCFG_PORT);
   printf(TEXT_INSTALL_12, htons(server.sin_port), inet_ntoa(server.sin_addr));
   if (connect(sock, (struct sockaddr *) &server, sizeof(server)) < 0) {
     printf(TEXT_INSTALL_13);
     printf(TEXT_INSTALL_30);
     printf(TEXT_INSTALL_31, argv[1]);
     printf(TEXT_INSTALL_32, argv[1]);
     printf(TEXT_INSTALL_33, argv[1]);
     printf(TEXT_INSTALL_34);
     exit(4);
   }
   else
     printf(TEXT_INSTALL_14);

   sts = send_receive(sock, PSIPCFG_FINDSN, 0, 0);
   memcpy(ps_sn, config.serno, 8);
   ps_sn[8] = 0;
   if ((sts == 0) && (config.status == 0)) {
     printf(TEXT_INSTALL_203, argv[1]);
     printf(TEXT_INSTALL_207, ps_sn);
   }
   else {
     printf(TEXT_INSTALL_90);
     exit_code = 73;
     goto done;
   }
   index = 2;
   while (index < argc) {
     if ((strncmp(parm[index], "IPA=", 4) != 0) &&
         (strncmp(parm[index], "ROUTE=", 6) != 0) &&
         (strncmp(parm[index], "MASK=", 5) != 0) &&
         (strncmp(parm[index], "BAUD1=", 6) != 0) &&
         (strncmp(parm[index], "BAUD2=", 6) != 0) &&
         (strncmp(parm[index], "CLBUF", 5) != 0) &&
         (strncmp(parm[index], "INIT", 4) != 0) &&
         (strncmp(parm[index], "VA", 2) != 0) &&
/*----------
         (strncmp(parm[index], "DBITS1=", 7) != 0) &&
         (strncmp(parm[index], "SBITS1=", 7) != 0) &&
         (strncmp(parm[index], "FCNTL1=", 7) != 0) &&
         (strncmp(parm[index], "PARITY1=", 8) != 0) &&
         (strncmp(parm[index], "DBITS2=", 7) != 0) &&
         (strncmp(parm[index], "SBITS2=", 7) != 0) &&
         (strncmp(parm[index], "FCNTL2=", 7) != 0) &&
         (strncmp(parm[index], "PARITY2=", 8) != 0) &&
-----------*/
         (strncmp(parm[index], "NOS=", 4) != 0) &&
         (strncmp(parm[index], "NOP=", 4) != 0) &&
         (strncmp(parm[index], "GETMC=", 6) != 0) &&
         (strncmp(parm[index], "SETMC=", 6) != 0) &&
         (strncmp(parm[index], "GETMQ=", 6) != 0) &&
         (strncmp(parm[index], "RESET", 5) != 0) &&
         (strncmp(parm[index], "PA1=", 4) != 0) &&
         (strncmp(parm[index], "PA2=", 4) != 0) &&
         (strncmp(parm[index], "SE1=", 4) != 0) &&
         (strncmp(parm[index], "SE2=", 4) != 0) &&
         (strncmp(parm[index], "SPA=", 4) != 0) &&
         (strncmp(parm[index], "SHOW", 4) != 0)) {
        printf(TEXT_INSTALL_70, parm[index]);
        showSyntax(config.serno);
        exit(1);
     }

     if (strncmp(parm[index], "IPA", 3) == 0) { /* Ip address */
       ipa_flag = TRUE;
       sts = check_ip_string(&parm[index][4]);
       if (sts != 0) {
          printf(TEXT_INSTALL_20, &parm[index][4]);
          printf(TEXT_INSTALL_21);
          exit(5);
       }
       ip_address = inet_addr(&parm[index][4]);
  	 }
   	 else
 	 if (strncmp(parm[index], "ROUTE", 5) == 0) { /* route address */
       route_flag = TRUE;
       sts = check_ip_string(&parm[index][6]);
       if (sts != 0) {
         printf(TEXT_INSTALL_22, &parm[index][6]);
         printf(TEXT_INSTALL_23);
         exit(5);
       }
       gate_address = inet_addr(&parm[index][6]);
     }
     else
     if (strncmp(parm[index], "MASK", 4) == 0) { /* network mask */
       mask_flag = TRUE;
       sts = check_ip_string(&parm[index][5]);
       if (sts != 0) {
         printf(TEXT_INSTALL_24, &parm[index][5]);
         printf(TEXT_INSTALL_25);
         exit(5);
       }
       mask_value = inet_addr(&parm[index][5]);
     }
     else
     if (strncmp(parm[index], "INIT", 4) == 0) { /* Initiate printer*/
       if (!((ps_sn[1] == '6') && (ps_sn[2] == '8'))) {
      	  printf(TEXT_INSTALL_71);
          showSyntax(config.serno);
          exit(5);
       }
       init_flag = TRUE;
     }
     else
     if (strncmp(parm[index], "CLBUF", 5) == 0) { /* Clear Buffer */
       if (!((ps_sn[1] == '6') && (ps_sn[2] == '8'))) {
      	  printf(TEXT_INSTALL_71);
          showSyntax(config.serno);
          exit(5);
       }
       clbuf_flag = TRUE;
     }
     else
     if (strncmp(parm[index], "BAUD1", 5) == 0) { /* set baud rate */
       if (((ps_sn[1] == '6') && (ps_sn[2] == '0')) ||
           ((ps_sn[1] == '6') && (ps_sn[2] == '1')) ||
           ((ps_sn[1] == '3') && (ps_sn[2] == '7')) ||
           ((ps_sn[1] == '3') && (ps_sn[2] == '8')) ||
           ((ps_sn[1] == '3') && (ps_sn[2] == '9')) ||
           ((ps_sn[1] == '6') && (ps_sn[2] == '7')) ||
           ((ps_sn[1] == '6') && (ps_sn[2] == '8')) ||
           ((ps_sn[1] == '6') && (ps_sn[2] == '9')) ||
           ((ps_sn[1] == '6') && (ps_sn[2] == '3')) ||
           ((ps_sn[1] == '6') && (ps_sn[2] == '4'))) {
      	  printf(TEXT_INSTALL_152, argv[1]);
          showSyntax(config.serno);
          exit(5);
       }
       baud1_flag = TRUE;
       sts = check_baud_string(&parm[index][6]);
       if (sts != 0) {
         printf(TEXT_INSTALL_40, TEXT_INSTALL_222, &parm[index][6]);
         printf(TEXT_INSTALL_41);
         exit(5);
       }
       baud1_value = 0xffff & atol(&parm[index][6]);
     }
     else
     if (strncmp(parm[index], "BAUD2", 5) == 0) { /* set baud rate */
       if (((ps_sn[1] == '3') && (ps_sn[2] == '3')) ||
           ((ps_sn[1] == '3') && (ps_sn[2] == '4')) ||
           ((ps_sn[1] == '3') && (ps_sn[2] == '7')) ||
           ((ps_sn[1] == '3') && (ps_sn[2] == '8')) ||
           ((ps_sn[1] == '3') && (ps_sn[2] == '9')) ||
           ((ps_sn[1] == '6'))) {
      	  printf(TEXT_INSTALL_153, argv[1]);
          showSyntax(config.serno);
          exit(5);
       }
       baud2_flag = TRUE;
       sts = check_baud_string(&parm[index][6]);
       if (sts != 0) {
         printf(TEXT_INSTALL_40, TEXT_INSTALL_223, &parm[index][6]);
         printf(TEXT_INSTALL_41);
         exit(5);
       }
       baud2_value = 0xffff & atol(&parm[index][6]);
     }
     else
     if (strncmp(parm[index], "DBITS1", 6) == 0) { /* set data bits */
       dbits1_flag = TRUE;
       sts = check_dbits_string(&parm[index][7]);
       if (sts != 0) {
         printf(TEXT_INSTALL_42, TEXT_INSTALL_222, &parm[index][7]);
         printf(TEXT_INSTALL_43);
         exit(5);
       }
       dbits1_value = 0xff & atol(&parm[index][7]);
     }
     else
     if (strncmp(parm[index], "DBITS2", 6) == 0) { /* set data bits */
       dbits2_flag = TRUE;
       sts = check_dbits_string(&parm[index][7]);
       if (sts != 0) {
         printf(TEXT_INSTALL_42, TEXT_INSTALL_223, &parm[index][7]);
         printf(TEXT_INSTALL_43);
         exit(5);
       }
       dbits2_value = 0xff & atol(&parm[index][7]);
     }
     else
     if (strncmp(parm[index], "SBITS1", 6) == 0) { /* set stop bits */
       sbits1_flag = TRUE;
       sts = check_sbits_string(&parm[index][7]);
       if (sts != 0) {
         printf(TEXT_INSTALL_44, TEXT_INSTALL_222, &parm[index][7]);
         printf(TEXT_INSTALL_45);
         exit(5);
       }
       sbits1_value = 0xff & atol(&parm[index][7]);
     }
     else
     if (strncmp(parm[index], "SBITS2", 6) == 0) { /* set stop bits */
       sbits2_flag = TRUE;
       sts = check_sbits_string(&parm[index][7]);
       if (sts != 0) {
         printf(TEXT_INSTALL_44, TEXT_INSTALL_223, &parm[index][7]);
         printf(TEXT_INSTALL_45);
         exit(5);
       }
       sbits2_value = 0xff & atol(&parm[index][7]);
     }
     else
     if (strncmp(parm[index], "FCNTL1", 6) == 0) { /* set flow control */
       fcntl1_flag = TRUE;
       sts = check_fcntl_string(&parm[index][7]);
       if (sts != 0) {
         printf(TEXT_INSTALL_46, TEXT_INSTALL_222, &parm[index][7]);
         printf(TEXT_INSTALL_47);
         exit(5);
       }
       if (parm[index][9] == 'F')
         fcntl1_value = 2; /* for XOFF */
       else
         fcntl1_value = 1; /* for XON */
     }
     else
     if (strncmp(parm[index], "FCNTL2", 6) == 0) { /* set flow control */
       fcntl2_flag = TRUE;
       sts = check_fcntl_string(&parm[index][7]);
       if (sts != 0) {
         printf(TEXT_INSTALL_46, TEXT_INSTALL_223, &parm[index][7]);
         printf(TEXT_INSTALL_47);
         exit(5);
       }
       if (parm[index][9] == 'F')
         fcntl2_value = 2; /* for XOFF */
       else
         fcntl2_value = 1; /* for XON */
     }
     else
     if (strncmp(parm[index], "PARITY1", 7) == 0) { /* set parity */
       parity1_flag = TRUE;
       sts = check_parity_string(&parm[index][8]);
       if (sts != 0) {
         printf(TEXT_INSTALL_48, TEXT_INSTALL_222, &parm[index][8]);
         printf(TEXT_INSTALL_49);
         exit(5);
       }
       if (parm[index][8] == 'E')
         parity1_value = 2; /* for EVEN */
       else
       if (parm[index][8] == 'O')
         parity1_value = 1; /* for ODD */
       else
         parity1_value = 0; /* for NO PARITY */
     }
     else
     if (strncmp(parm[index], "PARITY2", 7) == 0) { /* set parity */
       parity2_flag = TRUE;
       sts = check_parity_string(&parm[index][8]);
       if (sts != 0) {
         printf(TEXT_INSTALL_48, TEXT_INSTALL_223, &parm[index][8]);
         printf(TEXT_INSTALL_49);
         exit(5);
       }
       if (parm[index][8] == 'E')
         parity2_value = 2; /* for EVEN */
       else
       if (parm[index][8] == 'O')
         parity2_value = 1; /* for ODD */
       else
         parity2_value = 0; /* for NO PARITY */
     }
     else
     if (strncmp(parm[index], "VA", 2) == 0) { /* factory default */
       vaflag = TRUE;
     }
     else
     if (strncmp(parm[index], "NOP", 3) == 0) {
       nopflag = TRUE;
     }
     else
     if (strncmp(parm[index], "PA1", 3) == 0) { /* port format */
       if ((strncmp(&parm[index][4], "PCL", 3) != 0) && 
           (strncmp(&parm[index][4], "PostScript", 10) != 0) &&
           (strncmp(&parm[index][4], "PS", 2) != 0)) {
          if ((strncmp(&parm[index][4], "NORP", 4) != 0) &&
              (strncmp(&parm[index][4], "RP", 2) != 0)) {
             printf(TEXT_INSTALL_61);
             exit(11);
          }
          if (parm[index][4] == 'R')
             pa1_report_value = 0x80;  /* print report */
          else
             pa1_report_value = 0x40;  /* do not print report */
          pa1_norp_flag = TRUE;
          goto pa1_end;
       }

       if (parm[index][5] == 'C')
          pa1_language_value = 0; /* for PCL language */
       else
          pa1_language_value = 1; /* for PostScript language */
       pa1flag = TRUE;
pa1_end:  ;
     }
     else
     if (strncmp(parm[index], "PA2", 3) == 0) { /* port format */
       if (((ps_sn[1] == '3') && (ps_sn[2] == '0')) ||
           ((ps_sn[1] == '3') && (ps_sn[2] == '1')) ||
           ((ps_sn[1] == '3') && (ps_sn[2] == '3')) ||
           ((ps_sn[1] == '3') && (ps_sn[2] == '4')) ||
           ((ps_sn[1] == '3') && (ps_sn[2] == '7')) ||
           ((ps_sn[1] == '3') && (ps_sn[2] == '9')) ||
           ((ps_sn[1] == '6') && (ps_sn[2] == '0')) ||
           ((ps_sn[1] == '6') && (ps_sn[2] == '1')) ||
           ((ps_sn[1] == '6') && (ps_sn[2] == '7')) ||
           ((ps_sn[1] == '6') && (ps_sn[2] == '8')) ||
           ((ps_sn[1] == '6') && (ps_sn[2] == '9')) ||
           ((ps_sn[1] == '6') && (ps_sn[2] == '3')) ||
           ((ps_sn[1] == '6') && (ps_sn[2] == '4'))) {
      	  printf(TEXT_INSTALL_151, argv[1]);
          showSyntax(config.serno);
          exit(11);
       }
       if ((strncmp(&parm[index][4], "PCL", 3) != 0) && 
           (strncmp(&parm[index][4], "PostScript", 10) != 0) &&
           (strncmp(&parm[index][4], "PS", 2) != 0)) {
          if ((strncmp(&parm[index][4], "NORP", 4) != 0) &&
              (strncmp(&parm[index][4], "RP", 2) != 0)) {
             printf(TEXT_INSTALL_62);
             exit(11);
          }
          if (parm[index][4] == 'R')
             pa2_report_value = 0x80;  /* print report */
          else
             pa2_report_value = 0x40;  /* do not print report */
          pa2_norp_flag = TRUE;
          goto pa2_end;
       }

       if (parm[index][5] == 'C')
          pa2_language_value = 0; /* for PCL language */
       else
          pa2_language_value = 1; /* for PostScript language */
       pa2flag = TRUE;
pa2_end:  ;
     }
     else
     if (strncmp(parm[index], "SE1", 3) == 0) { /* port format */
       if (((ps_sn[1] == '6') && (ps_sn[2] == '0')) ||
           ((ps_sn[1] == '6') && (ps_sn[2] == '1')) ||
           ((ps_sn[1] == '3') && (ps_sn[2] == '7')) ||
           ((ps_sn[1] == '3') && (ps_sn[2] == '8')) ||
           ((ps_sn[1] == '3') && (ps_sn[2] == '9')) ||
           ((ps_sn[1] == '6') && (ps_sn[2] == '7')) ||
           ((ps_sn[1] == '6') && (ps_sn[2] == '8')) ||
           ((ps_sn[1] == '6') && (ps_sn[2] == '9')) ||
           ((ps_sn[1] == '6') && (ps_sn[2] == '3')) ||
           ((ps_sn[1] == '6') && (ps_sn[2] == '4'))) {
      	  printf(TEXT_INSTALL_152, argv[1]);
          showSyntax(config.serno);
          exit(11);
       }
       if ((strncmp(&parm[index][4], "PCL", 3) != 0) && 
           (strncmp(&parm[index][4], "PostScript", 10) != 0) &&
           (strncmp(&parm[index][4], "PS", 2) != 0)) {
          if ((strncmp(&parm[index][4], "NORP", 4) != 0) &&
              (strncmp(&parm[index][4], "RP", 2) != 0)) {
             printf(TEXT_INSTALL_65);
             exit(11);
          }
          if (parm[index][4] == 'R')
             se1_report_value = 0x80;  /* print report */
          else
             se1_report_value = 0x40;  /* do not print report */
          se1_norp_flag = TRUE;
          goto se1_end;
       }

       if (parm[index][5] == 'C')
          se1_language_value = 0; /* for PCL language */
       else
          se1_language_value = 1; /* for PostScript language */
       se1flag = TRUE;
se1_end:  ;
     }
     else
     if (strncmp(parm[index], "SE2", 3) == 0) { /* port format */
       if (((ps_sn[1] == '3') && (ps_sn[2] == '3')) ||
           ((ps_sn[1] == '3') && (ps_sn[2] == '4')) ||
           ((ps_sn[1] == '3') && (ps_sn[2] == '7')) ||
           ((ps_sn[1] == '3') && (ps_sn[2] == '8')) ||
           ((ps_sn[1] == '3') && (ps_sn[2] == '9')) ||
           ((ps_sn[1] == '6'))) {
      	  printf(TEXT_INSTALL_153, argv[1]);
          showSyntax(config.serno);
          exit(11);
       }
       if ((strncmp(&parm[index][4], "PCL", 3) != 0) && 
           (strncmp(&parm[index][4], "PostScript", 10) != 0) &&
           (strncmp(&parm[index][4], "PS", 2) != 0)) {
          if ((strncmp(&parm[index][4], "NORP", 4) != 0) &&
              (strncmp(&parm[index][4], "RP", 2) != 0)) {
             printf(TEXT_INSTALL_66);
             exit(11);
          }
          if (parm[index][4] == 'R')
             se2_report_value = 0x80;  /* print report */
          else
             se2_report_value = 0x40;  /* do not print report */
          se2_norp_flag = TRUE;
          goto se2_end;
       }
 
       if (parm[index][5] == 'C')
          se2_language_value = 0; /* for PCL language */
       else
          se2_language_value = 1; /* for PostScript language */
       se2flag = TRUE;
se2_end:  ;
     }
     else
     if (strncmp(parm[index], "SPA=", 4) == 0) { /* port speed */
         if (((ps_sn[1] == '3') && (ps_sn[2] != '9') &&
              (ps_sn[2] != '3') && (ps_sn[2] != '4') &&
              (ps_sn[2] != '5') && (ps_sn[2] != '6') &&
              (ps_sn[2] != '7') && (ps_sn[2] != '8')) ||
             ((ps_sn[1] != '3') && (ps_sn[1] != '6')) ||
             ((ps_sn[1] == '6') && (ps_sn[2] != '8') &&
              (ps_sn[2] != '7') && (ps_sn[2] != '9') &&
              (ps_sn[2] != '2') && (ps_sn[2] != '5'))) {
      	    printf(TEXT_INSTALL_154, argv[1]);
            showSyntax(config.serno);
            exit(12);
         }
        spa1_flag = TRUE;
        if ((strncmp(&parm[index][4], "S1", 2) != 0) && 
            (strncmp(&parm[index][4], "S2", 2) != 0) &&
            (strncmp(&parm[index][4], "S3", 2) != 0) &&
            (strncmp(&parm[index][4], "S4", 2) != 0) &&
            (strncmp(&parm[index][4], "S5", 2) != 0)) {
           printf(TEXT_INSTALL_67);
           exit(12);
        }
        if (parm[index][5] == '1')
           spa1_value = 0x01;  /* PA1 port speed set to lowest */
        else
        if (parm[index][5] == '2')
           spa1_value = 0x02;  /* PA1 port speed set to lower */
        else
        if (parm[index][5] == '4')
           spa1_value = 0x03;  /* PA1 port speed set to fast */
        else
        if (parm[index][5] == '5')
           spa1_value = 0x04;  /* PA1 port speed set to fastet */
        else
           spa1_value = 0x00;  /* PA1 port speed set to normal */
     }
     else
     if (strncmp(parm[index], "GETMC", 5) == 0) { /* get memory contents */
        get_mc_flag = TRUE;
        copy_from = 0;
        for (i=6; parm[index][i] != 0; i++) {
          length = parm[index][i];
          if ((length >= 'A') && (length <= 'F'))
            length -= ('A' - 10);
          if ((length >= '0') && (length <= '9'))
            length -= '0';
          printf("parm[index][%d] = %x\n", i, length); 
          copy_from = (copy_from * 16) + length;
        }
        if (copy_from % 2)
          copy_from--;
        printf("copy_from = %lx\n", copy_from);
     }
     else
     if (strncmp(parm[index], "NOS=", 4) == 0) { /* function enable */
       if ((config.serno[1] == '6') && (config.serno[2] == '8')) { /* Fujitsu 1p only */
        printf(TEXT_INSTALL_70, parm[index]);
        showSyntax(config.serno);
        exit(1);
       }
       if ((parm[index][4] != 'U') && 
/*---------  NOT allowed to set the func to Novell ONLY or NOT SET --
           (parm[index][4] != 'N') &&
           (parm[index][4] != '0') &&
----------*/
           (parm[index][4] != 'A')) {
          printf(TEXT_INSTALL_60);
          exit(13);
       }

       set_func_flag = TRUE;
       if (parm[index][4] == 'U')
          func_value = ENABLE_UNIX;
/*---------
       else
       if (parm[index][4] == 'N')
          func_value = ENABLE_NOVELL;
       else
       if (parm[index][4] == '0')
          func_value = 0;
----------*/
       else
          func_value = ENABLE_UNIX | ENABLE_NOVELL;
/*---------
       printf("func_value = %lx\n", func_value);
----------*/
     }
     else
     if (strncmp(parm[index], "SETMC", 5) == 0) { /* set memory contents */
       set_mc_flag = TRUE;
       set_to = 0;
       set_value = 0;
       for (i=6; parm[index][i] != '='; i++) {
         length = parm[index][i];
         if ((length >= 'A') && (length <= 'F'))
           length -= ('A' - 10);
         if ((length >= '0') && (length <= '9'))
           length -= '0';
         printf("parm[index][%d] = %x\n", i, length); 
         set_to = (set_to * 16) + length;
       }
       for (i++; parm[index][i] != 0; i++) {
         length = parm[index][i];
         if ((length >= 'A') && (length <= 'F'))
           length -= ('A' - 10);
         if ((length >= '0') && (length <= '9'))
           length -= '0';
         printf("parm[index][%d] = %x\n", i, length); 
         set_value = (set_value * 16) + length;
       }
       printf("set_to = %lx  set_value = %d\n", set_to, set_value);
     }
     else
     if (strncmp(parm[index], "GETMQ", 5) == 0) { /* query memory */
       get_mq_flag = TRUE;
     }
     else
     if (strncmp(parm[index], "RESET", 5) == 0) { /* reset */
       reset_flag = TRUE;
     }
     else
     if (strncmp(parm[index], "SHOW", 5) == 0) { /* show config */
       show_flag = TRUE;
     }
     else { 
       printf(TEXT_INSTALL_70, parm[index]);
       showSyntax(config.serno);
       exit(16);
     } /* end of if else */
     index++;
   } /* end of while */

   if (get_mc_flag == TRUE || set_mc_flag == TRUE 
        || get_mq_flag == TRUE || set_func_flag == TRUE) {
      if (get_mc_flag == TRUE) {
        sts = send_receive(sock, PSIPCFG_GETMEMORY, copy_from, 0);
        if ((sts == 0) && (config.status == 0))
          print_hex(config.cfgbuf, ntohs(config.cfglen), copy_from);
        else {
          printf("Print Server '%s' get memory contents failed.\n", argv[1]);
          exit_code = 70;
          goto done;
        }
      }
      if (set_mc_flag == TRUE) {
        sts = send_receive(sock, PSIPCFG_SETMEMORY, set_to, set_value);
        if ((sts == 0) && (config.status == 0))
          printf("Set memory %lx to %x\n", set_to, set_value);
        else {
          printf("Print Server '%s' set memory contents failed.\n", argv[1]);
          exit_code = 71;
          goto done;
        }
      }
      if (get_mq_flag == TRUE) {
        sts = send_receive(sock, PSIPCFG_MEMQUERY, 0, 0);
        if ((sts == 0) && (config.status == 0)) {
          dwptr = (unsigned long *) config.cfgbuf;
          printf("Memory: Free 0x%x, Chunk 0x%x, High 0x%x\n",
                 ntohl(*dwptr), ntohl(*(dwptr+1)), ntohl(*(dwptr+2)));

          more = ntohs(config.cfglen)/sizeof(unsigned long) - 3;
          if (more) {
            printf("\n%s\t-\t%s\n", "Task", "Memory");
            for (actual=0; actual < more; actual++)
              printf("%d\t-\t0x%x\n", actual, ntohl(*(dwptr+3+actual)));
          }
        }
        else {
          printf("Print Server '%s' get memory query failed.\n", argv[1]);
          exit_code = 72;
          goto done;
        }
      }
      if (set_func_flag == TRUE) {
        sts = send_receive(sock, PSIPCFG_SETFUNC, func_value, 0);
        if ((sts == 0) && (config.status == 0)) {
          if (func_value == ENABLE_UNIX)
            printf(TEXT_INSTALL_109);
          else
            printf(TEXT_INSTALL_110);
        }
        else {
          printf(TEXT_INSTALL_91);
          exit_code = 73;
          goto done;
        }
      }
   }
   if (pa1flag == TRUE) {
      port_num = 1;
      sts = send_receive(sock, PSIPCFG_SETPORTLAN, port_num, pa1_language_value);
      if ((sts == 0) && (config.status == 0)) {
        if (pa1_language_value == 0)
          printf(TEXT_INSTALL_101);
        else
          printf(TEXT_INSTALL_102);
      }
      else {
        printf(TEXT_INSTALL_92);
        exit_code = 74;
        goto done;
      }
      nop_1_flag = TRUE;
   }
   if (spa1_flag == TRUE) {
      port_num = 1;
      sts = send_receive(sock, PSIPCFG_PASPEED, port_num, spa1_value);
      if ((sts == 0) && (config.status == 0)) {
        if (spa1_value == 1) {
          printf(TEXT_INSTALL_111);
        }
        else
        if (spa1_value == 2) {
          printf(TEXT_INSTALL_113);
        }
        else
        if (spa1_value == 3) {
          printf(TEXT_INSTALL_115);
        }
        else
        if (spa1_value == 4) {
          printf(TEXT_INSTALL_117);
        }
        else {
          printf(TEXT_INSTALL_119);
        }
      }
      else {
        printf(TEXT_INSTALL_94);
        exit_code = 75;
        goto done;
      }
      nop_1_flag = TRUE;
   }
   if (se1flag == TRUE) {
      port_num = 3;
      sts = send_receive(sock, PSIPCFG_SETPORTLAN, port_num, se1_language_value);
      if ((sts == 0) && (config.status == 0)) {
        /* set the language for the serial port */
        if (se1_language_value == 0)
          printf(TEXT_INSTALL_105);
        else
          printf(TEXT_INSTALL_106);
      }
      else {
        printf(TEXT_INSTALL_92);
        exit_code = 76;
        goto done;
      }
      nop_1_flag = TRUE;
   }
   if (pa2flag == TRUE) {
      port_num = 2;
      sts = send_receive(sock, PSIPCFG_SETPORTLAN, port_num, pa2_language_value);
      if ((sts == 0) && (config.status == 0)) {
        /* set the language for the parallel port */
        if (pa2_language_value == 0) {
          printf(TEXT_INSTALL_103);
        }
        else {
          printf(TEXT_INSTALL_104);
        }
      }
      else {
        printf(TEXT_INSTALL_92);
        exit_code = 77;
        goto done;
      }
      nop_1_flag = TRUE;
   }
   if (se2flag == TRUE) {
      port_num = 4;
      sts = send_receive(sock, PSIPCFG_SETPORTLAN, port_num, se2_language_value);
      if ((sts == 0) && (config.status == 0)) {
        /* set the language for the serial port */
        if (se2_language_value == 0)
          printf(TEXT_INSTALL_107);
        else
          printf(TEXT_INSTALL_108);
      }
      else {
        printf(TEXT_INSTALL_92);
        exit_code = 78;
        goto done;
      }
      nop_1_flag = TRUE;
   }
   if (pa1_norp_flag == TRUE) {
      port_num = 1;
      sts = send_receive(sock, PSIPCFG_SETPORTRPT, port_num, pa1_report_value);
      if ((sts == 0) && (config.status == 0)) {
        /* set the report for the parallel port */
        if (pa1_report_value == PRINT_REPORT)
          printf(TEXT_INSTALL_121);
        else
          printf(TEXT_INSTALL_122);
      }
      else {
        printf(TEXT_INSTALL_93);
        exit_code = 80;
        goto done;
      }
      nop_1_flag = TRUE;
   }
   if (pa2_norp_flag == TRUE) {
      port_num = 2;
      sts = send_receive(sock, PSIPCFG_SETPORTRPT, port_num, pa2_report_value);
      if ((sts == 0) && (config.status == 0)) {
        /* set the report for the parallel port */
        if (pa2_report_value == PRINT_REPORT)
          printf(TEXT_INSTALL_123);
        else
          printf(TEXT_INSTALL_124);
      }
      else {
        printf(TEXT_INSTALL_93);
        exit_code = 81;
        goto done;
      }
      nop_1_flag = TRUE;
   }
   if (se1_norp_flag == TRUE) {
      port_num = 3;
      sts = send_receive(sock, PSIPCFG_SETPORTRPT, port_num, se1_report_value);
      if ((sts == 0) && (config.status == 0)) {
        /* set the report for the parallel port */
        if (se1_report_value == PRINT_REPORT)
          printf(TEXT_INSTALL_125);
        else
          printf(TEXT_INSTALL_126);
      }
      else {
        printf(TEXT_INSTALL_93);
        exit_code = 82;
        goto done;
      }
      nop_1_flag = TRUE;
   }
   if (se2_norp_flag == TRUE) {
      port_num = 4;
      sts = send_receive(sock, PSIPCFG_SETPORTRPT, port_num, se2_report_value);
      if ((sts == 0) && (config.status == 0)) {
        /* set the report for the parallel port */
        if (se2_report_value == PRINT_REPORT)
          printf(TEXT_INSTALL_127);
        else
          printf(TEXT_INSTALL_128);
      }
      else {
        printf(TEXT_INSTALL_93);
        exit_code = 83;
        goto done;
      }
      nop_1_flag = TRUE;
   }
   if (vaflag == TRUE) {
      func_value = ENABLE_UNIX | ENABLE_NOVELL;
      ip_address = gate_address = mask_value = 0;
      pa1_report_value = 0x80;
      pa1_language_value = pa2_language_value = 0;
      se1_language_value = se2_language_value = 0;
      pa2_report_value = se1_report_value = se2_report_value = 0x40;
      spa1_value = 0x0;
      baud1_value = baud2_value= (unsigned long) 9600; 
  
      printf("\nThis may take a few minutes, please wait...\n");
      sts = send_receive(sock, PSIPCFG_SETLPNAME, 1, 1); /*1,1 are only dummy*/
      sts = send_receive(sock, PSIPCFG_SETFSNAME, 1, 1);
      sts = send_receive(sock, PSIPCFG_SETPOLLING, 1, 1);
      sts = send_receive(sock, PSIPCFG_ADDRESS, ip_address, 0);
      sts = send_receive(sock, PSIPCFG_GATEWAY, gate_address, 0);
      sts = send_receive(sock, PSIPCFG_SUBNETMASK, mask_value, 0);
      sts = send_receive(sock, PSIPCFG_SETFUNC, func_value, 0);
      sts=send_receive(sock, PSIPCFG_SETPORTRPT, 1, pa1_report_value);
      send_receive(sock, PSIPCFG_SETPORTLAN, 1, pa1_language_value);
      send_receive(sock, PSIPCFG_PASPEED, 1, spa1_value);
      if ((strncmp(ps_sn,"038",3)==0) || (strncmp(ps_sn,"035",3)==0) ||
          (strncmp(ps_sn,"062",3)==0))  {
           send_receive(sock, PSIPCFG_SETPORTRPT, 2, pa2_report_value);
           send_receive(sock, PSIPCFG_SETPORTLAN, 2, pa2_language_value);
      }
	  if ((strncmp(ps_sn,"035",3)==0) || (strncmp(ps_sn,"062",3)==0) ||
		  (strncmp(ps_sn,"034",3)==0)) {
           send_receive(sock, PSIPCFG_SETPORTRPT, 3, se1_report_value);
           send_receive(sock, PSIPCFG_SETPORTLAN, 3, se1_language_value);
           send_receive(sock, PSIPCFG_BAUDRATE, 3, baud1_value);
      }
	  if (strncmp(ps_sn,"035",3)==0) {
          send_receive(sock, PSIPCFG_SETPORTRPT, 4, se2_report_value);
          send_receive(sock, PSIPCFG_SETPORTLAN, 4, se2_language_value);
          send_receive(sock, PSIPCFG_BAUDRATE, 4, baud2_value);
      }		 
    /*  sts = send_receive(sock, PSIPCFG_SETDEFAULT, 0, 0); */
      if ((sts == 0) && (config.status == 0)) {
        /* set the factory default for the print server */
        printf(TEXT_INSTALL_200);
        nop_1_flag = TRUE;
      }
      else {
        printf(TEXT_INSTALL_96);
        exit_code = 85;
        goto done;
      }
   }
   if (init_flag == TRUE) {
      sts = send_receive(sock, PSIPCFG_INIT, 0, 0);
      if ((sts == 0) && (config.status == 0)) {
        printf(TEXT_INSTALL_155, argv[1]);
      }
      else {
        printf(TEXT_INSTALL_156, argv[1]);
        exit_code = 86;
        goto done;
      }
   }
   if (clbuf_flag == TRUE) {
      sts = send_receive(sock, PSIPCFG_CLBUF, 0, 0);
      if ((sts == 0) && (config.status == 0)) {
        printf(TEXT_INSTALL_129, argv[1]);
      }
      else {
        printf(TEXT_INSTALL_130, argv[1]);
        exit_code = 86;
        goto done;
      }
   }
   if (ipa_flag == TRUE) {
      sts = send_receive(sock, PSIPCFG_ADDRESS, ip_address, 0);
      if ((sts == 0) && (config.status == 0)) {
        ipaddr.s_addr = ip_address;
     /*   printf(TEXT_INSTALL_131, argv[1], inet_ntoa(ipaddr)); */
        printf("\n\nNOTE:");
        printf("\nPlease RESET the print server, and then modify your hosts file");
        printf("\nto include the new IP address.\n");
      }
      else {
        printf(TEXT_INSTALL_132, argv[1]);
        exit_code = 86;
        goto done;
      }
      nop_1_flag = TRUE;
   }
   if (route_flag == TRUE) {
      sts = send_receive(sock, PSIPCFG_GATEWAY, gate_address, 0);
      if ((sts == 0) && (config.status == 0)) {
        ipaddr.s_addr = gate_address;
        printf(TEXT_INSTALL_133, argv[1], inet_ntoa(ipaddr));
      }
      else {
        printf(TEXT_INSTALL_134, argv[1]);
        exit_code = 87;
        goto done;
      }
      nop_1_flag = TRUE;
   }
   if (mask_flag == TRUE) {
      sts = send_receive(sock, PSIPCFG_SUBNETMASK, mask_value, 0);
      if ((sts == 0) && (config.status == 0)) {
        ipaddr.s_addr = mask_value;
        printf(TEXT_INSTALL_135, argv[1], inet_ntoa(ipaddr));
      }
      else {
        printf(TEXT_INSTALL_136, argv[1]);
        exit_code = 88;
        goto done;
      }
      nop_1_flag = TRUE;
   }
   if (parity1_flag == TRUE) {
      port_num = 1;
      sts = send_receive(sock, PSIPCFG_PARITY, port_num, parity1_value);
      if ((sts == 0) && (config.status == 0)) {
        if (parity1_value == 2)
          printf(TEXT_INSTALL_137, argv[1], TEXT_INSTALL_222);
        else
        if (parity1_value == 1)
          printf(TEXT_INSTALL_138, argv[1], TEXT_INSTALL_222);
        else
          printf(TEXT_INSTALL_139, argv[1], TEXT_INSTALL_222);
      }
      else {
        printf(TEXT_INSTALL_140, argv[1]);
        exit_code = 89;
        goto done;
      }
      nop_1_flag = TRUE;
   }
   if (parity2_flag == TRUE) {
      port_num = 2;
      sts = send_receive(sock, PSIPCFG_PARITY, port_num, parity2_value);
      if ((sts == 0) && (config.status == 0)) {
        if (parity2_value == 2)
          printf(TEXT_INSTALL_137, argv[1], TEXT_INSTALL_223);
        else
        if (parity2_value == 1)
          printf(TEXT_INSTALL_138, argv[1], TEXT_INSTALL_223);
        else
          printf(TEXT_INSTALL_139, argv[1], TEXT_INSTALL_223);
      }
      else {
        printf(TEXT_INSTALL_140, argv[1]);
        exit_code = 89;
        goto done;
      }
      nop_1_flag = TRUE;
   }
   if (baud1_flag == TRUE) {
      port_num = 1;
      sts = send_receive(sock, PSIPCFG_BAUDRATE, port_num, baud1_value);
      if ((sts == 0) && (config.status == 0)) {
        printf(TEXT_INSTALL_141, argv[1], TEXT_INSTALL_222, baud1_value);
      }
      else {
        printf(TEXT_INSTALL_142, argv[1]);
        exit_code = 90;
        goto done;
      }
      nop_1_flag = TRUE;
   }
   if (baud2_flag == TRUE) {
      port_num = 2;
      sts = send_receive(sock, PSIPCFG_BAUDRATE, port_num, baud2_value);
      if ((sts == 0) && (config.status == 0)) {
        printf(TEXT_INSTALL_141, argv[1], TEXT_INSTALL_223, baud2_value);
      }
      else {
        printf(TEXT_INSTALL_142, argv[1]);
        exit_code = 90;
        goto done;
      }
      nop_1_flag = TRUE;
   }
   if (dbits1_flag == TRUE) {
      port_num = 1;
      sts = send_receive(sock, PSIPCFG_DATABITS, port_num, dbits1_value);
      if ((sts == 0) && (config.status == 0)) {
        printf(TEXT_INSTALL_143, argv[1], TEXT_INSTALL_222, dbits1_value);
      }
      else {
        printf(TEXT_INSTALL_144, argv[1]);
        exit_code = 91;
        goto done;
      }
      nop_1_flag = TRUE;
   }
   if (dbits2_flag == TRUE) {
      port_num = 2;
      sts = send_receive(sock, PSIPCFG_DATABITS, port_num, dbits2_value);
      if ((sts == 0) && (config.status == 0)) {
        printf(TEXT_INSTALL_143, argv[1], TEXT_INSTALL_223, dbits2_value);
      }
      else {
        printf(TEXT_INSTALL_144, argv[1]);
        exit_code = 91;
        goto done;
      }
      nop_1_flag = TRUE;
   }
   if (sbits1_flag == TRUE) {
      port_num = 1;
      sts = send_receive(sock, PSIPCFG_STOPBITS, port_num, sbits1_value);
      if ((sts == 0) && (config.status == 0)) {
        printf(TEXT_INSTALL_145, argv[1], TEXT_INSTALL_222, sbits1_value);
      }
      else {
        printf(TEXT_INSTALL_146, argv[1]);
        exit_code = 92;
        goto done;
      }
      nop_1_flag = TRUE;
   }
   if (sbits2_flag == TRUE) {
      port_num = 2;
      sts = send_receive(sock, PSIPCFG_STOPBITS, port_num, sbits2_value);
      if ((sts == 0) && (config.status == 0)) {
        printf(TEXT_INSTALL_145, argv[1], TEXT_INSTALL_223, sbits2_value);
      }
      else {
        printf(TEXT_INSTALL_146, argv[1]);
        exit_code = 92;
        goto done;
      }
      nop_1_flag = TRUE;
   }
   if (fcntl1_flag == TRUE) {
      port_num = 1;
      sts = send_receive(sock, PSIPCFG_FLOWCNTL, port_num, fcntl1_value);
      if ((sts == 0) && (config.status == 0)) {
         if (fcntl1_value == 1)  /* for XON */
            printf(TEXT_INSTALL_147, argv[1], TEXT_INSTALL_222);
         else  /* for XOFF */
            printf(TEXT_INSTALL_148, argv[1], TEXT_INSTALL_222);
      }
      else {
        printf(TEXT_INSTALL_149, argv[1]);
        exit_code = 93;
        goto done;
      }
      nop_1_flag = TRUE;
   }
   if (fcntl2_flag == TRUE) {
      port_num = 2;
      sts = send_receive(sock, PSIPCFG_FLOWCNTL, port_num, fcntl2_value);
      if ((sts == 0) && (config.status == 0)) {
         if (fcntl1_value == 1)  /* for XON */
            printf(TEXT_INSTALL_147, argv[1], TEXT_INSTALL_223);
         else  /* for XOFF */
            printf(TEXT_INSTALL_148, argv[1], TEXT_INSTALL_223);
      }
      else {
        printf(TEXT_INSTALL_149, argv[1]);
        exit_code = 93;
        goto done;
      }
      nop_1_flag = TRUE;
   }
   if (show_flag == TRUE) {
      memset(&fs_cfg, 0, sizeof(Sconfig_data));
      memset(&tcpip_cfg, 0, sizeof(struct tcpipcfg));
      memset(netid_cfg, 0, 16);
      sts = send_receive(sock, PSIPCFG_SHOW, 0, 0);
      if ((sts == 0) && (config.status == 0)) {
        memcpy((char *)&fs_cfg, (char *)config.cfgbuf, 64);
        memcpy((char *)netid_cfg, (char *)&config.cfgbuf[64], 16);
        memcpy((char *)&tcpip_cfg, (char *)&config.cfgbuf[80], sizeof(struct tcpipcfg));
        printf(TEXT_INSTALL_207A);
        for (i=0; i < 6; i++) {
           h[0] = (netid_cfg[i] >> 4) & 0x0f;
           if (h[0] >= 0x0a)
             h[0] += 'a' - 0x0a;
           else
             h[0] += '0';
           h[1] = netid_cfg[i] & 0x0f;
           if (h[1] >= 0x0a)
             h[1] += 'a' - 0x0a;
           else
             h[1] += '0';
           h[2] = ' ';
           h[3] = 0;
           printf("%s", h);
        }
        printf("\n");
        if (fs_cfg.sdata[4] != 0)
          printf(TEXT_INSTALL_215);
        if (!(fs_cfg.sdata[10] & NO_PRINT_REPORT))
          printf(TEXT_INSTALL_208, TEXT_INSTALL_220);
        else
          printf(TEXT_INSTALL_209, TEXT_INSTALL_220);
        if (fs_cfg.sdata[10] & PRINT_PS)
          printf(TEXT_INSTALL_213, TEXT_INSTALL_220);
        else
          printf(TEXT_INSTALL_212, TEXT_INSTALL_220);
        if (((config.serno[1] == '3') && (config.serno[2] == '3')) ||
            ((config.serno[1] == '3') && (config.serno[2] == '4')) ||
            ((config.serno[1] == '3') && (config.serno[2] == '5')) ||
            ((config.serno[1] == '3') && (config.serno[2] == '6')) ||
            ((config.serno[1] == '6') && (config.serno[2] == '7')) ||
            ((config.serno[1] == '6') && (config.serno[2] == '8')) ||
            ((config.serno[1] == '6') && (config.serno[2] == '9')) ||
            ((config.serno[1] == '3') && (config.serno[2] == '7')) ||
            ((config.serno[1] == '3') && (config.serno[2] == '8')) ||
            ((config.serno[1] == '3') && (config.serno[2] == '9'))) {
           if (fs_cfg.sdata[5] == 0)
             printf(TEXT_INSTALL_214, TEXT_INSTALL_232);
           else
           if (fs_cfg.sdata[5] == 1)
             printf(TEXT_INSTALL_214, TEXT_INSTALL_230);
           else
           if (fs_cfg.sdata[5] == 2)
             printf(TEXT_INSTALL_214, TEXT_INSTALL_231);
           else
           if (fs_cfg.sdata[5] == 3)
             printf(TEXT_INSTALL_214, TEXT_INSTALL_233);
           else
             printf(TEXT_INSTALL_214, TEXT_INSTALL_234);
        }
        if (((config.serno[1] == '3') && (config.serno[2] == '2')) ||
            ((config.serno[1] == '3') && (config.serno[2] == '5')) ||
            ((config.serno[1] == '3') && (config.serno[2] == '6')) ||
            ((config.serno[1] == '3') && (config.serno[2] == '8')) ||
            ((config.serno[1] == '5') && (config.serno[2] == '0')) ||
            ((config.serno[1] == '6') && (config.serno[2] == '2')) ||
            ((config.serno[1] == '6') && (config.serno[2] == '5'))) {
           if (fs_cfg.sdata[11] & PRINT_REPORT)
             printf(TEXT_INSTALL_210, TEXT_INSTALL_221);
           else
             printf(TEXT_INSTALL_211, TEXT_INSTALL_221);
           if (fs_cfg.sdata[11] & PRINT_PS)
             printf(TEXT_INSTALL_213, TEXT_INSTALL_221);
           else
             printf(TEXT_INSTALL_212, TEXT_INSTALL_221);
           if (((config.serno[1] == '6') && (config.serno[2] == '2')) ||
               ((config.serno[1] == '6') && (config.serno[2] == '5'))) {
             if (fs_cfg.sdata[5] == 0)
               printf(TEXT_INSTALL_214, TEXT_INSTALL_232);
             else
             if (fs_cfg.sdata[5] == 1)
               printf(TEXT_INSTALL_214, TEXT_INSTALL_230);
             else
             if (fs_cfg.sdata[5] == 2)
               printf(TEXT_INSTALL_214, TEXT_INSTALL_231);
             else
             if (fs_cfg.sdata[5] == 3)
               printf(TEXT_INSTALL_214, TEXT_INSTALL_233);
             else
                printf(TEXT_INSTALL_214, TEXT_INSTALL_234);
           }
        }
        if ((config.serno[1] != '6') ||
            ((config.serno[1] == '6') && (config.serno[2] == '2')) ||
            ((config.serno[1] == '6') && (config.serno[2] == '5'))) {
           if ((config.serno[1] == '3') && ((config.serno[2] == '7') ||
               (config.serno[2] == '8') || (config.serno[2] == '9')))
             goto next_one;
           if (fs_cfg.sdata[12] & PRINT_REPORT)
             printf(TEXT_INSTALL_210, TEXT_INSTALL_222);
           else
             printf(TEXT_INSTALL_211, TEXT_INSTALL_222);
           if (fs_cfg.sdata[12] & PRINT_PS)
             printf(TEXT_INSTALL_213, TEXT_INSTALL_222);
           else
             printf(TEXT_INSTALL_212, TEXT_INSTALL_222);
           if (tcpip_cfg.baud_rate[0] == 1)
             printf(TEXT_INSTALL_217, TEXT_INSTALL_250);
           else
           if (tcpip_cfg.baud_rate[0] == 2)
             printf(TEXT_INSTALL_217, TEXT_INSTALL_251);
           else
           if (tcpip_cfg.baud_rate[0] == 3)
             printf(TEXT_INSTALL_217, TEXT_INSTALL_252);
           else
           if (tcpip_cfg.baud_rate[0] == 4)
             printf(TEXT_INSTALL_217, TEXT_INSTALL_253);
           else
           if (tcpip_cfg.baud_rate[0] == 5)
             printf(TEXT_INSTALL_217, TEXT_INSTALL_254);
           else
           if (tcpip_cfg.baud_rate[0] == 6)
             printf(TEXT_INSTALL_217, TEXT_INSTALL_255);
           else
           if (tcpip_cfg.baud_rate[0] == 7)
             printf(TEXT_INSTALL_217, TEXT_INSTALL_256);
           else
           if (tcpip_cfg.baud_rate[0] == 8)
             printf(TEXT_INSTALL_217, TEXT_INSTALL_257);
           else
             printf(TEXT_INSTALL_217, TEXT_INSTALL_255);
        }
next_one:
        if (((config.serno[1] == '3') && (config.serno[2] != '3') && 
             (config.serno[2] != '4') && (config.serno[2] != '7') && 
             (config.serno[2] != '8') && (config.serno[2] != '9')) ||
            ((config.serno[1] == '5') && (config.serno[2] == '0'))) {
           if (fs_cfg.sdata[13] & PRINT_REPORT)
             printf(TEXT_INSTALL_210, TEXT_INSTALL_223);
           else
             printf(TEXT_INSTALL_211, TEXT_INSTALL_223);
           if (fs_cfg.sdata[13] & PRINT_PS)
             printf(TEXT_INSTALL_213, TEXT_INSTALL_223);
           else
             printf(TEXT_INSTALL_212, TEXT_INSTALL_223);
           if (tcpip_cfg.baud_rate[1] == 1)
             printf(TEXT_INSTALL_217, TEXT_INSTALL_250);
           else
           if (tcpip_cfg.baud_rate[1] == 2)
             printf(TEXT_INSTALL_217, TEXT_INSTALL_251);
           else
           if (tcpip_cfg.baud_rate[1] == 3)
             printf(TEXT_INSTALL_217, TEXT_INSTALL_252);
           else
           if (tcpip_cfg.baud_rate[1] == 4)
             printf(TEXT_INSTALL_217, TEXT_INSTALL_253);
           else
           if (tcpip_cfg.baud_rate[1] == 5)
             printf(TEXT_INSTALL_217, TEXT_INSTALL_254);
           else
           if (tcpip_cfg.baud_rate[1] == 6)
             printf(TEXT_INSTALL_217, TEXT_INSTALL_255);
           else
           if (tcpip_cfg.baud_rate[1] == 7)
             printf(TEXT_INSTALL_217, TEXT_INSTALL_256);
           else
           if (tcpip_cfg.baud_rate[1] == 8)
             printf(TEXT_INSTALL_217, TEXT_INSTALL_257);
           else
             printf(TEXT_INSTALL_217, TEXT_INSTALL_255);
        }
        if (fs_cfg.sdata[2] & ENABLE_UNIX) { /* UNIX function is enabled */
           if ((config.serno[1] == '6') && (config.serno[2] == '8')) /* Fujitsu 1p only */
             goto next_fu;
           if (fs_cfg.sdata[2] & ENABLE_NOVELL)
             printf(TEXT_INSTALL_400A);
           else
             printf(TEXT_INSTALL_400B);
next_fu:
           if (tcpip_cfg.ifaddr != 0) {
             ipaddr.s_addr = tcpip_cfg.ifaddr;
             printf(TEXT_INSTALL_401, inet_ntoa(ipaddr));
           }
           else {
             printf(TEXT_INSTALL_402);
           }
           if (tcpip_cfg.gate0 != 0) {
             ipaddr.s_addr = tcpip_cfg.gate0;
             printf(TEXT_INSTALL_403, inet_ntoa(ipaddr));
           }
           if (tcpip_cfg.subnetmask != 0) {
             ipaddr.s_addr = tcpip_cfg.subnetmask;
             printf(TEXT_INSTALL_405, inet_ntoa(ipaddr));
           }
        }
      }
      else {
        exit_code = 93;
        goto done;
      }
   }
   if (reset_flag == TRUE) {
      memset(&tcpip_cfg, 0, sizeof(struct tcpipcfg));
      sts = send_receive(sock, PSIPCFG_SHOW, 0, 0);
      memcpy((char *)&tcpip_cfg, (char *)&config.cfgbuf[80], sizeof(struct tcpipcfg));
      server.sin_addr.s_addr = tcpip_cfg.ifaddr;
      sts = send_receive(sock, PSIPCFG_RESET, 0, 0);
      if ((sts == 0) && (config.status == 0)) {
	 if (vaflag == TRUE || tcpip_cfg.ifaddr == 0) {
             printf("Reset Print server ...\n");
	     goto done;
         }
         close(sock);
        /* reset the print server */
        nopflag = TRUE;
        printf(TEXT_INSTALL_202);
        fflush(stdout);
        sleep(35);
        while (bt_chk) {
           sock = socket(AF_INET, SOCK_STREAM, 0);
           if (sock < 0) {
               exit(2);
           }
           if (connect(sock,(struct sockaddr *) &server,sizeof(server)) < 0) {
               if (++delay_cnt > 10) {
                  printf("\n\nReset timeout, please manually reboot print server %s.",argv[1]);
                  fflush(stdout);
                  bt_chk=0;
                }
              close(sock);
              sleep(15);
           }
           else{
              printf("\nPrint server %s has been successfully reset.\n",argv[1]);
              fflush(stdout);
              bt_chk=0;
           }
        }    /* end while */  
      }
      else {
        exit_code = 87;
        goto done;
      }
   }

   printf("\n");
   if ((sts == 0) && (nopflag == FALSE) && (nop_1_flag == TRUE))
      printf(TEXT_INSTALL_72, TEXT_INSTALL_73, ps_sn);
done:
   close(sock);
   exit(exit_code);
}
