
#!/bin/sh

##################################################################
#                                                                #
#   Copyright 1993, 1994, 1995 Castelle                          #
#                                                                #
#   Bourne Shell Script Usage: 'sh  extract.sh                   #
#                                                                #
#   extract.sh  -  script to extract Castelle software           #
#                                                                #
#                                                                #
##################################################################
#
# default parameters and filenames
#

BINDIR="."
DST=.

DIRLST1=".hpux .sco .solaris1x .solaris2x .sun3 .unixware .fujitsu .hitachi .nec .aix .others"
DIRLST2="$DIRLST1 .src"


#
# check for and set SVRx command flags
#

ECHO="echo -n"
NL=""
$ECHO "echo without newline" | grep '\-n' >/dev/null 2>& 1
if [ $? -eq 0 ]
then
	ECHO="echo"
	NL="\c"
fi


for DIR in $DIRLST2
do
	if [ -d $DIR ]
	then
		rm -rf $DIR
	fi
done
#
# if distribution binaries are compressed, uncompress and extract tar files
#

if [ -f zbin.Z ]
then
	uncompress zbin.Z
	if [ $? -ne 0 ]
	then
		echo " uncompress zbin.Z failed "
		exit 1
	fi
	tar xvpf zbin
	if [ $? -ne 0 ]
	then
		echo " tar xvf zbin failed "
		exit 1
	fi
	rm zbin 
else
	echo ""
	echo "The compressed file zbin.Z is missing."
	echo "Castelle software has not been extracted."
	echo ""
	exit 1
fi

#
# main loop
#
while [ 0 ]
do
	clear
	echo "Please select the type of UNIX system you are using now."
	echo ""
	echo "  1. Sun-OS 4.x   [Machine: Sun 3/xx          CPU: 680x0  ]"
	echo "  2. Solaris 1.x  [Machine: Sun Sparc         CPU: SPARC  ]"
	echo "  3. SCO UNIX     [Machine: IBM-PC            CPU: 80x86  ]"
	echo "  4. Solaris 2.x  [Machine: Sun Sparc         CPU: SPARC  ]"
	echo "  5. HP-UX        [Machine: HP RISC           CPU: PA-RISC]"
	echo "  6. UnixWare     [Machine: IBM-PC            CPU: 80x86  ]"
	echo "  7. UXP/DS       [Machine: Fujitsu DS/90     CPU: SPARC  ]"
	echo "  8. HI-UX        [Machine: HITACHI 3050RX    CPU: PA-RISC]"
	echo "  9. EWS-UX/V     [Machine: NEC EWS4800       CPU: RISC   ]"
	echo " 10. AIX          [Machine: RS6000            CPU:        ]"
	echo " 11. other UNIX   [Machine: Any               CPU: Any    ]"
	echo ""
	echo "Please enter your selection [1-11]: $NL"
	read INPUT

        case $INPUT in
            1|2|3|4|5|6|7|8|9|10|11)
		echo ""
		echo "Please re-enter your selection $INPUT : $NL"
		read CONFIRM
		if [ $CONFIRM = $INPUT ]
		then
			break
		else
			continue
		fi
                ;;
            *)
		echo ""
		echo "Invalid input - please select a number."
		echo ""
		continue
                ;;
	esac	
done
case $INPUT in
    1)	BINDIR=".sun3"
	;;
    2)	BINDIR=".solaris1x"
	;;
#    3)	BINDIR=".sco"
#	;;
    4)	BINDIR=".solaris2x"
	;;
    5)	BINDIR=".hpux"
	;;
    6)	BINDIR=".unixware"
	;;
    7)	BINDIR=".fujitsu"
	;;
#    8)	BINDIR=".hitachi"
#	;;
    9)	BINDIR=".nec"
	;;
    10)	BINDIR=".aix"
	;;
    *)	BINDIR=".other"
	for DIR in $DIRLST1
	do
	    if [ -d $DIR ]
	    then
		rm -rf $DIR
	    fi
	done
	echo ""
	echo "Please call Castelle Customer Support for further assistance."
	echo ""
	echo "(Voice) +1 408 496 0474  --< USA >--  (Fax) +1 408 496 0502"
	echo ""
	exit 2
	;;
esac

mv $BINDIR/* $DST
if [ $? -eq 0 ]
then
	echo ""
	echo "Successfully extracted the software !"
	echo ""
else
	echo ""
	echo "Failed....."
	echo ""
fi


for DIR in $DIRLST2
do
	if [ -d $DIR ]
	then
		rm -rf $DIR
	fi
done
# 
