#include <gks/gks_types.h>
#include <gks/message.h>
#include <gks/qpixarr.h>

#include <gks/trace.h>

#include "wsinfo.h"

GKSERR
q_px_pix(wkid, p, errno, pixel)
WKID wkid ;
WCPT *p ;
GKSERR *errno ;
COLOR *pixel ;
{
	struct msqpixarr *msg ;
	struct rpqpixarr *reply ;
	static char *fname = "q_px_pix" ;
	WSINFO ws ;

	if(!Gksckstate(GS_WSOP | GS_WSAC | GS_SGOP))
	{
		*errno = 7 ;
		return ;
	}
	if(wkid <= 0)
	{
		*errno = 20 ;
		return ;
	}
	ws = WsId2info(wkid) ;
	if(ws == NULL)
	{
		*errno = 25 ;
		return ;
	}
	if((WsGetcat(ws) != WSC_OUTPUT) && (WsGetcat(ws) != WSC_OUTIN))
	{
		*errno = 39 ;
		return ;
	}
/*
 * deliver "inquire pixel array " message
 */
	msg = (struct msqpixarr *)_allocmsg(sizeof(struct msqpixarr)) ;
	if(msg == NULL)
	{
		*errno = 904 ;
		return ;
	}
	qpixarrmsg(msg, WsGetpid(ws), p, 1, 1) ;
	_sendmsg((char *)msg) ;
/*
 * wait for reply
 */
	reply = (struct rpqpixarr *)_recvmsg(WsGetpid(ws)) ;
	if(reply == NULL)
	{
		*errno = WsNomsg() ;
		return ;
	}
	switch(reply -> mhdr.msg_reply)
	{
		case 0:
			*errno = 0 ;
			break ;

		case 1: /* no pixel readback */
			*errno = 40 ;
			break ;
		
		case 2: /* invalid dimensions */
			*errno = 84 ;
			break ;

		default:
			Gksout("%s: unexpected reply\n", fname) ;
			*errno = 0 ;
	}
	if(*errno == 0)
	{
		
/*
 * transfer returned pixel.
 */
			*pixel = *(reply -> qpa_col) ;
	}
#ifdef TRACE
	if(Gksdebug & DB_INQUIRE)
		Gksout("%s(%d, (%.2f, %.2f), ...)\n",
			fname, wkid,  p -> wc_x, p -> wc_y) ;
#endif
	_freemsg(reply) ;
}

static
qpixarrmsg(msg, pid, p, dx, dy)
struct msqpixarr *msg ;
PID pid ;
WCPT *p ;
unsigned short dx, dy ;
{
	msg -> mhdr.msg_id = MSQPIXARR ;
	msg -> mhdr.msg_to = pid ;
	msg -> mhdr.msg_length = sizeof(struct msqpixarr) - sizeof(MSGHDR) ;
	msg -> mhdr.msg_ack = TRUE ;
	msg -> mhdr.msg_reply = 0 ;
	_wc2ndc(p, &(msg -> qpa_p)) ;
	msg -> qpa_x = dx ;
	msg -> qpa_y = dy ;
}

static char *SccsId = "@(#)q_px_pix.c	1.5\t2/21/85" ;
