#include <gks/gks_types.h>
#include <gks/gks_structs.h>
#include <gks/message.h>
#include <gks/qwsseg.h>

#include <gks/trace.h>

#include "wsinfo.h"

#define min(x,y) ((x) < (y) ? (x) : (y))
extern struct gksstate Gksstate ;

struct wdinfo *Getwdinfo() ;

/*
 * inquire gdp's available on workstation.
 */
VOID
q_wd_avgdp(wktype, errno, n, gdplist)
WSTYPE wktype ;
GKSERR *errno ;
int *n ;
unsigned short gdplist[] ;
{
	int i ;
	struct wdinfo *p ;

	if(!Gksckstate(GS_GKOP | GS_WSOP | GS_WSAC | GS_SGOP))
	{
		*errno = 8 ;
		return ;
	}

	if(wktype == 0)
	{
		*errno = 22 ;
		return ;
	}

	if((p = Getwdinfo(wktype, errno)) == NULL)
		return ;
	
	*n = min(*n, p -> wd_ngdp) ;
	for(i=0; i<*n; i++)
		gdplist[i] = p -> wd_gdp[i] ;
}

static char *SccsId = "@(#)q_wd_avgdp.c	1.3\t3/12/85" ;
