#include <gks/gks_types.h>
#include <gks/gks_structs.h>
#include <gks/message.h>
#include <gks/qwdinfo.h>

#include <gks/trace.h>

#include "wsinfo.h"

extern struct gksstate Gksstate ;

struct wdinfo *Getwdinfo() ;
/*
 * inquire workstation default deferral state
 */
VOID
q_wd_ninp(wktype, errno, nloc, nstk, nval, nchc, npck, nstr)
WSTYPE wktype ;
GKSERR *errno ;
unsigned short *nloc ;
unsigned short *nstk ;
unsigned short *nval ;
unsigned short *nchc ;
unsigned short *npck ;
unsigned short *nstr ;
{
	static char *fname = "q_wd_ninp" ;
	struct wdinfo *p ;

	if(!Gksckstate(GS_GKOP | GS_WSOP | GS_WSAC | GS_SGOP))
	{
		*errno = 8 ;
		return ;
	}

	if((p = Getwdinfo(wktype, errno)) == NULL)
		return ;
	
	*nloc = p -> wd_nloc ;
	*nstk = p -> wd_nstk ;
	*nval = p -> wd_nval ;
	*nchc = p -> wd_nchc ;
	*npck = p -> wd_npck ;
	*nstr = p -> wd_nstr ;
	*errno = 0 ;

#ifdef TRACE
	if(Gksdebug & DB_INQUIRE)
		Gksout("%s(%d, %d, %d, %d, %d, %d, %d)\n", fname, wktype, *errno,
			*nloc, *nstk, *nval, *nchc, *npck, *nstr) ;
#endif
}

static char *SccsId = "@(#)q_wd_ninp.c	1.2\t2/21/85" ;
