#include <gks/gks_types.h>
#include <gks/gks_structs.h>
#include <gks/message.h>
#include <gks/qwdinp.h>

#include "wsinfo.h"

/*
 * default records for input devices
 */

extern struct gksstate Gksstate ;

BOOL Getwdinp() ;
/*
 * provide buffer service for qwdinp message
 */

BOOL
Getwdinp(wktype, errno, class, devno, buf)
WSTYPE wktype ;
GKSERR *errno ;
INPUTCLASS class ;
int devno ;
char *buf ; /* a pointer to one of several types of structures */
{
	struct msqwdinp *msg ;
	struct rpqwdinp *reply ;
	WSINFO ws ;
	BOOL must_close = FALSE ;

	if((msg = (struct msqwdinp *)_allocmsg(sizeof(struct msqwdinp))) == NULL)
	{
		Gksout("unable to allocate message\n") ;
		return(FALSE) ;
	}
/*
* see if workstation of specified type is already open.
*/
	for(ws = WsFirst(); ws != NULL; ws = WsNext())
		if(WsGettype(ws) == wktype)
			break ;

	if (ws == NULL)
		{
		*errno = 25;
		return (FALSE);
		}
/***********************************************************************
	if(ws == NULL)		/* quel dommage!
						 * must open workstation, ask, and close it.
						 */
/***********************************************************************
	{
		if(open_ws(0xffff, "", wktype) != 0)
		{
			*errno = 22 ;
			return(FALSE) ;
		}
		ws = WsId2info(0xffff) ;
		must_close = TRUE ;
	}
***********************************************************************/
	if((WsGetcat(ws) != WSC_INPUT) && (WsGetcat(ws) != WSC_OUTIN))
	{
		*errno = 38 ;
		if(must_close)
			close_ws(0xffff) ;
		return(FALSE) ;
	}

	wdinpmsg(msg, WsGetpid(ws), class, devno) ;
	_sendmsg((char *)msg) ;
	/*
	 * wait for reply
	 */
	reply = (struct rpqwdinp *)_recvmsg(WsGetpid(ws)) ;
	if(reply == NULL)
	{
		Gksout("internal error: unable to receive message from workstation\n") ;
		return(FALSE) ;
	}
	if(reply -> mhdr.msg_reply != 0 )
		*errno = 140 ;
	else
	{
		*errno = 0 ;
		
		switch(class)
		{
			case LOCATOR:
				cpybuf((struct wd_locinfo *)buf,
					&(reply -> qwd_un.qwd_loc), sizeof(struct wd_locinfo)) ;
				break ;
			
			case STROKE:
				cpybuf((struct wd_stkinfo *)buf,
					&(reply -> qwd_un.qwd_stk), sizeof(struct wd_stkinfo)) ;
				break ;
			
			case VALUATOR:
				cpybuf((struct wd_valinfo *)buf,
					&(reply -> qwd_un.qwd_val), sizeof(struct wd_valinfo)) ;
				break ;
			
			case CHOICE:
				cpybuf((struct wd_chcinfo *)buf,
					&(reply -> qwd_un.qwd_chc), sizeof(struct wd_chcinfo)) ;
				break ;
			
			case PICK:
				cpybuf((struct wd_pckinfo *)buf,
					&(reply -> qwd_un.qwd_pck), sizeof(struct wd_pckinfo)) ;
				break ;
			
			case STRING:
				cpybuf((struct wd_strinfo *)buf,
					&(reply -> qwd_un.qwd_str), sizeof(struct wd_strinfo)) ;
				break ;
		}
	}
		
	if(must_close)
		close_ws(0xffff) ;
	_freemsg(reply) ;
	return(TRUE) ;
}

static
wdinpmsg(msg, pid, class, dev)
struct msqwdinp *msg ;
PID pid ;
INPUTCLASS class ;
int dev ;
{
	msg -> mhdr.msg_id = MSQWDINP ;
	msg -> mhdr.msg_to = pid ;
	msg -> mhdr.msg_length = sizeof(struct msqwdinp) - sizeof(MSGHDR) ;
	msg -> mhdr.msg_ack = TRUE ;
	msg -> mhdr.msg_reply = 0 ;
	msg -> qwdi_class = class ;
	msg -> qwdi_devno = dev ;

}

static char *SccsId = "@(#)q_wdinp.c	1.6\t3/12/85" ;
