#include <gks/gks_types.h>
#include <gks/gks_structs.h>
#include <gks/message.h>

#include <gks/trace.h>

#include "wsinfo.h"

extern struct gksstate Gksstate ;

/*
 * inquire workstation connection and type
 */
VOID
q_ws_conn(wkid, errno, conn, type)
WKID wkid ;
GKSERR *errno ;
char *conn ;
WSTYPE *type ;
{
	static char *fname = "q_ws_conn" ;
	WSINFO ws ;

	if(!Gksckstate(GS_WSOP | GS_WSAC | GS_SGOP))
	{
		*errno = 7 ;
		return ;
	}

	if(wkid == 0)
	{
		*errno = 20 ;
		return ;
	}

	ws = WsId2info(wkid) ;
	if(ws == NULL)
	{
		*errno = 25 ;
		return ;
	}

	copystr(conn, WsGetconn(ws), MAXCONN) ;
	*type = WsGettype(ws) ;
	*errno = 0 ;

#ifdef TRACE
	if(Gksdebug & DB_INQUIRE)
		Gksout("%s(%d, %d, %s, %d)\n", fname, wkid, *errno, conn, *type) ;
#endif
}

static char *SccsId = "@(#)q_ws_conn.c	1.2\t2/21/85" ;
