#include <gks/gks_types.h>
#include <gks/gks_structs.h>
#include <gks/message.h>
#include <gks/qwsinfo.h>

#include <gks/trace.h>

#include "wsinfo.h"

extern struct gksstate Gksstate ;

/*
 * inquire number of fill area indices
 */
VOID
q_ws_fai(wkid, errno, nfai)
WKID wkid ;
GKSERR *errno ;
int *nfai ;
{
	static char *fname = "q_ws_fai" ;
	WSINFO ws ;
	struct msqwsinf *msg ;
	struct rpqwsinf *reply ;

	if(!Gksckstate(GS_WSOP | GS_WSAC | GS_SGOP))
	{
		*errno = 7 ;
		return ;
	}
	if(wkid == 0)
	{
		*errno = 20 ;
		return ;
	}

	ws = WsId2info(wkid) ;
	if(ws == NULL)
	{
		*errno = 25 ;
		return ;
	}
	if(WsGetcat(ws) == WSC_MI)
	{
		*errno = 33 ;
		return ;
	}
	if(WsGetcat(ws) == WSC_INPUT)
	{
		*errno = 35 ;
		return ;
	}
	if(WsGetcat(ws) == WSC_WISS)
	{
		*errno = 36 ;
		return ;
	}

	msg = (struct msqwsinf *)_allocmsg(sizeof(struct msqwsinf)) ;
	if(msg == NULL)
	{
		*errno = 904 ;
		return ;
	}
	wsinfmsg(msg, WsGetpid(ws)) ;
	_sendmsg((char *)msg) ;
/*
 * wait for reply
 */
	reply = (struct rpqwsinf *)_recvmsg(WsGetpid(ws)) ;
	if(reply == NULL)
	{
		*errno = WsNomsg() ;
		return ;
	}
	
	*nfai = reply -> qs_info.ws_nfab ;
	*errno = 0 ;
	_freemsg(reply) ;

#ifdef TRACE
	if(Gksdebug & DB_INQUIRE)
		Gksout("%s(%d, %d, %d)\n", fname, wkid, *errno, *nfai) ;
#endif
}

static char *SccsId = "@(#)q_ws_fai.c	1.5\t2/21/85" ;
