#include <gks/gks_types.h>
#include <gks/gkstrans.h>
#include <gks/gks_structs.h>
#include <gks/message.h>
#include <gks/qwsinfo.h>

#include <gks/trace.h>

#include "wsinfo.h"

extern struct gksstate Gksstate ;

/*
 * inquire current workstation transformation
 */
VOID
q_ws_ctr(wkid, errno, pending, winll, winur, viewll, viewur)
WKID wkid ;
GKSERR *errno ;
BOOL *pending ;
NDCPT *winll ;
NDCPT *winur ;
DCPT *viewll ;
DCPT *viewur ;
{
	WSINFO ws ;
	struct msqwsinf *msg ;
	struct rpqwsinf *reply ;

	if(!Gksckstate(GS_WSOP | GS_WSAC | GS_SGOP))
	{
		*errno = 7 ;
		return ;
	}

	if(wkid == 0)
	{
		*errno = 20 ;
		return ;
	}

	ws = WsId2info(wkid) ;
	if(ws == NULL)
	{
		*errno = 25 ;
		return ;
	}
	if(WsGetcat(ws) == WSC_MI)
	{
		*errno = 33 ;
		return ;
	}
	if(WsGetcat(ws) == WSC_WISS)
	{
		*errno = 36 ;
		return ;
	}
	msg = (struct msqwsinf *)_allocmsg(sizeof(struct msqwsinf)) ;
	if(msg == NULL)
	{
		*errno = 904 ;
		return ;
	}
	wsinfmsg(msg, WsGetpid(ws)) ;
	_sendmsg((char *)msg) ;
/*
 * wait for reply
 */
	reply = (struct rpqwsinf *)_recvmsg(WsGetpid(ws)) ;
	if(reply == NULL)
	{
		*errno = WsNomsg() ;
		return ;
	}
	
	*errno = 0 ;
	if( reply->mhdr.msg_reply != 0)
	{
		Gksout("internal error: unexpected reply from qwsinfo\n") ;
		return ;
	}
	*pending = reply -> qs_info.ws_trpend ;
	cpybuf((char *)winll, (char *)&(reply -> qs_info.ws_cwll), sizeof(NDCPT)) ;
	cpybuf((char *)winur, (char *)&(reply -> qs_info.ws_cwur), sizeof(NDCPT)) ;
	cpybuf((char *)viewll, (char *)&(reply -> qs_info.ws_cvll), sizeof(DCPT)) ;
	cpybuf((char *)viewur, (char *)&(reply -> qs_info.ws_cvur), sizeof(DCPT)) ;

}


/*
 * inquire requested workstation transformation
 */
VOID
q_ws_rtr(wkid, errno, pending, winll, winur, viewll, viewur)
WKID wkid ;
GKSERR *errno ;
BOOL *pending ;
NDCPT *winll ;
NDCPT *winur ;
DCPT *viewll ;
DCPT *viewur ;
{
	WSINFO ws ;
	struct msqwsinf *msg ;
	struct rpqwsinf *reply ;

	if(!Gksckstate(GS_WSOP | GS_WSAC | GS_SGOP))
	{
		*errno = 7 ;
		return ;
	}

	if(wkid == 0)
	{
		*errno = 20 ;
		return ;
	}

	ws = WsId2info(wkid) ;
	if(ws == NULL)
	{
		*errno = 25 ;
		return ;
	}
	if(WsGetcat(ws) == WSC_MI)
	{
		*errno = 33 ;
		return ;
	}
	if(WsGetcat(ws) == WSC_WISS)
	{
		*errno = 36 ;
		return ;
	}
	msg = (struct msqwsinf *)_allocmsg(sizeof(struct msqwsinf)) ;
	if(msg == NULL)
	{
		*errno = 904 ;
		return ;
	}
	wsinfmsg(msg, WsGetpid(ws)) ;
	_sendmsg((char *)msg) ;
/*
 * wait for reply
 */
	reply = (struct rpqwsinf *)_recvmsg(WsGetpid(ws)) ;
	if(reply == NULL)
	{
		*errno = WsNomsg() ;
		return ;
	}
	
	*errno = 0 ;
	if( reply->mhdr.msg_reply != 0)
	{
		Gksout("internal error: unexpected reply from qwsinfo\n") ;
		return ;
	}
	*pending = reply -> qs_info.ws_trpend ;
	cpybuf((char *)winll, (char *)&(reply -> qs_info.ws_rwll), sizeof(NDCPT)) ;
	cpybuf((char *)winur, (char *)&(reply -> qs_info.ws_rwur), sizeof(NDCPT)) ;
	cpybuf((char *)viewll, (char *)&(reply -> qs_info.ws_rvll), sizeof(DCPT)) ;
	cpybuf((char *)viewur, (char *)&(reply -> qs_info.ws_rvur), sizeof(DCPT)) ;
}

static char *SccsId = "@(#)q_ws_tr.c	1.7\t3/12/85" ;
