#include "gks_types.h"
#include "gks.h"

/*
 *	request pick
 */
GKSERR	rq_pck(wkid, devno, status, segname, pickid)
	WKID	wkid;
	int	devno;
	PICKSTAT *status;
	SEGNAME *segname;
	PICKID *pickid;
{
	Gpick	pickit;
	Gint	errno;
	errno = greqpick(wkid, devno, &pickit);
	switch (pickit.status)
		{
	case GP_NONE:
		*status = NONE;
		break;
	case GP_OK:
		*status = OK;
		break;
	case GP_NOPICK:
		*status = NOPICK;
		break;
	default:
		printf("req_pck parameter out of range\n");
		}
	*segname = pickit.seg;
	*pickid = pickit.pickid;
	return errno;
}
