PAGE ,132
TITLE	SEMA4
;=========================================================================
;
;     CORVUS/IBM SEMAPHORE CONTROL UNIT.  FOR INTERFACE
;		WITH MICROSOFT PASCAL COMPILER
;	      MSDOS 1.x and 2.x CONSTELLATION II
;
;	      VERSION 1.00  BY	NORMAN O. DOYLE
;		(MICROSOFT ASSEMBLER VERSION)
;
;
;
;	THIS UNIT IMPLEMENTS 3 PROCEDURES:
;
;		SemLock   - Lock a semaphore
;		SemUnLock - Unlock a semaphore if locked
;		SemStatus - Return names of all locked semaphores
;
;
;=========================================================================
;			REVISION HISTORY
;
; FIRST VERSION :  8-14-84  BY NORMAN O. DOYLE
;
;=========================================================================

;
	EXTRN	CDSND_ASM:FAR, CDRCV_ASM:FAR
;
Lock		EQU	0FFFFH	; FUNCTION TYPE
UnLock		EQU	0	; FUNCTION TYPE
LockCmd 	EQU	010BH	; COMMAND TO LOCK A SEMA4
UnLckCmd	EQU	110BH	; COMMAND TO UNLOCK A SEMA4
StatusCmd1	EQU	411AH	; COMMAND TO GET LIST OF ALL LOCKED SEMA4'S
StatusCmd2	EQU	0003H	;
StatusCmd3	EQU	0	;
Len		EQU	000AH	; LENGTH OF DATA FOR A LOCK/UNLOCK COMMAND
Statlen 	EQU	0005H	; LENGTH OF DATA FOR A STATUS COMMAND
;
; ---- ALLOCATE MEMORY FOR THE COMMAND ---
;
DATSEG	SEGMENT 'DATA'
;
Cmd		DW ?		; COMMAND LENGTH FIELD
		DB ?		; COMMAND
		DB ?		; LOCK/UNLOCK
		DB 8 DUP(?)	; SPACE FOR SEMA4 NAME
		DB 279 DUP(?)	; EXTRA SPACE NEEDED FOR SEMA4 TABLE
;
DATSEG	ENDS
PAGE
;
CODSEG	SEGMENT 'CODE'
	ASSUME CS:CODSEG
;
	PUBLIC	SemLock, SemUnLock, SemStatus
;
	DB	'CORVUS MSDOS 1.x AND 2.x CONST. II SEMA4 UTILITY,'
	DB	' PASCAL VERSION AS OF 08-14-84'
;
;--------------------------------------------------------------------
;
; SEMLOCK & SEMUNLOCK - THESE FUNCTIONS WILL TRY TO LOCK AND UNLOCK A
;			SEMAPHORE RESPECTIVELY.  THE CALLING
;			SEQUENCE FROM PASCAL IS:
;				X = SEMLOCK (NAME);   AND
;				X = SEMUNLOCK (NAME);
;			THEY ARE DEFINED IN PASCAL AS FOLLOWS:
;				FUNCTION SEMLOCK( NAME: STRING ) : INTEGER; EXTERN;
;				FUNCTION SEMUNLOCK( NAME: STRING ) : INTEGER; EXTERN;
;			THE RETURN VALUES FROM BOTH OF THESE FUNCTIONS ARE:
;				  0: SEMAPHORE WAS NOT SET
;				128: SEMAPHORE WAS SET
;				253: SEMAPHORE TABLE FULL
;				254: DISK ERROR
;			   NEGATIVE: ERROR CONDITION
;
SemLock PROC	FAR
	MOV	BX,Lock
	JMP	Start
SemUnLock:
	MOV	BX,UnLock
Start:
	PUSH	BP		; SAVE THE FRAME POINTER
	MOV	BP,SP		; SET A NEW ONE
;
	MOV	SI,6 [BP]	; GET ADDRESS OF NAME SENT
;
	MOV	AX,DATSEG
	MOV	ES,AX		; GET ES SEG ADDRESSABILITY
	ASSUME	ES:DATSEG	;  AND USE FOR LOCAL DATA
;
; ---- SET UP THE COMMAND STRING (LOCK or UNLOCK) ----
;
	MOV	WORD PTR ES:[CMD],Len
	CMP	BX,Lock
	JNE	Else
;If:	  (FUNCTION IS SemLock) THEN
	MOV	WORD PTR ES:[CMD+2],LockCmd
	JMP	Endif
Else:	; (FUNCTION IS SemUnLock)
	MOV	WORD PTR ES:[CMD+2],UnlckCmd
Endif:
;
; ---- INITIALIZE THE SEMAPHORE NAME FIELD TO BLANKS ----
;
	CLD
	MOV	CX,8		; INIT ARRAY TO BLANKS
	MOV	AL,20H
	MOV	DI,OFFSET ES:Cmd
	ADD	DI,4		; POINT TO NAME STRING
	REP	STOSB
;
; ---- NOW LOAD THE ACTUAL NAME SENT INTO THE COMMAND STRING ----
;
	XOR	CX,CX			; INITIALIZE CX TO 0
	MOV	CL,BYTE PTR [SI]	; GET THE LENGTH OF THE COMMAND
	INC	SI			; POINT TO THE SEMAPHORE NAME
	MOV	DI,OFFSET ES:Cmd	; GET ADDRESS TO PUT THE NAME
	ADD	DI,4
	REP	MOVSB			; LOAD THE PASSED NAME INTO THE CMD STRING
;
; ---- NOW SEND THE COMMAND ----
;
	PUSH	DS		; SAVE DS
	PUSH	ES
	POP	DS		; SET DS=ES
	MOV	AX,OFFSET ES:Cmd
	CALL	CDSND_ASM
	MOV	DI,OFFSET ES:Cmd
	CALL	CDRCV_ASM
	POP	DS		; RESTORE DS
;
; ---- SET UP THE RETURN VALUE ----
;
	XOR	AX,AX			; CLEAR OUT AX FOR RETURN VALUE
	TEST	BYTE PTR ES:[CMD+2],080H
	JS	LckErr			; JUMP FOR DISK ERRORS
	MOV	AL,BYTE PTR ES:[CMD+3]	; GET RETURN VALUE
	JMP	EndLck
LckErr:
	MOV	AL,BYTE PTR ES:[CMD+2]	; GET ERROR VALUE FOR RETURN
	NEG	AL
Endlck:
;
; ---- CLEAN UP AND RETURN ----
;
	POP	BP
	RET
SemLock ENDP
;
PAGE
;--------------------------------------------------------------------
;
; SEMSTATUS - THIS FUNCTION WILL RETURN THE NAMES OF ALL LOCKED
;			SEMAPHORES.  THE CALLING SEQUENCE FROM
;			PASCAL IS:
;				X = SEMSTATUS (NAME);
;			IT IS DEFINED IN PASCAL AS FOLLOWS:
;				FUNCTION SEMSTATUS( TABLE: DISKBUF ) : INTEGER; EXTERN;
;			THE RETURN VALUES ARE:
;				NEGATIVE: ERROR CONDITION
;
;
SemStatus	PROC	FAR
;
	PUSH	BP		; SAVE THE FRAME POINTER
	MOV	BP,SP		; SET A NEW ONE
	PUSH	DS		; SAVE DS
;
	MOV	SI,6 [BP]	; GET ADDRESS OF NAME SENT
;
	PUSH	SI		; SAVE THE ADDRESS OF THE PASSED ARRAY
	MOV	AX,DATSEG
	MOV	ES,AX		; GET ES SEG ADDRESSABILITY
	ASSUME	ES:DATSEG	;  AND USE FOR LOCAL DATA
;
; ---- SET UP THE COMMAND STRING ----
;
	MOV	WORD PTR ES:[CMD],StatLen
	MOV	WORD PTR ES:[CMD+2],StatusCmd1
	MOV	WORD PTR ES:[CMD+4],StatusCmd2
	MOV	BYTE PTR ES:[CMD+6],StatusCmd3
;
; ---- NOW SEND THE COMMAND ----
;
	CLD
	PUSH	DS		; SAVE DS TO RESTORE INTO ES LATER
	PUSH	ES
	POP	DS		; SET DS=ES
	MOV	AX,OFFSET ES:Cmd
	CALL	CDSND_ASM
	MOV	DI,OFFSET ES:Cmd
	CALL	CDRCV_ASM
	POP	ES		; RESTORE DS INTO ES
;
; ---- SET UP THE RETURN VALUE ----
;
	XOR	AX,AX			; CLEAR OUT AX FOR RETURN VALUE
	TEST	BYTE PTR DS:[CMD+2],080H
	JNS	EndStat 		; JUMP IF NO DISK ERRORS
	MOV	AL,BYTE PTR DS:[CMD+2]	; GET ERROR VALUE FOR RETURN
	NEG	AL
EndStat:
	POP	DI			; RESTORE THE PASSED ARRAY ADDRESS INTO DI
	MOV	SI,3			; NAME ARRAY STARTS AT CMD+3
	MOV	CX,256			; GET 256 CHARACTERS (BYTES)
	CLD
	REP	MOVSB
;
; ---- CLEAN UP AND RETURN ----
;
	POP	DS			; RESTORE DS BEFORE RETURNING
	POP	BP
	RET
;
SemStatus	ENDP
CODSEG	ENDS
	END
