#ifndef HWMON__LISTMGR_H__LOADED
#define HWMON__LISTMGR_H__LOADED
/*---------------------------------------------------------------------
 *        [ Copyright (c) 1999 Alpha Processor Inc.] - Unpublished Work
 *          All rights reserved
 * 
 *    This file contains source code written by Alpha Processor, Inc.
 *    It may not be used without express written permission. The
 *    expression of the information contained herein is protected under
 *    federal copyright laws as an unpublished work and all copying
 *    without permission is prohibited and may be subject to criminal
 *    and civil penalties. Alpha Processor, Inc.  assumes no
 *    responsibility for errors, omissions, or damages caused by the use
 *    of these programs or from use of the information contained herein.
 *  
 *-------------------------------------------------------------------*/
/* Simple list management interface
 * $Id: listmgr.h,v 1.3 2001/03/12 20:11:33 slee Exp $
 * $Author: slee $
 */


typedef struct _list
{
    void *L;
    struct _list *next;
} list_t;

typedef void list_operator_t( void * );



/* S may point to NULL to create a list node with NULL data pointer
 * (this will be handled OK by the manipulation routines) */
list_t *makelist( void *S );


/* Create a new list entry and add it to the front of the list.
 * Note: this has the behaviour of reversing the list order when 
 * iterating along the list.
 */
list_t *list_add( list_t *List, void *val );


/* Calculate the length of a list */
size_t list_len( list_t *L );


/* Apply a function to every member of the list (except NULL-pointers) */
void list_act( list_t *L, list_operator_t *A );

/* To traverse the list */
list_t * list_getnext( list_t *L );

/* This list library, when making a list, puts the latest addition to the
 * head of the list.  If you need an ordered list in the other order, 
 * here's a reversing function.
 */
list_t *list_rev( list_t *L );


/* Join two lists, returning the joined result.  This code has the property
 * that the destination list (which comes second) is preserved, and the 
 * source list is reversed.
 */
list_t *list_join( list_t *src, list_t *dest );

#define list_getatom(List) (List->L)

/*------------------------------------------------------------------------*/
#endif	/* HWMON__LISTMGR_H__LOADED */
