/*---------------------------------------------------------------------
 *        [ Copyright (c) 1999 Alpha Processor Inc.] - Unpublished Work
 *          All rights reserved
 * 
 *    This file contains source code written by Alpha Processor, Inc.
 *    It may not be used without express written permission. The
 *    expression of the information contained herein is protected under
 *    federal copyright laws as an unpublished work and all copying
 *    without permission is prohibited and may be subject to criminal
 *    and civil penalties. Alpha Processor, Inc.  assumes no
 *    responsibility for errors, omissions, or damages caused by the use
 *    of these programs or from use of the information contained herein.
 *  
 *-------------------------------------------------------------------*/


#include "osf.h"
#include "cserve.h"
#include "ledcodes.h"
#include "impure.h"
#include "memory.h"

/* this code is entered, uncompressed, from the PALcode, and it jumps to the
 * fail-safe booter entry point in fsb/main.c */


        .text
	.set	noat
	.set	noreorder

        .globl  __start
        .ent    __start, 0
__start:

        /*--------------------------------------------------------------------*/
        /* setup the stack */

        lda     t0, STACK_MEGS(zero)
        sll     t0, 20, t0              /* produce top of stack */

        lda     t1, -1(zero)            /* 0xFFFFFFFFFFFFFFFF */
        sll     t1, 47, t1              /* 0xFFFF800000000000 */
        bis     sp, t1, sp              /* set superpage bits in SP */


	/*--------------------------------------------------------------------*/
	/* setup the global offset table (GOT) pointer */

        br      t1, 2f                  # get the current PC
2:      ldgp    gp, 0(t1)               # init gp


        /*--------------------------------------------------------------------*/
        /* load the impure region pointer */

        lda     a2, CSERVE_K_RD_IMPURE
        call_pal PAL_CSERVE_ENTRY
        bis     v0, zero, s1


        /*--------------------------------------------------------------------*/
        /* call main() */

        /* restore args */
	lda	a0, 0
        bis     s1, zero, a1            /* impure region pointer */
	lda	a2, 0

        lda     pv, fsb_main
        jsr     ra, (pv)

        /* [we should never return here] */
	halt

        .end    __start

