/*---------------------------------------------------------------------
 *        [ Copyright (c) 1999 Alpha Processor Inc.] - Unpublished Work
 *          All rights reserved
 * 
 *    This file contains source code written by Alpha Processor, Inc.
 *    It may not be used without express written permission. The
 *    expression of the information contained herein is protected under
 *    federal copyright laws as an unpublished work and all copying
 *    without permission is prohibited and may be subject to criminal
 *    and civil penalties. Alpha Processor, Inc.  assumes no
 *    responsibility for errors, omissions, or damages caused by the use
 *    of these programs or from use of the information contained herein.
 *  
 *-------------------------------------------------------------------*/

#include <stdarg.h>

#include "lib.h"
#include "uilib.h"

#include "platform.h"
#include "northbridge.h"
#include "southbridge.h"

#include "ledcodes.h"
#include "beepcodes.h"
#include "rom.h"
#include "smp.h"

#undef DEBUG

/*----------------------------------------------------------------------*/
/* Stubs for functions referred to in the main body of code but not 
 * implemented in the FSB.  This is not a clean solution, but we're low on 
 * space... */

#ifdef DEBUG
extern void init_putstr( String S );
#endif

int ftype( double x ) { return 0; }

void smp_acquire( smp_mutex *M ) { }
void smp_release( smp_mutex *M ) { }

void PutChar( char c )
{
#ifdef DEBUG
    char buf[2];

    buf[0] = c;
    buf[1] = 0;
    init_putstr( buf );
#endif
}

void LogChar( char c )
{
#ifdef DEBUG
    char buf[2];

    buf[0] = c;
    buf[1] = 0;
    init_putstr( buf );
#endif
}

void mobo_logf( const String S, ... ) 
{
#ifdef DEBUG
    init_putstr( S );
#endif
}
char mobo_alertf( const String S1, const String S2, ... ) 
{
#ifdef DEBUG
    init_putstr( S1 ); 
#endif
}

void diags_subsys_stat(enum systems sy, enum dev_state st) { }
void mobo_zap( Rect R ) {}
Rect r_app = { 0,0,1,1 };


unsigned char MachineCheckExpected=0, ExpectedMachineCheckTaken=0;
void PCIDumpUI( void ) {}
void PCIDumpLog( void ) {}

