/*---------------------------------------------------------------------
 *        [ Copyright (c) 1999 Alpha Processor Inc.] - Unpublished Work
 *          All rights reserved
 * 
 *    This file contains source code written by Alpha Processor, Inc.
 *    It may not be used without express written permission. The
 *    expression of the information contained herein is protected under
 *    federal copyright laws as an unpublished work and all copying
 *    without permission is prohibited and may be subject to criminal
 *    and civil penalties. Alpha Processor, Inc.  assumes no
 *    responsibility for errors, omissions, or damages caused by the use
 *    of these programs or from use of the information contained herein.
 *  
 *-------------------------------------------------------------------*/
/* Access mechanism for CMOS real-time clock */

/* We include platform-specific overrides here so that non-typical init
 * values may be set in platform include files and we'll inherit them here 
 * If no value is set, we define default settings below.
 */

#include "specifics.h"

extern const unsigned TimerModes[15];

extern unsigned short rtc_epoch;	/* console-dependent year encoding */
enum Epochs {
	EPOCH_ARC = 1980,
	EPOCH_SRM = 1952,
	EPOCH_PC  = 1900		/* an unacceptable epoch: change */
};


enum CMOSaddr {
        CM_SECS    = 0x00,              /* seconds in BCD format */
        CM_SECALRM = 0x01,
        CM_MINS    = 0x02,              /* minutes in BCD format */
        CM_MINALRM = 0x03,
        CM_HOURS   = 0x04,              /* hours in BCD format (12-hr fixup) */
        CM_HRALRM  = 0x05,
        CM_DAYWK   = 0x06,              /* lookup in DaysOfWeek */
        CM_DAYMTH  = 0x07,              /* in BCD format */
        CM_MONTH   = 0x08,              /* in BCD format, 1-12 */
        CM_YEAR    = 0x09,              /* year in BCD format - 00->99 */
        CM_STATUSA = 0x0A,
        CM_STATUSB = 0x0B,
        CM_STATUSC = 0x0C,
        CM_STATUSD = 0x0D,


	/* SRM's hiding place for the com1_baud variable */
	CM_BYTE_BASE = 0x11,		/* beginning of environment CMOS bytes */
	CM_COM1BAUD_VALID = 0x11, /* Valid:69 */
	CM_COM1BAUD = 0x12,

#if 0  /* rest of SRM uses */
	EV_APIDEBUG = 0x13,
	API_DRIVER_MISS = 0x14,

	EV_CONSOLE_TOY_OFFSET = 0x17,
	EV_GART_SIZE = 0x18,
	EV_HEAP_EXPAND = 0x18,
	EV_HEAP_EXPAND_VALID = 0x19,
	EV_MEMORY_TEST_TOY_OFFSET = 0x21 /* NONE = 0xDE */
	EV_MEMORY_ALLOC = 0x22,

	XDELTACONTROL = 0x3d, /* ON:1 OFF:0 */
	AVMIN_QUICKSTART = 0x3e, /* console ON:0x31 else: off*/
	EV_OSTYPE = 0x3f, /* 1:NT 2: VMS 3:OSF 4:Linux else:VMS */
#endif /* rest of SRM uses */
#if 0  /* reserved for higher level firmwrae */
	EV_NEXTLEVEL = 0x40,
	EV_LATLEVEL  = 0x7F,
#endif /* reserved for higher level firmwrae */
#if 0  /* reserved for lower level firmwrae */
	EV_NEXTLEVEL = 0x80,
	EV_LATLEVEL  = 0xFF,
#endif /* reserved for lower level firmwrae */

};

enum RTC_statusB_fields {
	STATUSB_HLT = 1<<7,	/* 1=halt clock */
	STATUSB_PER = 1<<6,	/* 1=enable periodic interrupt */
	STATUSB_ALR = 1<<5,	/* 1=enable alarm interrupt (unusual) */
	STATUSB_UPD = 1<<4,	/* 1=Update complete interrupt (unusual) */
	STATUSB_SQR = 1<<3,	/* 1=Square wave enable (on Tsunami systems) */
	STATUSB_BIN = 1<<2,	/* 1=binary date (BCD unusual on Alpha) */
	STATUSB_24HR= 1<<1,	/* 1=24-hour clock format */
	STATUSB_DST = 1<<0,	/* 1=dysfunctional daylight savings */
};

enum RTC_statusC_fields {
	STATUSC_IRQ = 1<<7,	/* Interrupt asserted */
	STATUSC_PIT = 1<<6,	/* - Interrupt was due to periodic timer */
	STATUSC_ALM = 1<<5,	/* - Interrupt was due to CMOS alarm */
	STATUSC_UPD = 1<<4,	/* - Interrupt was due to update ended */
};


/* Initialisation values - set platform-specific values if necessary */
#ifndef CM_STATUSA__INIT	/* default value, may be overridden */
#define CM_STATUSA__INIT	0x26
#endif

#ifndef CM_STATUSB__INIT	/* default value, may be overridden */
#define CM_STATUSB__INIT	(STATUSB_PER | STATUSB_BIN | STATUSB_24HR)
#endif

unsigned char cmosrb( enum CMOSaddr a );
void cmoswb( enum CMOSaddr a, unsigned char d );
DBM_STATUS cmosready( void );		/* update clock after calling this */


/* date/time mechanism */
typedef struct {
    unsigned char secs, secalrm, mins, minalrm, hours, hralrm;
    unsigned char daywk, daymth, month, year;
} RTC_t;

DBM_STATUS InitRTC( void );
void RTC_Get( RTC_t *r );		
void RTC_Set( RTC_t *r );	/* Note: call cmosready first */
void RTC_Canonicalize( void );		/* RTC settings sanity check */

/* time_t time(time_t *out); */

/*------------------------------------------------------------------------*/
/* CMOS-stored environment variables */

#define RTC_ENV_NOKEY -1

enum RTC_envvars {
    RTC_COM1_BAUD=0,

    /* Last place marker */
    RTC_ENV_NVARS
};

/* Values in the above enum are used to index this array */
extern const String rtc_env_desc[ RTC_ENV_NVARS ];

int rtc_envmatch( const String key );

int rtc_envrd( int var );
void rtc_envwr( int var, int val );



