/*---------------------------------------------------------------------
 *        [ Copyright (c) 1999 Alpha Processor Inc.] - Unpublished Work
 *          All rights reserved
 * 
 *    This file contains source code written by Alpha Processor, Inc.
 *    It may not be used without express written permission. The
 *    expression of the information contained herein is protected under
 *    federal copyright laws as an unpublished work and all copying
 *    without permission is prohibited and may be subject to criminal
 *    and civil penalties. Alpha Processor, Inc.  assumes no
 *    responsibility for errors, omissions, or damages caused by the use
 *    of these programs or from use of the information contained herein.
 *  
 *-------------------------------------------------------------------*/
/* Cypress CY82C693 Southbridge access routines */
/* Begun 29 June 1999 by Stig Telfer, API */


#include "lib.h"
#include "uilib.h"
#include "info.h"

#include "specifics.h"
#include "platform.h"
#include "northbridge.h"

#include "southbridge/cypress.h"
#include "southbridge/smcc669.h"
#include "southbridge.h"

#include "cmos_rtc.h"
#include "lpt.h"
#include "tabledriver.h"

static const TblArray setup_cy_sb[] =
{
    CFGWW( 0, PLAT_ISAID, CY_ISA, CY_COMMAND_REG,	0x010F ),
    CFGWB( 0, PLAT_ISAID, CY_ISA, CY_INTA_ROUTE,	0x80 ),
    CFGWB( 0, PLAT_ISAID, CY_ISA, CY_INTB_ROUTE,	0x80 ),
    CFGWB( 0, PLAT_ISAID, CY_ISA, CY_INTC_ROUTE,	0x80 ),
    CFGWB( 0, PLAT_ISAID, CY_ISA, CY_INTD_ROUTE,	0x80 ),
    CFGWB( 0, PLAT_ISAID, CY_ISA, CY_CONTROL_REG,	0x27 ),
    CFGWB( 0, PLAT_ISAID, CY_ISA, CY_ERR_CONTROL_REG,	0xe0 ),
    CFGWB( 0, PLAT_ISAID, CY_ISA, CY_BIOS_CONTROL_REG,	0xe0 ),
    CFGWB( 0, PLAT_ISAID, CY_ISA, CY_TOP_OF_MEM,	0xf0 ),
    CFGWB( 0, PLAT_ISAID, CY_ISA, CY_ATCTRL_REG1,	0x40 ),
    CFGWB( 0, PLAT_ISAID, CY_ISA, CY_IDE0_ROUTE,	0x80 ),
    CFGWB( 0, PLAT_ISAID, CY_ISA, CY_IDE1_ROUTE,	0x80 ),
    CFGWB( 0, PLAT_ISAID, CY_ISA, CY_SA_USB_CTRL,	0x70 ),

    /* enable soft-reset via port 92 */
    CFGWB( 0, PLAT_ISAID, CY_ISA, CY_ATCTRL_REG2,	0x00 ),

    /* Configure system programmable timer */

    IOWB( 0x43, 0x30 ),		/* timer 0 into mode 0 */
    IOWB( 0x40, 0x00 ),		/* send LSB of count */
    IOWB( 0x40, 0x00 ),		/* send MSB of count */

    /* initialise the 8259 controllers via PC-IO space */

    IOWB( 0x20, 0x11 ),
    IOWB( 0x21, 0x00 ),		/* IRQ0->7 are vectors 0->7 */
    IOWB( 0x21, 0x04 ),		/* slave on IRQ 2 */
    IOWB( 0x21, 0x01 ),		/* use 80x86 mode */

    IOWB( 0xA0, 0x11 ),
    IOWB( 0xA1, 0x08 ),		/* IRQ8->15 are vectors 8->15 */
    IOWB( 0xA1, 0x02 ),		/* slave on IRQ 2 */
    IOWB( 0xA1, 0x01 ),		/* use 80x86 mode */

 				/* disable all ISA interrupts */
    IOWB( 0x21, 0xFF ),		/* ints 0-7 active low */
    IOWB( 0xA1, 0xFF ),		/* ints 8-F active low */

    OP_EOT
};

static const TblArray setup_cy_ide[] = 
{
    /* enable IDE interrupt request route and DMA control */
    CFGWB( 0, PLAT_ISAID, CY_ISA, CY_ATCTRL_REG1,	0x60 ),

    /* disable routing of IDE interrupt 0, 1 (?) */
    CFGWB( 0, PLAT_ISAID, CY_ISA, CY_IDE0_ROUTE,	0x80 ),
    CFGWB( 0, PLAT_ISAID, CY_ISA, CY_IDE1_ROUTE,	0x80 ),
    CFGWB( 0, PLAT_ISAID, CY_ISA, CY_INTA_ROUTE,	0x0A ),	/* as per SRM */

    /* enable IDE primary interface, NB: enabling SERR here might be wrong */
    CFGWW( 0, PLAT_ISAID, CY_IDE0, IDE_COMMAND, 0x0105 ),

    /* reprogram the IDE controller registers to standard locations */
    CFGWL( 0, PLAT_ISAID, CY_IDE0, IDE_CMDADDR, 0x000001F1U ),
    CFGWL( 0, PLAT_ISAID, CY_IDE0, IDE_CTRLADDR, 0x000003F5U ),

    /* disable IDE secondary interface (no connection on board) */
    CFGWW( 0, PLAT_ISAID, CY_IDE1, IDE_COMMAND,	0x0000 ),

    OP_EOT
};

/*----------------------------------------------------------------------*/
/* Initialisation of ISA Bus and other devices hanging off a typical 
 * southbridge */

void sb_setup( void )
{
    diags_subsys_stat( SYS_ISA, DEV_PROBING );


    TblWrite( setup_cy_sb );

    SMC669Init();			/* Super-IO device initialisations */
    InitRTC();				/* Real time clock setup */

    diags_subsys_stat( SYS_ISA, DEV_SETUP );
}



/*----------------------------------------------------------------------*/
/* Fixups required during initialisation process */
void sb_fixup( void )
{
    TblWrite( setup_cy_ide );		/* enable the IDE interface */

    /* Write some information about the southbridge */
    info_submit( SRC_CHIPSET, SUBJ_CHIPSET, "Cypress southbridge revision",
	    "Rev %02X",
	    pcicfgrb( 0, PLAT_ISAID, 0, PCI_CFG_REG_REVISION_ID ) );
}



/*----------------------------------------------------------------------*/
/* I2C and System Management Bus support */


DBM_STATUS sb_i2cinit( void )
{

    TRACE( "Running...\n" );

    /* Setup code goes in here */

    return STATUS_SUCCESS;
} 




/* I2C bus read.  The bus numberings used here start at zero.
 * Read a byte from the i2c bus target specified */

DBM_STATUS sb_i2crb( uint64 node, uint64 offset, size_t bytes, uint8 *data)
{
    return STATUS_SUCCESS;
}



DBM_STATUS sb_i2cwb( uint64 node, uint64 offset, size_t bytes, uint8 *data)
{
    return STATUS_SUCCESS;
}


