/* ------------------------------------------------------------------------- */
/* i2c-cchip.c i2c-hw access for philips style parallel port adapters	     */
/* ------------------------------------------------------------------------- */
/*   Copyright (C) 1995-2000 Simon G. Vogl

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.		     */
/* ------------------------------------------------------------------------- */

/* With some changes from Kysti Mlkki <kmalkki@cc.hut.fi> and even
   Frodo Looijaard <frodol@dds.nl> */

/* $Id: i2c-cchip.c,v 1.2 2000/10/27 18:28:20 slee Exp $ */

#include <linux/kernel.h>
#include <linux/module.h>
#include <linux/delay.h>
#include <linux/malloc.h>
#include <linux/version.h>
#include <linux/init.h>

#include <asm/uaccess.h>

#include <linux/ioport.h>
#include <asm/io.h>
#include <linux/errno.h>
#include <linux/i2c-new.h>
#include <linux/i2c-algo-bit.h>

#define DEFAULT_BASE 0xfffffd01a00000c0
static unsigned long base=0;
static unsigned char PortData = 0;

/* ----- global defines -----------------------------------------------	*/
#define DEB(x)		/* should be reasonable open, close &c. 	*/
#define DEB2(x) 	/* low level debugging - very slow 		*/
#define DEBE(x)	x	/* error messages 				*/
#define DEBINIT(x) x	/* detection status messages			*/

/* --- Convenience defines for the parallel port:			*/
#define BASE	(unsigned long)(base)


/* ----- local functions ----------------------------------------------	*/

#define I2C_CKS 1
#define I2C_DS 2
#define I2C_CKR 4
#define I2C_DR 8

static void bit_cchip_setscl(void *data, int state)
{
	if (state) {
		PortData |= I2C_CKS;
	} else {
		PortData &= ~I2C_CKS;
	}
	*(unsigned long*)base = PortData;
	mb();
	//writeq(PortData, BASE);
}

static void bit_cchip_setsda(void *data, int state)
{
	if (state) {
		PortData |= I2C_DS;
	} else {
		PortData &= ~I2C_DS;
	}
	*(unsigned long*)base = PortData;
	mb();
	//writeq(PortData, BASE);
} 

static int bit_cchip_getscl(void *data)
{
	int t;
	t = (*(unsigned long*)base & I2C_CKR) == I2C_CKR;
//	printk("gs%d ", t);
	return t;
	//return (*(unsigned long*)BASE & I2C_CKR) == I2C_CKR;
}

static int bit_cchip_getsda(void *data)
{
	int t;
	t = (*(unsigned long*)base & I2C_DR) == I2C_DR;
//	printk("gd%d ", t);
	return t;

	//return readq(BASE) & I2C_DR;
}

static int bit_cchip_init(void)
{
	PortData = 0;
	bit_cchip_setsda((void*)base,1);
	bit_cchip_setscl((void*)base,1);
	if (*(unsigned long*)base != 0x8)
		return 1;
	else
		return 0;
}

static void bit_cchip_exit(void)
{
}

static int bit_cchip_reg(struct i2c_client *client)
{
	return 0;
}

static int bit_cchip_unreg(struct i2c_client *client)
{
	return 0;
}

static void bit_cchip_inc_use(struct i2c_adapter *adap)
{
#ifdef MODULE
	MOD_INC_USE_COUNT;
#endif
}

static void bit_cchip_dec_use(struct i2c_adapter *adap)
{
#ifdef MODULE
	MOD_DEC_USE_COUNT;
#endif
}

/* ------------------------------------------------------------------------
 * Encapsulate the above functions in the correct operations structure.
 * This is only done when more than one hardware adapter is supported.
 */
static struct i2c_algo_bit_data bit_cchip_data = {
	NULL,
	bit_cchip_setsda,
	bit_cchip_setscl,
	bit_cchip_getsda,
	bit_cchip_getscl,
	80, 80, 100,		/*	waits, timeout */
};

static struct i2c_adapter bit_cchip_ops = {
	"Tsunami cchip port adaptor",
	I2C_HW_B_ELV,
	NULL,
	&bit_cchip_data,
	bit_cchip_inc_use,
	bit_cchip_dec_use,
	bit_cchip_reg,
	bit_cchip_unreg,	
};

int __init i2c_bitcchip_init(void)
{
	printk("i2c-cchip.o: i2c Tsunami cchip adapter module2\n");
	if (base==0) {
		/* probe some values */
		base=DEFAULT_BASE;
		bit_cchip_data.data=(void*)DEFAULT_BASE;
		if (bit_cchip_init()==0) {
			if(i2c_bit_add_bus(&bit_cchip_ops) < 0)
				return -ENODEV;
		} else {
			return -ENODEV;
		}
	} else {
		bit_cchip_ops.data=(void*)base;
		if (bit_cchip_init()==0) {
			if(i2c_bit_add_bus(&bit_cchip_ops) < 0)
				return -ENODEV;
		} else {
			return -ENODEV;
		}
	}
	printk("i2c-cchip.o: found device at %lx.\n",base);
	return 0;
}


EXPORT_NO_SYMBOLS;

#ifdef MODULE
MODULE_AUTHOR("Simon G. Vogl <simon@tk.uni-linz.ac.at>");
MODULE_DESCRIPTION("I2C-Bus adapter routines for Tsunami cchip port adapter")
;

MODULE_PARM(base, "i");

int init_module(void)
{
	return i2c_bitcchip_init();
}

void cleanup_module(void)
{
	i2c_bit_del_bus(&bit_cchip_ops);
	bit_cchip_exit();
}

#endif
