/*---------------------------------------------------------------------
 *        [ Copyright (c) 1999 Alpha Processor Inc.] - Unpublished Work
 *          All rights reserved
 * 
 *    This file contains source code written by Alpha Processor, Inc.
 *    It may not be used without express written permission. The
 *    expression of the information contained herein is protected under
 *    federal copyright laws as an unpublished work and all copying
 *    without permission is prohibited and may be subject to criminal
 *    and civil penalties. Alpha Processor, Inc.  assumes no
 *    responsibility for errors, omissions, or damages caused by the use
 *    of these programs or from use of the information contained herein.
 *  
 *-------------------------------------------------------------------*/
/* Simple list-management module.
 * $Revision: 1.1 $
 * $Author: stig $
 */

#include <stdio.h>
#include <stdlib.h>

#include "listmgr.h"


/* If passed a NULL entity, we return a NULL list container pointer */
list_t *makelist( void *S )
{
    list_t *L=malloc( sizeof( list_t ) );
    if ( L == NULL )
    {
	/* Should we be exiting without the hwmon daemon saying goodbye? */
	fprintf( stderr, "ALLOC FAILED for new list entry!\n" );
	exit( -1 );
    }

    L->L = S;
    L->next = NULL;
    return L;
}


/* Add another datapoint to the list, allocating heap space for its list_t */
list_t *list_add( list_t *List, void *val )
{
    list_t *L = makelist( val );
    L->next = List;
    return L;
}


/* Calculate the length of a list */
size_t list_len( list_t *L )
{
    size_t len=0;
    while ( L != NULL )
    {
	len++;
	L=L->next;
    }
    return len;
}


/* Operate on the data at every point on the list (if not NULL) */
/* The operator type is void ()(void *) for easy typecasting */
void list_act( list_t *L, list_operator_t *A )
{
    while( L != NULL )
    {
        if ( L->L != NULL )
                A( L->L );
        L = L->next;
    }
}


/* This list library, when making a list, puts the latest addition to the
 * head of the list.  If you need an ordered list in the other order, 
 * here's a reversing function.
 */
list_t *list_rev( list_t *L )
{
    list_t *tmp, *head=NULL;

    while( L != NULL )
    {
	tmp = L->next;
	L->next = head;		/* add to the head of the list, make new head */
	head = L;

	/* The next list item to be reversed */
	L = tmp;
    }
    return head;
}


/* Join two lists, returning the joined result.  This code has the property
 * that the destination list (which comes second) is preserved, and the 
 * source list is reversed.
 *
 * It is important that this ordering is preserved in any reimplementation.
 */

list_t *list_join( list_t *src, list_t *dest )
{
    list_t *head = dest;
    list_t *tmp;

    while( src != NULL )
    {
	tmp = src;
	src = src->next;
	tmp->next = head;
	head = tmp;
    }

    return head;
}

