/* malloc.h -- header file for memory routines.

   This header file only exists for easier compatibility with other
   systems that provide one.  */

#ifndef _INCLUDE_MALLOC_H_
#define _INCLUDE_MALLOC_H_

#include <_ansi.h>
#include <sys/reent.h>

#define __need_size_t
#include <stddef.h>

extern _PTR malloc _PARAMS ((size_t));
extern _PTR realloc _PARAMS ((_PTR, size_t));
extern _VOID free _PARAMS ((_PTR));

extern _PTR _malloc_r _PARAMS ((struct _reent *, size_t));
extern _PTR _realloc_r _PARAMS ((struct _reent *, _PTR, size_t));
extern _VOID _free_r _PARAMS ((struct _reent *, _PTR));

extern _VOID mstats _PARAMS ((char *));
extern _VOID _mstats_r _PARAMS ((struct _reent *, char *));

#endif /* _INCLUDE_MALLOC_H_ */
