/* IODnbf.h - define interface to non-buffered driver routines
 * Copyright  1997-1999 by Object Software Inc. - All Rights Reserved
 *
 * The authors hereby grant permission to use, copy, modify, distribute,
 * and license this software and its documentation for any purpose, provided
 * that existing copyright notices are retained in all copies and that this
 * notice is included verbatim in any distributions. No written agreement,
 * license, or royalty fee is required for any of the authorized uses.
 */

#ifndef	IODNBF_H
#define	IODNBF_H

#ifdef __cplusplus
extern "C" {
#endif

#include <sys/IODev.h>
#include <stdarg.h>

/* define the tNonBufferedDevice structure which stores the required info about the device */
typedef struct sNonBufferedDevice
{
	int (*DataAvailable) (tIODev *Device);		// return non-zero if char available
	int (*TXReady) (tIODev *Device);			// return non-zero if transmitter ready
	int (*InByte) (tIODev *Device);				// get next input char
	void (*OutByte) (tIODev *Device, int Char);	// put next output char
	void *DeviceInfo;							// for device-specific info; not used by drivers
} tNonBufferedDevice;

/* Implement drivercontrol () functionality for non-buffered devices. */
int NBdrivercontrol (struct sIODev *Device, int filedes, int function, va_list args);

/* Implement read () functionality for non-buffered devices.
 * CR->LF translation, line editing, and character echo are implemented.
 */
extern int NBread (struct sIODev *Device, int filedes, void *_buf, size_t _nbyte);

/* Implement write () function for non-buffered devices.
 * LF->CRLF translation is implemented.
 */
extern int NBwrite (struct sIODev *Device, int filedes, const void *_buf, size_t _nbyte);

#ifdef __cplusplus
}
#endif

#endif

