; HP 9895A floppy disk firmware
; Partially reverse-engineered by Eric Smith <spacewar@gmail.com>
; and Craig Ruff

; Cross-assembles with Macro Assembler AS:
;   http://john.ccac.rwth-aachen.de:8000/as/

fillto  macro   endaddr, value
          db	(endaddr-$) dup (value)
	endm

bmask   function msb, lsb, ((1<<(msb-lsb+1))-1)<<lsb

bdef    macro bnum, name, globalsymbols
        equ name, bnum
        equ name_m, 1 << bnum
        endm

bfield  macro msb, lsb, name
        equ name_m, bmask(msb, lsb)
        equ name_shift, lsb
        endm

; IY based offsets to RAM locations
YB      function s, s-ramstart

; The asl assembler seems to have a problem with ~value for a byte size operand
; so this masks the not result so no complaint is generated.
BYTENOT function v, (~v & 0ffh)
