; HP 9895A floppy disk firmware
; Partially reverse-engineered by Eric Smith <spacewar@gmail.com>
; and Craig Ruff

; Cross-assembles with Macro Assembler AS:
;   http://john.ccac.rwth-aachen.de:8000/as/

; Amigo ICD
        equ     DSJ_SAD, TLK_m | 10h

; HP-300 Clear
        equ     HP300_CLEAR_SAD, 10h
        bdef    0, ENABLE_PARITY_CHECK  ; fist byte after secondary device clear


        bdef    7, STEP_OUT             ; C bit 7: 1 = step towards cylinder 0

        equ     NUNITS, 4

; do_talk_transfer B register bits
        bdef    1, FLUSH_FIFO
        bdef    0, SEND_EOI

; In-Use LED Patterns
        equ     IU_WAIT, 02h    ; waiting for a command and monitoring drive status (END cmd)
        equ     IU_SEND, 04h    ; sending data to host system
        equ     IU_RECV, 06h    ; receiving data from host system
        equ     IU_STAT, 08h    ; determining status and format from selected unit
        equ     IU_LOAD, 0ah    ; loading heads on a drive
        equ     IU_SAD,  0ch    ; waiting for a secondary HP-IB command
        equ     IU_FMT,  0eh    ; formatting a track
        equ     IU_WAIT_DSJ, 10h ; waiting for command show DSJ value
        equ     IU_VFY,  18h    ; executing VERIFY command
        equ     IU_STEP, 1ah    ; moving the heads one track
        equ     IU_WRT,  1ch    ; writing a sector
        equ     IU_READ, 1eh    ; reading a sector

; Disc format defines
        equ     PHYSICAL_TRACKS, 77

        equ     HP_LOWCURR_START_TRACK, 43
        equ     HP_PRECMP_START_TRACK, 55
        equ     HP_BYTES_PER_SECTOR, 256
        equ     HP_FIRST_SECTOR, 0
        equ     HP_SECTORS_PER_TRACK, 30
        equ     HP_AM_CLK,                       0eh
        equ     HP_ID_AM_DPAT,                   70h
        equ     HP_DEFECTIVE_TRACK_AM_DPAT,     0f0h
        equ     HP_DATA_AM_DPAT,                 50h
        equ     HP_ECC_DATA_AM_DPAT,            0d0h    ; NOTE: Unused
        equ     HP_DEFECTIVE_TRACK_MARKER,      0ffh

        equ     IBM_BYTES_PER_SECTOR, 128
        equ     IBM_FIRST_SECTOR, 1
        equ     IBM_SECTORS_PER_TRACK, 26
        equ     IBM_INDEX_AM_CLK,               0d7h
        equ     IBM_INDEX_AM_DPAT,              0fch

        equ     IBM_AM_CLK,                     0c7h
        equ     IBM_ID_AM_DPAT,                 0feh
        equ     IBM_DATA_AM_DPAT,               0fbh
        equ     IBM_DELETED_DATA_AM_DPAT,       0f8h
        equ     IBM_GAP_DPAT,                   0ffh

; IC notes
; U21 is 3-to-8 demux
; U30, U31, U86, U87 are 74LS174 or equiv
; U32, U33, U47, U48 are 74LS253 or equiv
; U35, U36 are 1KiBx4 RAM
; U66 is 74175 or equiv quad FF
; U71 appears to be a ROM used for precompensation and write bit stream generation
; U77 is 74F401 or equiv CRC chip

; wait_for_sector defines
; sector I/O status bits
        bdef    7, SIO_D_WRONG_SECTOR
        bdef    6, SIO_D_WRONG_TRACK
        bdef    5, SIO_D_WRONG_HEAD
        bdef    5, SIO_D_BIT5                   ; IBM format
        bdef    4, SIO_D_BIT4                   ; IBM format
        bdef    1, SIO_D_WFS_FAILED
        bdef    0, SIO_D_SECTOR_FOUND

        ;       6, OVERUN
        ;       5, CRCERR
        bdef    4, SIO_E_NOT_READY
        bdef    3, SIO_E_3
        bdef    2, SIO_E_DEFECTIVE_SECTOR
        bdef    1, SIO_E_1                      ; retries exhausted?
        bdef    0, SIO_E_SCE

; ***************************************************************
; * 9895A RAM ADDRESS SPACE                                     *
; ***************************************************************

; DriveData - a per-drive data structure (pointed to by IX)
DriveData struct dots
; +0
physical_cylinder ds 1

; +1
current_cyl_hd  ds 1    ; bit 7: HEAD1
                        ; bits 6..0: cylinder number

; +2
target_cyl_hd   ds 1    ; bit 7: HEAD1
                        ; bits 6..0: cylinder number

; +3
sector          ds 1    ; current sector

; +4
drv             ds 1    ; drv register shadow
                                        ; bit 7: HEAD1 (init 0)
                                        ; bit 6: ? (init 0 NC in drv reg)
                bdef    5, DOOR_LOCK    ; bit 5: door lock (init 0 NC in drv reg)
                                        ; bit 4: LOWCURR (init 0)
                                        ; bit 3: HEADLOAD (init 0)
                                        ; bit 2: MGNENA (init 0)
                                        ; bit 1: MOVEIN? (init 0)
                                        ; bit 0: STEP? (init 0)

; +5
stat2           ds 1    ; saved stat2           (usually loaded into E)
                bdef    7, STAT2_ERROR  ; bit 7: Stat 2 error (E, C or SS bits are set)
                                        ; bit 6: copy of OVERUN? (see turn_off_get_status)
                                        ; bit 5: copy of CRCERR? (see turn_off_get_status)
                bfield  4, 1, DISC_TYPE ; bits 4..1: (disc type)
                bdef    4, DT_IBM       ; TTTT IBM format bit
                bdef    3, DT_DS        ; TTTT double sided bit
                bdef    2, DT_HP        ; TTTT HP format bit
                bdef    1, DT_BLANK     ; TTTT blank or unknown format
                equ     DT_EMPTY, 0     ; TTTT empty drive
                bdef    0, STAT2_RSVD   ; bit 0: reserved

; +6
stat2_ds        ds 1    ; saved stat2_ds        (usually loaded into D)
                bdef    7, STAT2_A      ; bit 7: A (attention)
                bdef    6, STAT2_W      ; bit 6: W (write protect)
                bdef    5, STAT2_UNDOC  ; bit 5: ?
                bdef    4, STAT2_E      ; bit 4: E (drive fault)
                bdef    3, STAT2_F      ; bit 3: F (first status/no disc?)
                bdef    2, STAT2_C      ; bit 2: C (seek check)

                bfield  1, 0, SS        ; bits 1..0: SS (drive ready status)
                equ     SS_READY, 0
                equ     SS_UNDEF, 1
                equ     SS_NO_DRV, 2
                equ     SS_NO_DISC, 3
                bdef    1, SS_NOT_READY ; Either not ready status

; +7
unload_timer    ds 1    ; unload timer (approx seconds?)

; +8
unload_ticks    ds 1    ; unload timer ticks (1/256th second units?)

; +9
xv              ds 1    ; xv register shadow
                bdef    7, XV_SHDW_DISCHNG      ; bit 7: remembered DISCHNG
                                                ; bits 5..0: drive specific xv reg value bits
DriveData endstruct

; using a section causes extra work for symbol visibility, for now I'll skip it.
;       section ram

ramstart equ 6000h
ramsize  equ 0400h
ramend   equ ramstart + ramsize - 1

        org     ramstart

DSJ:            ds 1    ; the current DSJ byte
                equ DSJ_normal, 0
                equ DSJ_aborted, 1
                equ DSJ_holdoff, 2
                equ DSJ_parity_error, 3

S1:	        ds 1    ; the stat2 S1 value
                ; DEFINE S1 codes here
                equ     S1_NORMAL, 00h  ; normal completion
                equ     S1_ILL_OP, 01h  ; illegal opcode
                equ     S1_CCE, 07h     ; cylinder compare error
                equ     S1_UDE, 08h     ; uncorrectable data error
                equ     S1_SCE, 09h     ; sector compare error
                equ     S1_IPE, 0ah     ; I/O program error
                equ     S1_DTE, 11h     ; defective track or sector
                equ     S1_RHE, 12h     ; retryable hardware error
                equ     S1_S2E, 13h     ; Stat 2 error
                equ     S1_UA,  17h     ; unit unavailable
                equ     S1_DA,  1fh     ; drive attention
                bdef    5, S1_DBIT

S1_unit:        ds 1    ; unit associated with S1 value?

current_unit:   ds 1    ; Which unit was selected by get_drive_data_ptr?

commanded_unit: ds 1    ; Which unit is being manipulated by a command? 4 = none

state_flags:    ds 1
                bdef    5, LISTEN_ACT           ; HP-IB listen transfer active
                bdef    4, TALK_ACT             ; HP-IB talk transfer active
                bdef    2, DBIT_ON              ; bit 2: DBIT was set in the Initialize command
                bdef    1, SECTOR_IO_RETRY      ; also use during formatting?
                bdef    0, SELF_TEST_ACTIVE

head_unload_set: ds 1   ; drives that have loaded heads and are not door locked
                        ; (drive select bit mask)

leds_shdw:      ds 1

monitor_U6_shdw:
                ds 1

disc_format:    ds 1
                equ     FORMAT_HP, 0
                bdef    0, FORMAT_IBM
                bdef    1, FORMAT_UNKNOWN

listen_transfer_final_d0d1:
                ds 1

target_cyl_hd:  ds 1

parity_check_state:
                ds 1

previous_format:
tmp_unit:       ds 1
fmt_data_2:     ds 1    ; format_track stores 2nd byte of format_data_tbl entry here
fmt_data_1:     ds 1    ; format_track stores 1st byte of format_data_tbl entry here
format_phys_sector:
                ds 1
fmt_sector_count:         ; how many sectors remain to format in the track
                ds 1
format_flags:   ds 1
                bdef    7, FF_DATA_INIT       ; the sector interleave table and sector format buffer have been initialized

test_flags:     ds 1
                bdef    3, WR_TEST_ACTIVE       ; bit 3: WR TEST SW state
                                                ; bit 4: set at cold start
                                                ; bits 1..0: a counter?

current_head:   ds 1

test_jmptbl_ptr: dw ?

in_use_leds_stack_ptr:  dw ?       ; ptr into in_use_leds_stack
in_use_leds_stack:      ds 5

drive_data_table:  DriveData [4]        ; the per-drive DriveData array

; NOTE: potentially everything from cmd_buffer to cmd_buffer + 255
; could be overwritten if a controller sends bytes to us after a listen
; SAD handled by do_listen_cmds.

cmd_count:      ds 1       ; transfer byte count
cmd_buffer:
cmd_opcode:     ds 1	; first byte of Amigo command
cmd_unit:       ds 1	; second byte of Amigo command
cmd_3:          ds 1	; third byte of Amigo command
cmd_4:          ds 3	; fourth through sixth bytes of Amigo command

        equ     format_type, cmd_buffer + 2
        bdef    7, FORMAT_OVERRIDE
        bfield  6, 0, FORMAT_WANTED_TYPE
        equ     FORMAT_TYPE_HP, 2
        equ     FORMAT_TYPE_IBM, 8

        bdef    5, INIT_DBIT                            ; for Initialize

        equ     format_interleave, cmd_buffer + 3
        equ     format_data_byte, cmd_buffer + 4

        equ     seek_cylinder_msb, cmd_buffer + 2
        equ     seek_cylinder_lsb, cmd_buffer + 3
        equ     seek_head, cmd_buffer + 4
        equ     seek_sector, cmd_buffer + 5

        equ     stat1, cmd_buffer
        equ     stat1_unit, cmd_buffer + 1
        equ     stat2, cmd_buffer + 2
        equ     stat2_ds, cmd_buffer + 3

        equ     verify_count_msb, cmd_buffer + 2
        equ     verify_count_lsb, cmd_buffer + 3

        equ     clr_hd_sect, cmd_buffer + 1

data_buffer_count:      ds 1
data_buffer:            ds 256     ; 256 bytes x604e to x614d
        equ download_code_entry, data_buffer + 2

        equ sector_table, data_buffer_count     ; for formatting tracks


x606b	equ 606bh
format_sector_buffer	equ 606bh
x60b4	equ 60b4h

	org	ramend - 3
penultimate_stack_word: ds 1
tsterr_sp:              ds 1
highest_stack_word:     ds 1

;       endsection ram
