/*
TAPEINFO is a Linux utility to dump the inquiry and log pages of the
Hewlett-Packard C1533A tape drive.

Copyright 1995 Eric L. Smith

TAPEINFO is free software; you can redistribute it and/or modify it under the
terms of the GNU General Public License version 2 as published by the Free
Software Foundation.  Note that I am not granting permission to redistribute
or modify TAPEINFO under the terms of any later version of the General Public
License.

This program is distributed in the hope that it will be useful (or at least
amusing), but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General
Public License for more details.

You should have received a copy of the GNU General Public License along with
this program (in the file "COPYING"); if not, write to the Free Software
Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

$Header: /usr/home/kolwynia/eric/tapeinfo/RCS/inquiry.c,v 1.5 1995/09/11 18:20:50 eric Exp eric $
*/

#include <stdio.h>

#include "tapeinfo.h"
#include "scsicmd.h"
#include "inquiry.h"

#define MIN_INQUIRY_RESULT_LEN 32

void do_inquiry (FILE *f, int fd)
{
  unsigned long count;

  unsigned char mfg [9];
  unsigned char model [17];

  unsigned char cmd [] = { T_INQUIRY,
			    0x00,  /* LUN */
			    0x00,  /* page code if EVPD were set */
			    0x00,  /* reserved */
			    0xff,  /* allocation length */
			    0x00   /* control */
			};

  count = scsi_command (fd, cmd, sizeof (cmd), buf1, 0xff);

  if (count >= MIN_INQUIRY_RESULT_LEN)
    {
      mfg [8] = '\0';
      model [16] = '\0';

      strncpy (mfg,   & buf1 [8],  8);
      strncpy (model, & buf1 [16], 16);

      printf ("Type: %d\n", buf1 [0]);
      printf ("Manufacturer: %s\n", mfg);
      printf ("Device: %s\n", model);
    }

  hex_dump (stdout, buf1, count);
}


void print_inquiry_page (FILE *f, int fd, unsigned char page)
{
  unsigned long count, len;
  int i;

  unsigned char cmd [] = { T_INQUIRY,
			    0x01,  /* LUN & EVPD */
			    0x00,  /* start with supported vital product pages */
			    0x00,  /* reserved */
			    0xff,  /* allocation length */
			    0x00   /* control */
			};

  fprintf (f, "Inquiry page %02x:\n", page);
  cmd [2] = page;
  count = scsi_command (fd, cmd, sizeof (cmd), buf2, 0xff);
  len = buf2 [3] + 4;

  hex_dump (f, buf2, len);
}


void print_inquiry_pages (FILE *f, int fd, int all)
{
  unsigned long count, len;
  int i;
  int page;

  unsigned char cmd [] = { T_INQUIRY,
			    0x01,  /* LUN & EVPD */
			    0x00,  /* start with supported vital product pages */
			    0x00,  /* reserved */
			    0xff,  /* allocation length */
			    0x00   /* control */
			};

  count = scsi_command (fd, cmd, sizeof (cmd), buf1, 0xff);
  len = buf1 [3] + 4;

  if (! all)
    fprintf (f, "Available inquiry pages:\n");
  for (i = 0; i < (len - 4); i++)
    {
      page = buf1 [i + 4];
      if (all)
	{
	  print_inquiry_page (f, fd, page);
	  fprintf (f, "\n");
	}
      else
	fprintf (f, "%02x ", page);
    }
  if (! all)
    fprintf (f, "\n");
}
