/*
TAPEINFO is a Linux utility to dump the inquiry and log pages of the
Hewlett-Packard C1533A tape drive.

Copyright 1995 Eric L. Smith

TAPEINFO is free software; you can redistribute it and/or modify it under the
terms of the GNU General Public License version 2 as published by the Free
Software Foundation.  Note that I am not granting permission to redistribute
or modify TAPEINFO under the terms of any later version of the General Public
License.

This program is distributed in the hope that it will be useful (or at least
amusing), but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General
Public License for more details.

You should have received a copy of the GNU General Public License along with
this program (in the file "COPYING"); if not, write to the Free Software
Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

$Header: /usr/home/kolwynia/eric/tapeinfo/RCS/scsicmd.h,v 1.1 1995/09/11 18:20:50 eric Exp eric $
*/

int scsi_command (int fid,
		  unsigned char *command,
		  int cmd_len,
		  unsigned char *reply,
		  int reply_len);

/*
 * returns count of bytes read,
 * -1 for error writing command,
 * -2 for error reading reply,
 * -3 for non-zero result code
 */



/* tape command codes */

#define T_TEST_UNIT_READY 0x00
#define T_REWIND 0x01
#define T_REQUEST_BLOCK_ADDRESS 0x02
#define T_REQUEST_SENSE 0x03
#define T_READ_BLOCK_LIMITS 0x05
#define T_READ 0x08
#define T_WRITE 0x0a
#define T_SEEK_BLOCK 0x0c
#define T_READ_REVERSE 0x0f
#define T_WRITE_FILE_MARKS 0x10
#define T_SPACE 0x11
#define T_INQUIRY 0x12
#define T_VERIFY 0x13
#define T_RECOVER_BUFFERED_DATA 0x14
#define T_MODE_SELECT 0x15
#define T_RESERVE_UNIT 0x16
#define T_RELEASE_UNIT 0x17
#define T_COPY 0x18
#define T_ERASE 0x19
#define T_MODE_SENSE 0x1a
#define T_LOAD_UNLOAD 0x1b
#define T_RECEIVE_DIAGNOSTIC_RESULTS 0x1c
#define T_SEND_DIAGNOSTIC 0x1d
#define T_PREVENT_ALLOW_MEDIUM_REMOVAL 0x1e
#define T_LOCATE 0x2b
#define T_READ_POSITION 0x34
#define T_COMPARE 0x39
#define T_COPY_AND_VERIFY 0x3a
#define T_WRITE_BUFFER 0x3b
#define T_READ_BUFFER 0x3c
#define T_CHANGE_DEFINITION 0x40
#define T_LOG_SELECT 0x4c
#define T_LOG_SENSE 0x4d
