: 'Copyright 1986 Intel Corp.'
# Agrpxd.ss, build raw transaction for "Delete group"
#
# ignore the quit signals
trap "" 1 2 3 15
#
Ausr=$1
export Ausr
if [ -f $MASNODEP/etc/passwd ] ; then :
else
   echo The master password file on node $MASNODE could not be accessed.
   echo You must try again later when connection is established.
   exit 1
fi

if egrep \^$Ausr: $MASNODEP/etc/passwd > /dev/null 2>&1 ; then : 
else
   echo
   echo Group $Ausr does not exist in the master password file.
   echo
   exit 1
fi
# The following code added for patchkit 2.0  ...  ajw
# Only allows delete if HOME starts "/usr..."  or "//<node>/usr..."
# and the next component of path is not in the list below.
# Sets the Home File System, from HOME
# HOME=//node/filesystem/loginid  or  /filesystem/loginid
dir=`Uselect -s : 5 0 $Ausr <$MASNODEP/etc/passwd`
case -$dir in
	-) ;;
	-//*)	HomeNode=`$iDISBIN/Ustripnode $dir`
                nextcomp=`echo $dir | Uselect -es / 4 3 '^usr'`
		HomeFS=`dirname \`expr $dir : "//.*/\(.*/.*\)"\``
	;;
	-*)	HomeNode=$MASNODE
		nextcomp=`echo $dir | Uselect -es / 2 1 '^usr'`
		HomeFS=`dirname \`expr $dir : "/\(.*/.*\)"\``
	;;
esac

grouptype=`Uselect -s : 1 0 $Ausr <$MASNODEP/etc/passwd`

while :
do
   echo "\nConfirm that you wish to delete the group $Ausr"
   echo -n "Enter (y or n): "
   read resp
   case $resp in
      y*|Y*)	break ;;
      n*|N*)	echo "\nDeletion process for group $Ausr has been canceled."
		exit 1 ;;
      *)	echo "\nInvalid response <$resp>, please respecify." ;;
   esac
done

# Remove the group from the master passwd file
while :
do
#   /iDISboot/Flock -r $MASNODEP/etc/passwd \
#      -e /iDISboot/Ar /iDISboot/AUpw.ss RESTART
   /iDISboot/Ar /iDISboot/AUpw.ss RESTART
   case $? in
      201) sleep 5;;	# files aren't available
      202) echo The master password file on node $MASNODE could not be accessed.
	   echo You must try again later when connection is established.
	   exit 1 ;;
      *)   break  ;;
   esac
done

# Remove the group from the master group file
   /iDISboot/Ar /iDISboot/AWgrp.ss RESTART

# build the raw transaction file, signal pending
>   /usr/tmp/$LOGINID.idisP
RAW=/usr/tmp/$LOGINID.idisW
cat <<-HERE >> $RAW
	#( Delete group $Ausr
	Kind=group
	Ttype=Xdel
	OPENNET="$OPENNET"
	MASNODE="$MASNODE"
	MASNODEP="$MASNODEP"
	Ausr="$Ausr"
	Aepw="$grouptype"
	HomeFS="$HomeFS"
	HomeNode="$HomeNode"
	export Kind Ttype OPENNET MASNODE MASNODEP Ausr HomeFS HomeNode
	#) Delete group $Ausr
HERE

exit 0
