: 'Copyright 1986 Intel Corp.'
# create/delete user's group's common home node information
# Runs on the home node itself.
# This is called with an environment that contains most of the user's info.
# 03/15/86 oer
# 03/30/86 oer misc. cleanup
# 04/23/86 oer modify for file management
# 04/27/86 oer change MODE, until we decide further on user-to-user copy
# 05/12/86 oer correct problem when removing non-existent directory
# 05/13/86 rhc add PATH for Ar usage
# 05/16/86 oer combine mkdir's to speed up processing, recombine APPLY's
# 05/16/86 oer add a notrace capability, for initial installation
# 06/25/86 gll correct workding that goes into .func, .mac files.
# 07/14/86 oer change name of Lyrix directory
# 07/16/86 oer allow for ugrade of 1.6 users to 2.0
# 08/12/86 oer change user's home directory permissions, to allow for iDESK

PATH=/bin:/usr/bin	export PATH

# provide an execution trace, in case of error
[ -z "$NOTRACE" ] && set -x

# Ensure any errors stop processing
set -e
PARM1=$1
case $PARM1 in
   # MKDIR
   MKDIR)
	case $# in
	   2)	case $Olduser in
		   yes) # if this is an existing user, there is a chance that
		       # he already has these files, I need to create new
		       # versions of them.
		       chmod 777 $2
		       [ -f $2/.profile ] && chmod 777 $2/.profile
		       [ -f $2/.login ]   && chmod 777 $2/.login
		       [ -f $2/.cshrc ]   && chmod 777 $2/.cshrc
		       [ -f $2/.mailrc ]  && chmod 777 $2/.mailrc
		   ;;
		   *) mkdir $2
		      chmod 777 $2 ;;
		esac
		exit 0 ;;
	   *)	exit 1 ;;
	esac
   ;;

   # APPLY
   APPLY)
	# umask has been previously set, to ensure proper permissions
	# umask reflects permissions needed for directories NOT file
	case $Kind in
		user)
			# if this is an old user, set files we changed back
			# and exit.  He already has the rest of the directories
			case $Olduser in
			   yes) chmod 700   ./.profile ./.login ./.cshrc ./.mailrc
				chown $Auid ./.profile ./.login ./.cshrc ./.mailrc
				chgrp $Gid  ./.profile ./.login ./.cshrc ./.mailrc
				chmod 700 .
				exit 0 ;;
			esac

			# create user action control files  02/11/86 gll
			for n in 1 2 3 4 5 6 7 8 ; do
				cat <<-HERE > .func$n
					User action $n is not defined
				HERE
                                # The macro commands below must match
                                # /usr/iDIS/idis/control/Ufunc.mac
				cat <<-HERE > .${n}.mac
:clear
:echo -9 \
"#                                                                          @"
:echo -10 \
"#               @ This user action has not been defined. #                 @"
:echo -11 \
"#                                                                          @"
:echo -12 \
"#               @ Use the 'qdef - Define user actions'   #                 @"
:echo -13 \
"#               @ selection to define this user action.  #                 @"
:echo -14 \
"#                                                                          @"
:hold
				HERE
			done
			> calendar
			# must be readable by all to get the reminder service
			chmod a+r calendar
			chmod 700 .func[1-8] .[1-8].mac
			# create the users mail file, otherwise if the mail
			# command creates it, it will be readable by others
			> /usr/spool/mail/$Ausr
			chmod 700   /usr/spool/mail/$Ausr
			chown $Auid /usr/spool/mail/$Ausr
			chgrp $Gid  /usr/spool/mail/$Ausr ;;
	esac

	# make the idis and rje directories,
	# set the owner and group ids for the files in the HOME directory

	mkdir idis_dir idis_dir/db_dir idis_dir/hj_dir idis_dir/hs_dir \
	idis_dir/ss_dir idis_dir/ss_dir/.mdl_dir idis_dir/wp_dir \
	idis_dir/wp_dir/FileCabinet idis_dir/wp_dir/FileCabinet/PUBLIC \
	idis_dir/xl_dir idis_dir/xn_dir

	chmod 777 idis_dir/wp_dir/FileCabinet/PUBLIC # for file transfers

	# make the rje directories for the user.
	mkdir rje_dir rje_dir/ho_dir rje_dir/xd_dir rje_dir/xs_dir

	# make the additional software directories
	mkdir asw_dir asw_dir/ghop_dir asw_dir/htbg_dir asw_dir/lyrx_dir \
	asw_dir/mcba_dir asw_dir/pbg_dir asw_dir/cmst_dir asw_dir/Qoff_dir \
	asw_dir/rds_dir asw_dir/traj_dir

	# set ownerships
	/iDISboot/Frecur -O $Auid -G $Gid .

	case $Kind in
		user)
			echo "Welcome to iDIS!" | mail $Ausr

			MODE=711 ;;  # Need the 1's for group scheduling
		group)
			case $Aepw in
				iDISGROUP)  MODE=770 ;;
				iDISPUBLIC) MODE=777 ;;
			esac  ;;
	esac
	# change HOME directory attributes from 777
	chmod $MODE .
   ;;

   # RESTART
   RESTART)
	# O.K. for errors
	set +e
	case $Olduser in
	   yes) exit 0
	esac

	rm -rf /$HomeFS/$Ausr
	rm -f  /usr/spool/mail/$Ausr
   ;;
esac
