################################################################################
# Apsetserial.ss spawns a process in background to hold baudrate of all serial #
#             printers to the rate specified in the /etc/printcap file         #
#             To be executed from the rc file when the system is booted up     #
################################################################################
# Copyright Intel Corp. 1986
TEMPFILE=/usr/tmp/Apsetser$$
trap "rm -rf $TEMPFILE;trap 0; exit 0" 0 1 2 3 15
PATH=/bin:/usr/bin:/iDISboot	export PATH
awk ' $1 != "#" { print $1 } ' /etc/printcap  |
awk -F: ' $1 != "" {print $1}' |
awk -F\| '{print $1} ' |
while read printername 
do
	PORT=`Aprintcap lp $printername`
	echo $PORT | Uselect -s / -e 0 2 '^tty' > /dev/null
	if [ $? -eq 1 ]; then
		SPEED=`Aprintcap br $printername`
		if [ $SPEED != 9600 ]; then
			echo $PORT $SPEED>>$TEMPFILE
		fi
	fi
done
if [ -f $TEMPFILE ]; then
	set `cat $TEMPFILE`
	Apsetbaud $*&
fi
